/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.LinkedHashCollectionHelper;
import org.odmg.DMap;

public class Map
extends PersistentCollection
implements java.util.Map,
DMap {
    java.util.Map map;

    protected Serializable snapshot(CollectionPersister persister) throws HibernateException {
        HashMap clonedMap = new HashMap(this.map.size());
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            clonedMap.put(e.getKey(), persister.getElementType().deepCopy(e.getValue()));
        }
        return clonedMap;
    }

    public Collection getOrphans(Serializable snapshot) throws HibernateException {
        java.util.Map sn = (java.util.Map)((Object)snapshot);
        ArrayList result = new ArrayList(sn.values());
        PersistentCollection.identityRemoveAll(result, this.map.values(), this.getSession());
        return result;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        java.util.Map xmap = (java.util.Map)((Object)this.getSnapshot());
        if (xmap.size() != this.map.size()) {
            return false;
        }
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!elementType.isDirty(entry.getValue(), xmap.get(entry.getKey()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isWrapper(Object collection) {
        return this.map == collection;
    }

    public Map(SessionImplementor session) {
        super(session);
    }

    public Map() {
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.map = persister.hasOrdering() ? LinkedHashCollectionHelper.createLinkedHashMap() : new HashMap();
    }

    public Map(SessionImplementor session, java.util.Map map) {
        super(session);
        this.map = map;
        this.setInitialized(true);
        this.setDirectlyAccessible(true);
    }

    public int size() {
        this.read();
        return this.map.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.read();
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.read();
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        this.read();
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.write();
        return this.map.put(key, value);
    }

    public Object remove(Object key) {
        this.write();
        return this.map.remove(key);
    }

    public void putAll(java.util.Map puts) {
        if (puts.size() > 0) {
            this.write();
            this.map.putAll(puts);
        }
    }

    public void clear() {
        this.write();
        this.map.clear();
    }

    public Set keySet() {
        this.read();
        return new PersistentCollection.SetProxy(this, this.map.keySet());
    }

    public Collection values() {
        this.read();
        return new PersistentCollection.SetProxy(this, this.map.values());
    }

    public Set entrySet() {
        this.read();
        return new EntrySetProxy(this.map.entrySet());
    }

    public boolean empty() {
        return this.map.isEmpty();
    }

    public String toString() {
        this.read();
        return this.map.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        Map.Entry e = (Map.Entry)entry;
        persister.writeElement(st, e.getValue(), writeOrder, this.getSession());
        persister.writeIndex(st, e.getKey(), writeOrder, this.getSession());
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, this.getSession());
        Object index = persister.readIndex(rs, this.getSession());
        this.map.put(index, element);
        return element;
    }

    public Iterator entries() {
        return this.map.entrySet().iterator();
    }

    public Map(SessionImplementor session, CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        super(session);
        this.beforeInitialize(persister);
        Serializable[] array = (Serializable[])disassembled;
        for (int i = 0; i < array.length; i += 2) {
            this.map.put(persister.getIndexType().assemble(array[i], session, owner), persister.getElementType().assemble(array[i + 1], session, owner));
        }
        this.setInitialized(true);
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Serializable[] result = new Serializable[this.map.size() * 2];
        Iterator iter = this.map.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            result[i++] = persister.getIndexType().disassemble(e.getKey(), this.getSession());
            result[i++] = persister.getElementType().disassemble(e.getValue(), this.getSession());
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        ArrayList deletes = new ArrayList();
        Iterator iter = ((java.util.Map)((Object)this.getSnapshot())).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            Object key = e.getKey();
            if (e.getValue() == null || this.map.get(key) != null) continue;
            deletes.add(key);
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        java.util.Map sn = (java.util.Map)((Object)this.getSnapshot());
        Map.Entry e = (Map.Entry)entry;
        return e.getValue() != null && sn.get(e.getKey()) == null;
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        java.util.Map sn = (java.util.Map)((Object)this.getSnapshot());
        Map.Entry e = (Map.Entry)entry;
        Object snValue = sn.get(e.getKey());
        return e.getValue() != null && snValue != null && elemType.isDirty(snValue, e.getValue(), this.getSession());
    }

    public Object getIndex(Object entry, int i) {
        return ((Map.Entry)entry).getKey();
    }

    public boolean equals(Object other) {
        this.read();
        return ((Object)this.map).equals(other);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.map).hashCode();
    }

    public boolean entryExists(Object entry, int i) {
        return ((Map.Entry)entry).getValue() != null;
    }

    final class MapEntryProxy
    implements Map.Entry {
        private final Map.Entry me;

        MapEntryProxy(Map.Entry me) {
            this.me = me;
        }

        public Object getKey() {
            return this.me.getKey();
        }

        public Object getValue() {
            return this.me.getValue();
        }

        public boolean equals(Object o) {
            return ((Object)this.me).equals(o);
        }

        public int hashCode() {
            return ((Object)this.me).hashCode();
        }

        public Object setValue(Object value) {
            Map.this.write();
            return this.me.setValue(value);
        }
    }

    final class EntryIteratorProxy
    implements Iterator {
        private final Iterator iter;

        EntryIteratorProxy(Iterator iter) {
            this.iter = iter;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return new MapEntryProxy((Map.Entry)this.iter.next());
        }

        public void remove() {
            Map.this.write();
            this.iter.remove();
        }
    }

    class EntrySetProxy
    implements Set {
        private final Set set;

        EntrySetProxy(Set set) {
            this.set = set;
        }

        public boolean add(Object entry) {
            return this.set.add(entry);
        }

        public boolean addAll(Collection entries) {
            return this.set.addAll(entries);
        }

        public void clear() {
            Map.this.write();
            this.set.clear();
        }

        public boolean contains(Object entry) {
            return this.set.contains(entry);
        }

        public boolean containsAll(Collection entries) {
            return this.set.containsAll(entries);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new EntryIteratorProxy(this.set.iterator());
        }

        public boolean remove(Object entry) {
            Map.this.write();
            return this.set.remove(entry);
        }

        public boolean removeAll(Collection entries) {
            Map.this.write();
            return this.set.removeAll(entries);
        }

        public boolean retainAll(Collection entries) {
            Map.this.write();
            return this.set.retainAll(entries);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] array) {
            return this.set.toArray(array);
        }
    }
}

