/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private static final String HIBERNATE_ALIAS_STEM = "proxool.hibernate-";
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$ProxoolConnectionProvider == null ? (class$net$sf$hibernate$connection$ProxoolConnectionProvider = ProxoolConnectionProvider.class$("net.sf.hibernate.connection.ProxoolConnectionProvider")) : class$net$sf$hibernate$connection$ProxoolConnectionProvider));
    private static int aliasCount;
    private String proxoolAlias;
    private boolean existingPool;
    static /* synthetic */ Class class$net$sf$hibernate$connection$ProxoolConnectionProvider;

    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.proxoolAlias);
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jaxpFile = props.getProperty("hibernate.proxool.xml");
        String propFile = props.getProperty("hibernate.proxool.properties");
        String externalConfig = props.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = props.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            log.info((Object)("Configuring Proxool Provider using existing pool in memory: " + this.proxoolAlias));
        } else if (StringHelper.isNotEmpty(jaxpFile)) {
            log.info((Object)("Configuring Proxool Provider using JAXPConfigurator: " + jaxpFile));
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            try {
                JAXPConfigurator.configure((String)jaxpFile, (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load JAXP configurator file: " + jaxpFile;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info((Object)("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias));
        } else if (StringHelper.isNotEmpty(propFile)) {
            log.info((Object)("Configuring Proxool Provider using Properties File: " + propFile));
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String msg = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            try {
                PropertyConfigurator.configure((String)props.getProperty(propFile));
            }
            catch (ProxoolException e) {
                String msg = "Proxool Provider unable to load load Property configurator file: " + propFile;
                log.fatal((Object)msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info((Object)("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias));
        } else {
            log.info((Object)"Configuring Proxool Provider using Hibernate properties");
            String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
            String jdbcUrl = props.getProperty("hibernate.connection.url");
            Properties proxoolProps = ProxoolConnectionProvider.extractProxoolProperties(props);
            log.info((Object)("Proxool Provider properties: " + proxoolProps));
            Properties connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
            log.info((Object)("Delegate JDBC Driver Connection properties: " + connectionProps));
            Properties finalProps = ProxoolConnectionProvider.mergeProperties(proxoolProps, connectionProps);
            log.info((Object)("Proxool Provider using delegate JDBC Driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
            if (jdbcDriverClass == null) {
                log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
            } else {
                try {
                    Class.forName(jdbcDriverClass);
                }
                catch (ClassNotFoundException cnfe) {
                    String msg = "Delegate JDBC Driver class not found: " + jdbcDriverClass;
                    log.fatal((Object)msg);
                    throw new HibernateException(msg);
                }
            }
            try {
                this.proxoolAlias = ProxoolConnectionProvider.newAlias();
                String connectionUrl = this.proxoolAlias + ":" + jdbcDriverClass + ":" + jdbcUrl;
                log.info((Object)("Proxool Provider Connection URL: " + connectionUrl));
                ProxoolFacade.registerConnectionPool((String)connectionUrl, (Properties)finalProps);
            }
            catch (Exception e) {
                log.fatal((Object)"Could not instantiate Proxool Provider connection pool", (Throwable)e);
                throw new HibernateException("Could not instantiate Proxool connection pool", e);
            }
        }
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            ProxoolFacade.killAllConnections((String)this.proxoolAlias.substring(PROXOOL_JDBC_STEM.length()));
        }
        catch (Exception e) {
            log.warn((Object)"Exception occured when closing the Proxool pool", (Throwable)e);
            throw new HibernateException("Exception occured when closing the Proxool pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String newAlias() {
        Class clazz = class$net$sf$hibernate$connection$ProxoolConnectionProvider == null ? (class$net$sf$hibernate$connection$ProxoolConnectionProvider = ProxoolConnectionProvider.class$("net.sf.hibernate.connection.ProxoolConnectionProvider")) : class$net$sf$hibernate$connection$ProxoolConnectionProvider;
        synchronized (clazz) {
            StringBuffer buff = new StringBuffer(HIBERNATE_ALIAS_STEM);
            buff.append(++aliasCount);
            return buff.toString();
        }
    }

    private static Properties extractProxoolProperties(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.proxool") <= -1) continue;
            result.setProperty(prop.substring("hibernate".length() + 1), properties.getProperty(prop));
        }
        return result;
    }

    private static Properties mergeProperties(Properties props1, Properties props2) {
        Iterator<Object> iter = props2.keySet().iterator();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            props1.setProperty(prop, props2.getProperty(prop));
        }
        return props1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

