/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;

public class DB2Dialect
extends Dialect {
    public DB2Dialect() {
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "VARCHAR($l) FOR BIT DATA");
        this.registerColumnType(2, "NUMERIC(19, $l)");
        this.registerColumnType(2004, "BLOB($l)");
        this.registerColumnType(2005, "CLOB($l)");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "values IDENTITY_VAL_LOCAL()";
    }

    public String getIdentityColumnString() {
        return "not null generated by default as identity";
    }

    public String getIdentityInsertString() {
        return "default";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "values nextval for " + sequenceName;
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("select * from ( ").append(sql).insert(DB2Dialect.getAfterSelectInsertPoint(sql), " rownumber() over() as row_,").append(" ) as temp_ where row_ ");
        if (hasOffset) {
            pagingSelect.append("between ?+1 and ?");
        } else {
            pagingSelect.append("<= ?");
        }
        return pagingSelect.toString();
    }

    public boolean useMaxForLimit() {
        return true;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        return 16 + (sql.startsWith("select distinct") ? 15 : 6);
    }
}

