/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.SQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.type.Type;

public class Oracle9Dialect
extends Dialect {
    public Oracle9Dialect() {
        this.registerColumnType(-7, "NUMBER(1,0)");
        this.registerColumnType(-5, "NUMBER(19,0)");
        this.registerColumnType(5, "NUMBER(5,0)");
        this.registerColumnType(-6, "NUMBER(3,0)");
        this.registerColumnType(4, "NUMBER(10,0)");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR2($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "DATE");
        this.registerColumnType(93, "DATE");
        this.registerColumnType(-3, "LONG RAW");
        this.registerColumnType(-3, 255, "RAW($l)");
        this.registerColumnType(2, "NUMBER(19, $l)");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "CLOB");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.registerFunction("trunc", new StandardSQLFunction());
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("abs", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("ceil", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("floor", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("sqrt", new StandardSQLFunction());
        this.registerFunction("exp", new StandardSQLFunction());
        this.registerFunction("ln", new StandardSQLFunction());
        this.registerFunction("sin", new StandardSQLFunction());
        this.registerFunction("sinh", new StandardSQLFunction());
        this.registerFunction("cos", new StandardSQLFunction());
        this.registerFunction("cosh", new StandardSQLFunction());
        this.registerFunction("tan", new StandardSQLFunction());
        this.registerFunction("tanh", new StandardSQLFunction());
        this.registerFunction("stddev", new StandardSQLFunction());
        this.registerFunction("variance", new StandardSQLFunction());
        this.registerFunction("sysdate", new SQLFunction(){

            public Type getReturnType(Type columnType, Mapping mapping) {
                return Hibernate.DATE;
            }

            public boolean hasArguments() {
                return false;
            }

            public boolean hasParenthesesIfNoArguments() {
                return false;
            }
        });
        this.registerFunction("lastday", new StandardSQLFunction(Hibernate.DATE));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean supportsForUpdateNowait() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        return pagingSelect.toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public String getQuerySequencesString() {
        return "select SEQUENCE_NAME from user_sequences";
    }
}

