/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.SybaseDialect;

public class SQLServerDialect
extends SybaseDialect {
    public boolean bindLimitParametersFirst() {
        return super.bindLimitParametersFirst();
    }

    public String getLimitString(String querySelect, boolean hasOffset, int limit) {
        if (hasOffset) {
            throw new UnsupportedOperationException("sql server has no offset");
        }
        return new StringBuffer(querySelect.length() + 6).append(querySelect).insert(SQLServerDialect.getAfterSelectInsertPoint(querySelect), " top " + limit).toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        return sql.startsWith("select distinct") ? 15 : 6;
    }
}

