/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.engine;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.type.VersionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Versioning {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$engine$Versioning == null ? (class$net$sf$hibernate$engine$Versioning = Versioning.class$("net.sf.hibernate.engine.Versioning")) : class$net$sf$hibernate$engine$Versioning));
    public static final int OPTIMISTIC_LOCK_NONE = -1;
    public static final int OPTIMISTIC_LOCK_ALL = 2;
    public static final int OPTIMISTIC_LOCK_DIRTY = 1;
    public static final int OPTIMISTIC_LOCK_VERSION = 0;
    static /* synthetic */ Class class$net$sf$hibernate$engine$Versioning;

    private Versioning() {
    }

    public static Object increment(Object version, VersionType versionType) {
        Object next = versionType.next(version);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Incrementing: " + version + " to " + next));
        }
        return next;
    }

    private static Object seed(VersionType versionType) {
        Object seed = versionType.seed();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Seeding: " + seed));
        }
        return seed;
    }

    public static boolean seedVersion(Object[] fields, int versionProperty, VersionType versionType) {
        if (fields[versionProperty] == null) {
            fields[versionProperty] = Versioning.seed(versionType);
            return true;
        }
        return false;
    }

    private static Object getVersion(Object[] fields, int versionProperty) {
        return fields[versionProperty];
    }

    private static void setVersion(Object[] fields, Object version, int versionProperty) {
        fields[versionProperty] = version;
    }

    public static void setVersion(Object[] fields, Object version, ClassPersister persister) {
        Versioning.setVersion(fields, version, persister.getVersionProperty());
    }

    public static Object getVersion(Object[] fields, ClassPersister persister) throws HibernateException {
        return persister.isVersioned() ? Versioning.getVersion(fields, persister.getVersionProperty()) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

