/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;

public final class IdentifierGeneratorFactory {
    private static final HashMap GENERATORS = new HashMap();
    public static final String SHORT_CIRCUIT_INDICATOR = new String();
    public static final String IDENTITY_COLUMN_INDICATOR = new String();
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$net$sf$hibernate$id$UUIDHexGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$UUIDStringGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$TableHiLoGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$Assigned;
    static /* synthetic */ Class class$net$sf$hibernate$id$IdentityGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$SequenceGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$SequenceHiLoGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$IncrementGenerator;
    static /* synthetic */ Class class$net$sf$hibernate$id$ForeignGenerator;

    public static Serializable get(ResultSet rs, Type type, SessionImplementor session, Object owner) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IdentifierGeneratorFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(rs.getLong(1));
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IdentifierGeneratorFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(rs.getInt(1));
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IdentifierGeneratorFactory.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short(rs.getShort(1));
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    public static IdentifierGenerator create(String strategy, Type type, Properties params, Dialect dialect) throws MappingException {
        try {
            IdentifierGenerator idgen;
            Class clazz = (Class)GENERATORS.get(strategy);
            if ("native".equals(strategy)) {
                if (dialect.supportsIdentityColumns()) {
                    clazz = class$net$sf$hibernate$id$IdentityGenerator == null ? (class$net$sf$hibernate$id$IdentityGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.IdentityGenerator")) : class$net$sf$hibernate$id$IdentityGenerator;
                } else if (dialect.supportsSequences()) {
                    clazz = class$net$sf$hibernate$id$SequenceGenerator == null ? (class$net$sf$hibernate$id$SequenceGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.SequenceGenerator")) : class$net$sf$hibernate$id$SequenceGenerator;
                } else {
                    Class clazz2 = clazz = class$net$sf$hibernate$id$TableHiLoGenerator == null ? (class$net$sf$hibernate$id$TableHiLoGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.TableHiLoGenerator")) : class$net$sf$hibernate$id$TableHiLoGenerator;
                }
            }
            if (clazz == null) {
                clazz = ReflectHelper.classForName(strategy);
            }
            if ((idgen = (IdentifierGenerator)clazz.newInstance()) instanceof Configurable) {
                ((Configurable)((Object)idgen)).configure(type, params, dialect);
            }
            return idgen;
        }
        catch (Exception e) {
            throw new MappingException("could not instantiate id generator", e);
        }
    }

    static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = IdentifierGeneratorFactory.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(value);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = IdentifierGeneratorFactory.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)value);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = IdentifierGeneratorFactory.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    private IdentifierGeneratorFactory() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GENERATORS.put("uuid.hex", class$net$sf$hibernate$id$UUIDHexGenerator == null ? (class$net$sf$hibernate$id$UUIDHexGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.UUIDHexGenerator")) : class$net$sf$hibernate$id$UUIDHexGenerator);
        GENERATORS.put("uuid.string", class$net$sf$hibernate$id$UUIDStringGenerator == null ? (class$net$sf$hibernate$id$UUIDStringGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.UUIDStringGenerator")) : class$net$sf$hibernate$id$UUIDStringGenerator);
        GENERATORS.put("hilo", class$net$sf$hibernate$id$TableHiLoGenerator == null ? (class$net$sf$hibernate$id$TableHiLoGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.TableHiLoGenerator")) : class$net$sf$hibernate$id$TableHiLoGenerator);
        GENERATORS.put("assigned", class$net$sf$hibernate$id$Assigned == null ? (class$net$sf$hibernate$id$Assigned = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.Assigned")) : class$net$sf$hibernate$id$Assigned);
        GENERATORS.put("identity", class$net$sf$hibernate$id$IdentityGenerator == null ? (class$net$sf$hibernate$id$IdentityGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.IdentityGenerator")) : class$net$sf$hibernate$id$IdentityGenerator);
        GENERATORS.put("sequence", class$net$sf$hibernate$id$SequenceGenerator == null ? (class$net$sf$hibernate$id$SequenceGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.SequenceGenerator")) : class$net$sf$hibernate$id$SequenceGenerator);
        GENERATORS.put("seqhilo", class$net$sf$hibernate$id$SequenceHiLoGenerator == null ? (class$net$sf$hibernate$id$SequenceHiLoGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.SequenceHiLoGenerator")) : class$net$sf$hibernate$id$SequenceHiLoGenerator);
        GENERATORS.put("vm", class$net$sf$hibernate$id$IncrementGenerator == null ? (class$net$sf$hibernate$id$IncrementGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.IncrementGenerator")) : class$net$sf$hibernate$id$IncrementGenerator);
        GENERATORS.put("increment", class$net$sf$hibernate$id$IncrementGenerator == null ? (class$net$sf$hibernate$id$IncrementGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.IncrementGenerator")) : class$net$sf$hibernate$id$IncrementGenerator);
        GENERATORS.put("foreign", class$net$sf$hibernate$id$ForeignGenerator == null ? (class$net$sf$hibernate$id$ForeignGenerator = IdentifierGeneratorFactory.class$("net.sf.hibernate.id.ForeignGenerator")) : class$net$sf$hibernate$id$ForeignGenerator);
    }
}

