/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.NonUniqueResultException;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.type.SerializableType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;

public abstract class AbstractQueryImpl
implements Query {
    private String queryString;
    private Map lockModes = new HashMap(2);
    private final SessionImplementor session;
    private RowSelection selection;
    private ArrayList values = new ArrayList(4);
    private ArrayList types = new ArrayList(4);
    private int positionalParameterCount = 0;
    private Set actualNamedParameters = new HashSet(4);
    private Map namedParameters = new HashMap(4);
    private Map namedParameterLists = new HashMap(4);

    public AbstractQueryImpl(String queryString, SessionImplementor session) {
        this.session = session;
        this.queryString = queryString;
        this.selection = new RowSelection();
        this.initParameterBookKeeping();
    }

    public final String getQueryString() {
        return this.queryString;
    }

    protected Map getNamedParams() {
        return new HashMap(this.namedParameters);
    }

    protected void verifyParameters() throws HibernateException {
        if (this.actualNamedParameters.size() != this.namedParameters.size() + this.namedParameterLists.size()) {
            HashSet missingParams = new HashSet(this.actualNamedParameters);
            missingParams.removeAll(this.namedParameterLists.keySet());
            missingParams.removeAll(this.namedParameters.keySet());
            throw new QueryException("Not all named parameters have been set: " + missingParams, this.getQueryString());
        }
        if (this.positionalParameterCount != this.values.size() || this.values.contains(null)) {
            throw new QueryException("Not all positional parameters have been set", this.getQueryString());
        }
    }

    protected Map getNamedParameterLists() {
        return this.namedParameterLists;
    }

    protected List getValues() {
        return this.values;
    }

    protected List getTypes() {
        return this.types;
    }

    public RowSelection getSelection() {
        return this.selection;
    }

    public Query setMaxResults(int maxResults) {
        this.selection.setMaxRows(new Integer(maxResults));
        return this;
    }

    public Query setTimeout(int timeout) {
        this.selection.setTimeout(new Integer(timeout));
        return this;
    }

    public Query setFirstResult(int firstResult) {
        this.selection.setFirstRow(new Integer(firstResult));
        return this;
    }

    public Query setParameter(int position, Object val, Type type) {
        if (this.positionalParameterCount == 0) {
            throw new IllegalArgumentException("No positional parameters in query: " + this.getQueryString());
        }
        if (position < 0 || position > this.positionalParameterCount - 1) {
            throw new IllegalArgumentException("Positional parameter does not exist: " + position + " in query: " + this.getQueryString());
        }
        int size = this.values.size();
        if (position < size) {
            this.values.set(position, val);
            this.types.set(position, type);
        } else {
            for (int i = 0; i < position - size; ++i) {
                this.values.add(null);
                this.types.add(null);
            }
            this.values.add(val);
            this.types.add(type);
        }
        return this;
    }

    public Query setString(int position, String val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.STRING);
        return this;
    }

    public Query setCharacter(int position, char val) {
        this.setParameter(position, (Object)new Character(val), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setBoolean(int position, boolean val) {
        this.setParameter(position, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
        return this;
    }

    public Query setByte(int position, byte val) {
        this.setParameter(position, (Object)new Byte(val), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setShort(int position, short val) {
        this.setParameter(position, (Object)new Short(val), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setInteger(int position, int val) {
        this.setParameter(position, (Object)new Integer(val), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLong(int position, long val) {
        this.setParameter(position, (Object)new Long(val), (Type)Hibernate.LONG);
        return this;
    }

    public Query setFloat(int position, float val) {
        this.setParameter(position, (Object)new Float(val), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setDouble(int position, double val) {
        this.setParameter(position, (Object)new Double(val), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setBinary(int position, byte[] val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setText(int position, String val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.TEXT);
        return this;
    }

    public Query setSerializable(int position, Serializable val) {
        this.setParameter(position, (Object)val, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setDate(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setTime(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setEntity(int position, Object val) {
        this.setParameter(position, val, Hibernate.entity(HibernateProxyHelper.getClass(val)));
        return this;
    }

    public Query setEnum(int position, Object val) throws MappingException {
        this.setParameter(position, val, Hibernate.enum(val.getClass()));
        return this;
    }

    public Query setLocale(int position, Locale locale) {
        this.setParameter(position, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setBinary(String name, byte[] val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setText(String name, String val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.TEXT);
        return this;
    }

    public Query setBoolean(String name, boolean val) {
        this.setParameter(name, (Object)new Boolean(val), (Type)Hibernate.BOOLEAN);
        return this;
    }

    public Query setByte(String name, byte val) {
        this.setParameter(name, (Object)new Byte(val), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setCharacter(String name, char val) {
        this.setParameter(name, (Object)new Character(val), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setDate(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setDouble(String name, double val) {
        this.setParameter(name, (Object)new Double(val), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setEntity(String name, Object val) {
        this.setParameter(name, val, Hibernate.entity(HibernateProxyHelper.getClass(val)));
        return this;
    }

    public Query setEnum(String name, Object val) throws MappingException {
        this.setParameter(name, val, Hibernate.enum(val.getClass()));
        return this;
    }

    public Query setFloat(String name, float val) {
        this.setParameter(name, (Object)new Float(val), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setInteger(String name, int val) {
        this.setParameter(name, (Object)new Integer(val), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLocale(String name, Locale locale) {
        this.setParameter(name, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setLong(String name, long val) {
        this.setParameter(name, (Object)new Long(val), (Type)Hibernate.LONG);
        return this;
    }

    public Query setParameter(String name, Object val, Type type) {
        if (!this.actualNamedParameters.contains(name)) {
            throw new IllegalArgumentException("Parameter " + name + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameters.put(name, new TypedValue(type, val));
        return this;
    }

    public Query setSerializable(String name, Serializable val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setShort(String name, short val) {
        this.setParameter(name, (Object)new Short(val), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setString(String name, String val) {
        this.setParameter(name, (Object)val, (Type)Hibernate.STRING);
        return this;
    }

    public Query setTime(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setBigDecimal(int position, BigDecimal number) {
        this.setParameter(position, (Object)number, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setBigDecimal(String name, BigDecimal number) {
        this.setParameter(name, (Object)number, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setParameter(int position, Object val) throws HibernateException {
        this.setParameter(position, val, this.guessType(val));
        return this;
    }

    public Query setParameter(String name, Object val) throws HibernateException {
        this.setParameter(name, val, this.guessType(val));
        return this;
    }

    private Type guessType(Object param) throws HibernateException {
        Class clazz = HibernateProxyHelper.getClass(param);
        return this.guessType(clazz);
    }

    private Type guessType(Class clazz) throws HibernateException {
        boolean serializable;
        String typename = clazz.getName();
        Type type = TypeFactory.heuristicType(typename);
        boolean bl = serializable = type != null && type instanceof SerializableType;
        if (type == null || serializable) {
            try {
                this.session.getFactory().getPersister(clazz);
            }
            catch (MappingException me) {
                if (serializable) {
                    return type;
                }
                throw new HibernateException("Could not determine a type for class: " + typename);
            }
            return Hibernate.entity(clazz);
        }
        return type;
    }

    public Type[] getReturnTypes() throws HibernateException {
        return this.session.getFactory().getReturnTypes(this.queryString);
    }

    public Query setParameterList(String name, Collection vals, Type type) throws HibernateException {
        if (!this.actualNamedParameters.contains(name)) {
            throw new IllegalArgumentException("Parameter " + name + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameterLists.put(name, new TypedValue(type, vals));
        return this;
    }

    protected String bindParameterLists(Map namedParamsCopy) {
        String query = this.queryString;
        Iterator iter = this.namedParameterLists.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            query = this.bindParameterList(query, (String)me.getKey(), (TypedValue)me.getValue(), namedParamsCopy);
        }
        return query;
    }

    private String bindParameterList(String query, String name, TypedValue typedList, Map namedParamsCopy) {
        Collection vals = (Collection)typedList.getValue();
        Type type = typedList.getType();
        StringBuffer list = new StringBuffer(16);
        Iterator iter = vals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String alias = name + i++ + '_';
            namedParamsCopy.put(alias, new TypedValue(type, iter.next()));
            list.append(":" + alias);
            if (!iter.hasNext()) continue;
            list.append(", ");
        }
        return StringHelper.replace(query, ":" + name, list.toString(), true);
    }

    public Query setParameterList(String name, Collection vals) throws HibernateException {
        this.setParameterList(name, vals, this.guessType(vals.iterator().next()));
        return this;
    }

    public String[] getNamedParameters() throws HibernateException {
        return this.actualNamedParameters.toArray(new String[this.actualNamedParameters.size()]);
    }

    private void initParameterBookKeeping() {
        StringTokenizer st = new StringTokenizer(this.queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\");
        HashSet<String> result = new HashSet<String>();
        while (st.hasMoreTokens()) {
            String string = st.nextToken();
            if (!string.startsWith(":")) continue;
            result.add(string.substring(1));
        }
        this.actualNamedParameters = result;
        this.positionalParameterCount = StringHelper.countUnquoted(this.queryString, '?');
    }

    public Query setProperties(Object bean) throws HibernateException {
        Class<?> clazz = bean.getClass();
        String[] params = this.getNamedParameters();
        for (int i = 0; i < params.length; ++i) {
            String namedParam = params[i];
            try {
                Getter getter = ReflectHelper.getter(clazz, namedParam);
                this.setParameter(namedParam, getter.get(bean), this.guessType(getter.getReturnType()));
                continue;
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
        return this;
    }

    public Query setParameterList(String name, Object[] vals, Type type) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals), type);
    }

    public Query setParameterList(String name, Object[] vals) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals));
    }

    public void setLockMode(String alias, LockMode lockMode) {
        this.lockModes.put(alias, lockMode);
    }

    Map getLockModes() {
        return this.lockModes;
    }

    SessionImplementor getSession() {
        return this.session;
    }

    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    static Object uniqueElement(List list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    protected RowSelection getRowSelection() {
        return this.selection;
    }

    public Type[] typeArray() {
        return this.getTypes().toArray(ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public Object[] valueArray() {
        return this.getValues().toArray();
    }

    public QueryParameters getQueryParameters(Map namedParams) {
        return new QueryParameters(this.typeArray(), this.valueArray(), namedParams, this.getLockModes(), this.getSelection());
    }
}

