/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.engine.Batcher;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.util.JDBCExceptionReporter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BatcherImpl
implements Batcher {
    private static int openPreparedStatements;
    private static int openResultSetCount;
    protected static final Log log;
    private final SessionImplementor session;
    private final SessionFactoryImplementor factory;
    private PreparedStatement batchUpdate;
    private String batchUpdateSQL;
    private HashSet statementsToClose = new HashSet();
    private HashSet resultSetsToClose = new HashSet();
    private PreparedStatement lastQuery;
    static /* synthetic */ Class class$net$sf$hibernate$impl$BatcherImpl;

    public BatcherImpl(SessionImplementor session) {
        this.session = session;
        this.factory = session.getFactory();
    }

    protected PreparedStatement getStatement() {
        return this.batchUpdate;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException, HibernateException {
        this.executeBatch();
        BatcherImpl.logOpenPreparedStatement();
        return this.getPreparedStatement(this.session.connection(), sql, false);
    }

    public PreparedStatement prepareQueryStatement(String sql, boolean scrollable) throws SQLException, HibernateException {
        BatcherImpl.logOpenPreparedStatement();
        PreparedStatement ps = this.getPreparedStatement(this.session.connection(), sql, scrollable);
        this.setStatementFetchSize(ps);
        this.statementsToClose.add(ps);
        this.lastQuery = ps;
        return ps;
    }

    public void abortBatch(SQLException sqle) {
        PreparedStatement ps = this.batchUpdate;
        this.batchUpdate = null;
        this.batchUpdateSQL = null;
        try {
            this.closeStatement(ps);
        }
        catch (SQLException e) {
            JDBCExceptionReporter.logExceptions(e);
        }
    }

    public ResultSet getResultSet(PreparedStatement ps) throws SQLException {
        ResultSet rs = ps.executeQuery();
        this.resultSetsToClose.add(rs);
        BatcherImpl.logOpenResults();
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeQueryStatement(PreparedStatement ps, ResultSet rs) throws SQLException {
        this.statementsToClose.remove(ps);
        if (rs != null) {
            this.resultSetsToClose.remove(rs);
        }
        try {
            if (rs != null) {
                BatcherImpl.logCloseResults();
                rs.close();
            }
        }
        finally {
            this.closeQueryStatement(ps);
        }
    }

    public PreparedStatement prepareBatchStatement(String sql) throws SQLException, HibernateException {
        if (!sql.equals(this.batchUpdateSQL)) {
            this.batchUpdate = this.prepareStatement(sql);
            this.batchUpdateSQL = sql;
        }
        return this.batchUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws HibernateException {
        if (this.batchUpdate != null) {
            PreparedStatement ps = this.batchUpdate;
            this.batchUpdate = null;
            this.batchUpdateSQL = null;
            try {
                try {
                    this.doExecuteBatch(ps);
                }
                finally {
                    this.closeStatement(ps);
                }
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not execute JDBC batch update", sqle);
            }
        }
    }

    public void closeStatement(PreparedStatement ps) throws SQLException {
        BatcherImpl.logClosePreparedStatement();
        this.closePreparedStatement(ps);
    }

    private void closeQueryStatement(PreparedStatement ps) throws SQLException {
        try {
            if (ps.getMaxRows() != 0) {
                ps.setMaxRows(0);
            }
            if (ps.getQueryTimeout() != 0) {
                ps.setQueryTimeout(0);
            }
        }
        catch (Exception e) {
            log.warn((Object)"exception clearing maxRows/queryTimeout", (Throwable)e);
            ps.close();
            return;
        }
        this.closeStatement(ps);
    }

    public void closeStatements() {
        try {
            if (this.batchUpdate != null) {
                this.batchUpdate.close();
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not close a JDBC prepared statement", (Throwable)sqle);
        }
        this.batchUpdate = null;
        this.batchUpdateSQL = null;
        Iterator iter = this.resultSetsToClose.iterator();
        while (iter.hasNext()) {
            try {
                BatcherImpl.logCloseResults();
                ((ResultSet)iter.next()).close();
            }
            catch (SQLException e) {
                log.warn((Object)"Could not close a JDBC result set", (Throwable)e);
            }
        }
        this.resultSetsToClose.clear();
        iter = this.statementsToClose.iterator();
        while (iter.hasNext()) {
            try {
                this.closeQueryStatement((PreparedStatement)iter.next());
            }
            catch (SQLException e) {
                log.warn((Object)"Could not close a JDBC statement", (Throwable)e);
            }
        }
        this.statementsToClose.clear();
    }

    protected abstract void doExecuteBatch(PreparedStatement var1) throws SQLException, HibernateException;

    private static void logOpenPreparedStatement() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("about to open: " + openPreparedStatements + " open PreparedStatements, " + openResultSetCount + " open ResultSets"));
            ++openPreparedStatements;
        }
    }

    private static void logClosePreparedStatement() {
        if (log.isTraceEnabled()) {
            --openPreparedStatements;
        }
        log.trace((Object)("done closing: " + openPreparedStatements + " open PreparedStatements, " + openResultSetCount + " open ResultSets"));
    }

    private static void logOpenResults() {
        if (log.isTraceEnabled()) {
            ++openResultSetCount;
        }
    }

    private static void logCloseResults() {
        if (log.isTraceEnabled()) {
            --openResultSetCount;
        }
    }

    protected SessionImplementor getSession() {
        return this.session;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private PreparedStatement getPreparedStatement(Connection conn, String sql, boolean scrollable) throws SQLException {
        if (scrollable && !this.factory.isScrollableResultSetsEnabled()) {
            throw new AssertionFailure("Hibernate tried to grab a scrollable result set");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)((scrollable ? "scrollable " : "") + "prepared statement get: " + sql));
        }
        if (this.factory.isShowSqlEnabled()) {
            System.out.println("Hibernate: " + sql);
        }
        try {
            log.trace((Object)"preparing statement");
            return scrollable ? conn.prepareStatement(sql, 1004, 1007) : conn.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private void closePreparedStatement(PreparedStatement ps) throws SQLException {
        try {
            log.trace((Object)"closing statement");
            if (ps != null) {
                ps.close();
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    private void setStatementFetchSize(PreparedStatement statement) throws SQLException {
        Integer statementFetchSize = this.factory.getJdbcFetchSize();
        if (statementFetchSize != null) {
            statement.setFetchSize(statementFetchSize);
        }
    }

    public Connection openConnection() throws HibernateException {
        try {
            return this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sqle) {
            throw new JDBCException("Cannot open connection", sqle);
        }
    }

    public void closeConnection(Connection conn) throws HibernateException {
        try {
            if (!conn.isClosed()) {
                JDBCExceptionReporter.logWarnings(conn.getWarnings());
                conn.clearWarnings();
            }
            this.factory.getConnectionProvider().closeConnection(conn);
        }
        catch (SQLException sqle) {
            throw new JDBCException("Cannot close connection", sqle);
        }
    }

    public void cancelLastQuery() throws HibernateException {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not cancel query", sqle);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$BatcherImpl == null ? (class$net$sf$hibernate$impl$BatcherImpl = BatcherImpl.class$("net.sf.hibernate.impl.BatcherImpl")) : class$net$sf$hibernate$impl$BatcherImpl));
    }
}

