/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.AbstractQueryImpl;
import net.sf.hibernate.type.Type;

public class SQLQueryImpl
extends AbstractQueryImpl {
    private Class[] returnClasses;
    private String[] returnAliases;

    SQLQueryImpl(String sql, String[] returnAliases, Class[] returnClasses, SessionImplementor session) {
        super(sql, session);
        this.returnClasses = returnClasses;
        this.returnAliases = returnAliases;
    }

    public String[] getReturnAliases() {
        return this.returnAliases;
    }

    public Class[] getReturnClasses() {
        return this.returnClasses;
    }

    public List list() throws HibernateException {
        this.verifyParameters();
        Map namedParams = this.getNamedParams();
        return this.getSession().findBySQL(this.bindParameterLists(namedParams), this.returnAliases, this.returnClasses, this.getQueryParameters(namedParams));
    }

    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    public ScrollableResults scroll() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    public Query setCacheable(boolean cacheable) {
        throw new UnsupportedOperationException("SQL queries do not currently support caching");
    }

    public Query setCacheRegion(String regionName) {
        throw new UnsupportedOperationException("SQL queries do not currently support caching");
    }

    public Type[] getReturnTypes() throws HibernateException {
        Type[] types = new Type[this.returnClasses.length];
        for (int i = 0; i < this.returnClasses.length; ++i) {
            types[i] = Hibernate.entity(this.returnClasses[i]);
        }
        return types;
    }
}

