/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledCollectionAction;
import net.sf.hibernate.impl.SessionImpl;

final class ScheduledCollectionRemove
extends ScheduledCollectionAction
implements SessionImpl.Executable {
    private boolean emptySnapshot;

    public ScheduledCollectionRemove(CollectionPersister persister, Serializable id, boolean emptySnapshot, SessionImplementor session) {
        super(persister, id, session);
        this.emptySnapshot = emptySnapshot;
    }

    public void execute() throws HibernateException {
        CollectionPersister persister = this.getPersister();
        if (persister.hasCache()) {
            this.setLock(persister.getCache().lock(this.getId()));
        }
        if (!this.emptySnapshot) {
            persister.remove(this.getId(), this.getSession());
        }
        if (persister.hasCache()) {
            persister.getCache().evict(this.getId());
        }
    }
}

