/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Order;
import net.sf.hibernate.impl.CriteriaImpl;
import net.sf.hibernate.loader.AbstractEntityLoader;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.sql.ForUpdateFragment;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public class CriteriaLoader
extends AbstractEntityLoader {
    private CriteriaImpl criteria;
    private Set querySpaces = new HashSet();
    private final List aliases = new ArrayList();

    public CriteriaLoader(OuterJoinLoadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria) throws HibernateException {
        super(persister, factory);
        this.criteria = criteria;
        this.addAllToPropertySpaces(persister.getPropertySpaces());
        StringBuffer condition = new StringBuffer(30);
        Iterator iter = criteria.iterateExpressionEntries();
        if (!iter.hasNext()) {
            condition.append("1=1");
        }
        while (iter.hasNext()) {
            CriteriaImpl.CriterionEntry ee = (CriteriaImpl.CriterionEntry)iter.next();
            String sqlString = ee.getCriterion().toSqlString(factory, criteria.getPersistentClass(ee.getAlias()), ee.getAlias(), criteria.getAliasClasses());
            condition.append(sqlString);
            if (!iter.hasNext()) continue;
            condition.append(" and ");
        }
        StringBuffer orderBy = new StringBuffer(30);
        iter = criteria.iterateOrderings();
        while (iter.hasNext()) {
            Order ord = (Order)iter.next();
            orderBy.append(ord.toSqlString(factory, criteria.getCriteriaClass(), this.getAlias()));
            if (!iter.hasNext()) continue;
            orderBy.append(", ");
        }
        this.renderStatement(condition.toString(), orderBy.toString(), factory);
        this.postInstantiate();
    }

    public List list(SessionImplementor session) throws HibernateException, SQLException {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator iter = this.criteria.iterateExpressionEntries();
        while (iter.hasNext()) {
            CriteriaImpl.CriterionEntry ce = (CriteriaImpl.CriterionEntry)iter.next();
            TypedValue[] tv = ce.getCriterion().getTypedValues(session.getFactory(), this.criteria.getCriteriaClass(ce.getAlias()), this.criteria.getAliasClasses());
            for (int i = 0; i < tv.length; ++i) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
            }
        }
        Object[] valueArray = values.toArray();
        Type[] typeArray = types.toArray(ArrayHelper.EMPTY_TYPE_ARRAY);
        RowSelection selection = new RowSelection();
        selection.setFirstRow(this.criteria.getFirstResult());
        selection.setMaxRows(this.criteria.getMaxResults());
        selection.setTimeout(this.criteria.getTimeout());
        return this.list(session, new QueryParameters(typeArray, valueArray, null, this.criteria.getLockModes(), selection));
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        if (this.criteria.isReturnMapEnabled()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < row.length - 1; ++i) {
                String alias = (String)this.aliases.get(i);
                if (alias.endsWith("_")) continue;
                result.put(alias, row[i]);
            }
            result.put("this", row[row.length - 1]);
            return result;
        }
        return row[row.length - 1];
    }

    protected int getJoinType(AssociationType type, int config, String path, String table, String[] foreignKeyColumns, SessionFactoryImplementor factory) throws MappingException {
        if (this.criteria.isJoin(path)) {
            return 0;
        }
        FetchMode fm = this.criteria.getFetchMode(path);
        if (fm == null || fm == FetchMode.DEFAULT) {
            return super.getJoinType(type, config, path, table, foreignKeyColumns, factory);
        }
        return fm == FetchMode.EAGER ? 1 : -1;
    }

    protected String getWhereFragment() throws MappingException {
        return ((Queryable)this.getPersister()).queryWhereFragment(this.getAlias(), true, true);
    }

    protected String generateTableAlias(String className, int n, String path, boolean isLinkTable) {
        String userDefinedAlias;
        if (!isLinkTable && (userDefinedAlias = this.criteria.getAlias(path)) != null) {
            this.aliases.add(userDefinedAlias);
            return userDefinedAlias;
        }
        String generatedAlias = super.generateTableAlias(className, n, path, isLinkTable);
        this.aliases.add(generatedAlias);
        return generatedAlias;
    }

    protected String generateRootAlias(String tableName) {
        return "this";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected void addToPropertySpaces(Serializable space) {
        this.querySpaces.add(space);
    }

    protected String applyLocks(String sqlSelectString, Map lockModes, Dialect dialect) throws QueryException {
        if (lockModes == null || lockModes.size() == 0) {
            return sqlSelectString;
        }
        return sqlSelectString + new ForUpdateFragment(lockModes).toFragmentString(dialect);
    }

    protected LockMode[] getLockModes(Map lockModes) {
        int size = this.aliases.size();
        LockMode[] lockModesArray = new LockMode[size + 1];
        LockMode lm = (LockMode)lockModes.get("this");
        lockModesArray[size] = lm == null ? LockMode.NONE : lm;
        for (int i = 0; i < size; ++i) {
            lm = (LockMode)lockModes.get(this.aliases.get(i));
            lockModesArray[i] = lm == null ? LockMode.NONE : lm;
        }
        return lockModesArray;
    }
}

