/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Collections;
import java.util.Iterator;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.util.JoinedIterator;

public class Subclass
extends PersistentClass {
    private PersistentClass superclass;
    private SimpleValue key;
    private Class classPersisterClass;

    public Subclass(PersistentClass superclass) {
        this.superclass = superclass;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.getSuperclass().getCache();
    }

    public RootClass getRootClass() {
        return this.getSuperclass().getRootClass();
    }

    public PersistentClass getSuperclass() {
        return this.superclass;
    }

    public Property getIdentifierProperty() {
        return this.getSuperclass().getIdentifierProperty();
    }

    public SimpleValue getIdentifier() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean hasIdentifierProperty() {
        return this.getSuperclass().hasIdentifierProperty();
    }

    public Value getDiscriminator() {
        return this.getSuperclass().getDiscriminator();
    }

    public boolean isMutable() {
        return this.getSuperclass().isMutable();
    }

    public boolean isInherited() {
        return true;
    }

    public boolean isPolymorphic() {
        return true;
    }

    public void addNewProperty(Property p) throws MappingException {
        super.addNewProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    public void setTable(Table table) {
        super.setTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public Iterator getPropertyClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getPropertyIterator(), this.getSuperclass().getPropertyClosureIterator()});
    }

    public Iterator getTableClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getSuperclass().getTableClosureIterator(), Collections.singleton(this.getTable()).iterator()});
    }

    protected void addSubclassProperty(Property p) {
        super.addSubclassProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    protected void addSubclassTable(Table table) {
        super.addSubclassTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public boolean isVersioned() {
        return this.getSuperclass().isVersioned();
    }

    public Property getVersion() {
        return this.getSuperclass().getVersion();
    }

    public boolean hasEmbeddedIdentifier() {
        return this.getSuperclass().hasEmbeddedIdentifier();
    }

    public Class getClassPersisterClass() {
        if (this.classPersisterClass == null) {
            return this.getSuperclass().getClassPersisterClass();
        }
        return this.classPersisterClass;
    }

    public Table getRootTable() {
        return this.getSuperclass().getRootTable();
    }

    public SimpleValue getKey() {
        if (this.key == null) {
            return this.getIdentifier();
        }
        return this.key;
    }

    public boolean isExplicitPolymorphism() {
        return this.getSuperclass().isExplicitPolymorphism();
    }

    public void setKey(SimpleValue key) {
        this.key = key;
    }

    public void setSuperclass(PersistentClass superclass) {
        this.superclass = superclass;
    }

    public String getWhere() {
        return this.getSuperclass().getWhere();
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (this.key != null && !this.key.isValid(mapping)) {
            throw new MappingException("subclass key mapping has wrong number of columns: " + this.getMappedClass().getName() + " type: " + this.key.getType().getName());
        }
    }

    public boolean isJoinedSubclass() {
        return this.getTable() != this.getRootTable();
    }

    public void createForeignKey() {
        if (!this.isJoinedSubclass()) {
            throw new AssertionFailure("not a joined-subclass");
        }
        this.getKey().createForeignKeyOfClass(this.getSuperclass().getMappedClass());
    }

    public void setClassPersisterClass(Class classPersisterClass) {
        this.classPersisterClass = classPersisterClass;
    }
}

