/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.persister;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.Versioning;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.UniqueEntityLoader;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.persister.AbstractEntityPersister;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.Delete;
import net.sf.hibernate.sql.Insert;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.SimpleSelect;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.DiscriminatorType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NormalizedEntityPersister
extends AbstractEntityPersister {
    private final SessionFactoryImplementor factory;
    private final String qualifiedTableName;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] naturalOrderTableKeyColumns;
    private final Class[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumns;
    private final boolean[] isClassOrSuperclassTable;
    private final String[] sqlDeleteStrings;
    private final String[] sqlInsertStrings;
    private final String[] sqlIdentityInsertStrings;
    private final String[] sqlUpdateStrings;
    private final int[] propertyColumnSpans;
    private final int[] propertyTables;
    private final int[] naturalOrderPropertyTables;
    private final boolean[] propertyHasColumns;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnAliases;
    private final String[] propertyFormulaTemplates;
    private final String[][] subclassPropertyColumnNameClosure;
    private final int[] subclassPropertyTableNumberClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final String[] subclassPropertyNameClosure;
    private final int[] subclassPropertyEnableJoinedFetch;
    private final boolean[] propertyDefinedOnSubclass;
    private final HashMap tableNumberByPropertyPath = new HashMap();
    private final int[] subclassColumnTableNumberClosure;
    private final String[] subclassColumnClosure;
    private final String[] subclassColumnClosureAliases;
    private final int[] subclassFormulaTableNumberClosure;
    private final String[] subclassFormulaTemplateClosure;
    private final String[] subclassFormulaAliasClosure;
    private final HashMap subclassesByDiscriminatorValue = new HashMap();
    private final String[] discriminatorValues;
    private final String[] notNullColumns;
    private final int[] tableNumbers;
    private final DiscriminatorType discriminatorType;
    private final String discriminatorSQLString;
    private final String discriminatorColumnName;
    private final String sqlConcreteSelectString;
    private final String sqlVersionSelectString;
    private UniqueEntityLoader loader;
    private final Map lockers = new HashMap();
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$persister$NormalizedEntityPersister == null ? (class$net$sf$hibernate$persister$NormalizedEntityPersister = NormalizedEntityPersister.class$("net.sf.hibernate.persister.NormalizedEntityPersister")) : class$net$sf$hibernate$persister$NormalizedEntityPersister));
    private static final String CONCRETE_ALIAS = "x";
    static /* synthetic */ Class class$net$sf$hibernate$persister$NormalizedEntityPersister;

    public void postInstantiate() throws MappingException {
        this.initPropertyPaths(this.factory);
        this.loader = this.createEntityLoader(this.factory);
        this.createUniqueKeyLoaders(this.factory);
    }

    public boolean isDefinedOnSubclass(int i) {
        return this.propertyDefinedOnSubclass[i];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    public String getDiscriminatorAlias() {
        return this.getDiscriminatorColumnName();
    }

    public Type getSubclassPropertyType(int i) {
        return this.subclassPropertyTypeClosure[i];
    }

    public String getSubclassPropertyName(int i) {
        return this.subclassPropertyNameClosure[i];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    public String[] getSubclassPropertyColumnNames(int i) {
        return this.subclassPropertyColumnNameClosure[i];
    }

    public String[] getPropertyColumnNames(int i) {
        return this.propertyColumnAliases[i];
    }

    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    public Object getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    public Class getSubclassForDiscriminatorValue(Object value) {
        return (Class)this.subclassesByDiscriminatorValue.get(value);
    }

    public int enableJoinedFetch(int i) {
        return this.subclassPropertyEnableJoinedFetch[i];
    }

    public Serializable getIdentifierSpace() {
        return this.qualifiedTableName;
    }

    public Serializable[] getPropertySpaces() {
        return this.tableNames;
    }

    protected final String[] getSQLDeleteStrings() {
        return this.sqlDeleteStrings;
    }

    protected final String[] getSQLInsertStrings() {
        return this.sqlInsertStrings;
    }

    protected final String[] getSQLIdentityInsertStrings() {
        return this.sqlIdentityInsertStrings;
    }

    protected final String[] getSQLUpdateStrings() {
        return this.sqlUpdateStrings;
    }

    protected final String getVersionSelectString() {
        return this.sqlVersionSelectString;
    }

    protected String[] generateDeleteStrings() {
        String[] result = new String[this.naturalOrderTableNames.length];
        for (int i = 0; i < this.naturalOrderTableNames.length; ++i) {
            Delete delete = new Delete().setTableName(this.naturalOrderTableNames[i]).setPrimaryKeyColumnNames(this.naturalOrderTableKeyColumns[i]);
            if (i == 0) {
                delete.setVersionColumnName(this.getVersionColumnName());
            }
            result[i] = delete.toStatementString();
        }
        return result;
    }

    protected String[] generateInsertStrings(boolean identityInsert, boolean[] includeProperty) {
        String[] result = new String[this.naturalOrderTableNames.length];
        for (int j = 0; j < this.naturalOrderTableNames.length; ++j) {
            Insert insert = new Insert(this.getDialect()).setTableName(this.naturalOrderTableNames[j]);
            for (int i = 0; i < this.getPropertyTypes().length; ++i) {
                if (!includeProperty[i] || this.naturalOrderPropertyTables[i] != j) continue;
                insert.addColumns(this.propertyColumnNames[i]);
            }
            if (identityInsert && j == 0) {
                insert.addIdentityColumn(this.naturalOrderTableKeyColumns[j][0]);
            } else {
                insert.addColumns(this.naturalOrderTableKeyColumns[j]);
            }
            result[j] = insert.toStatementString();
        }
        return result;
    }

    protected String[] generateUpdateStrings(boolean[] includeProperty) {
        String[] result = new String[this.naturalOrderTableNames.length];
        for (int j = 0; j < this.naturalOrderTableNames.length; ++j) {
            Update update = new Update().setTableName(this.naturalOrderTableNames[j]).setPrimaryKeyColumnNames(this.naturalOrderTableKeyColumns[j]);
            if (j == 0) {
                update.setVersionColumnName(this.getVersionColumnName());
            }
            boolean hasColumns = false;
            for (int i = 0; i < this.propertyColumnNames.length; ++i) {
                if (!includeProperty[i] || this.naturalOrderPropertyTables[i] != j) continue;
                update.addColumns(this.propertyColumnNames[i]);
                hasColumns = hasColumns || this.propertyColumnNames[i].length > 0;
            }
            result[j] = hasColumns ? update.toStatementString() : null;
        }
        return result;
    }

    protected String generateLockString() {
        SimpleSelect select = new SimpleSelect().setTableName(this.qualifiedTableName).addColumn(super.getIdentifierColumnNames()[0]).addCondition(super.getIdentifierColumnNames(), "=?");
        if (this.isVersioned()) {
            select.addWhereToken("and").addCondition(this.getVersionColumnName(), "=?");
        }
        return select.toStatementString();
    }

    protected String getConcreteSelectString() {
        return this.sqlConcreteSelectString;
    }

    protected String generateConcreteSelectString() {
        String select = "select " + StringHelper.join(", ", StringHelper.qualify(CONCRETE_ALIAS, this.getIdentifierColumnNames())) + this.concretePropertySelectFragment(CONCRETE_ALIAS, this.getPropertyUpdateability()) + " from " + this.fromTableFragment(CONCRETE_ALIAS) + this.fromJoinFragment(CONCRETE_ALIAS, true, false) + " where " + this.whereJoinFragment(CONCRETE_ALIAS, true, false) + StringHelper.join("=? and ", StringHelper.qualify(CONCRETE_ALIAS, this.getIdentifierColumnNames())) + "=?";
        if (this.isVersioned()) {
            select = select + " and " + this.getVersionColumnName() + "=?";
        }
        return select;
    }

    protected int dehydrate(Serializable id, Object[] fields, boolean[] includeProperty, PreparedStatement[] statements, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dehydrating entity: " + MessageHelper.infoString(this, id)));
        }
        int versionParam = 0;
        for (int i = 0; i < this.tableNames.length; ++i) {
            int index = this.dehydrate(id, fields, includeProperty, i, statements[i], session);
            if (i != 0) continue;
            versionParam = index;
        }
        return versionParam;
    }

    private int dehydrate(Serializable id, Object[] fields, boolean[] includeProperty, int table, PreparedStatement statement, SessionImplementor session) throws SQLException, HibernateException {
        if (statement == null) {
            return -1;
        }
        int index = 1;
        for (int j = 0; j < this.getHydrateSpan(); ++j) {
            if (!includeProperty[j] || this.naturalOrderPropertyTables[j] != table) continue;
            this.getPropertyTypes()[j].nullSafeSet(statement, fields[j], index, session);
            index += this.propertyColumnSpans[j];
        }
        if (id != null) {
            this.getIdentifierType().nullSafeSet(statement, id, index, session);
            index += this.getIdentifierColumnNames().length;
        }
        return index;
    }

    public Object load(Serializable id, Object optionalObject, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Materializing entity: " + MessageHelper.infoString(this, id)));
        }
        try {
            Object result = this.loader.load(session, id, optionalObject);
            if (result != null) {
                this.lock(id, this.getVersion(result), result, lockMode, session);
            }
            return result;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not load by id: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, LockMode lockMode, SessionImplementor session) throws HibernateException {
        if (lockMode != LockMode.NONE) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Locking entity: " + MessageHelper.infoString(this, id)));
                if (this.isVersioned()) {
                    log.trace((Object)("Version: " + version));
                }
            }
            try {
                PreparedStatement st = session.getBatcher().prepareStatement((String)this.lockers.get(lockMode));
                try {
                    this.getIdentifierType().nullSafeSet(st, id, 1, session);
                    if (this.isVersioned()) {
                        this.getVersionType().nullSafeSet(st, version, this.getIdentifierColumnNames().length + 1, session);
                    }
                    ResultSet rs = st.executeQuery();
                    try {
                        if (!rs.next()) {
                            throw new StaleObjectStateException(this.getMappedClass(), id);
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                finally {
                    session.getBatcher().closeStatement(st);
                }
            }
            catch (SQLException sqle) {
                throw new JDBCException("could not lock: " + MessageHelper.infoString(this, id), sqle);
            }
        }
    }

    public Serializable insert(Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            return this.insert(fields, notNull, this.generateInsertStrings(true, notNull), object, session);
        }
        return this.insert(fields, this.getPropertyInsertability(), this.getSQLIdentityInsertStrings(), object, session);
    }

    public void insert(Serializable id, Object[] fields, Object object, SessionImplementor session) throws HibernateException {
        if (this.useDynamicInsert()) {
            boolean[] notNull = this.getNotNullInsertableColumns(fields);
            this.insert(id, fields, notNull, this.generateInsertStrings(false, notNull), object, session);
        } else {
            this.insert(id, fields, this.getPropertyInsertability(), this.getSQLInsertStrings(), object, session);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(Serializable id, Object[] fields, boolean[] notNull, String[] sql, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + MessageHelper.infoString(this, id)));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        try {
            int i3;
            PreparedStatement[] statements = new PreparedStatement[this.tableNames.length];
            try {
                try {
                    int i2;
                    for (i2 = 0; i2 < this.tableNames.length; ++i2) {
                        statements[i2] = session.getBatcher().prepareStatement(sql[i2]);
                    }
                    this.dehydrate(id, fields, notNull, statements, session);
                    for (i2 = 0; i2 < this.tableNames.length; ++i2) {
                        statements[i2].executeUpdate();
                    }
                    Object var10_11 = null;
                    i3 = 0;
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                int i3 = 0;
                while (i3 < this.tableNames.length) {
                    if (statements[i3] != null) {
                        session.getBatcher().closeStatement(statements[i3]);
                    }
                    ++i3;
                }
                throw throwable;
            }
            while (i3 < this.tableNames.length) {
                if (statements[i3] != null) {
                    session.getBatcher().closeStatement(statements[i3]);
                }
                ++i3;
            }
            return;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not insert: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable insert(Object[] fields, boolean[] notNull, String[] sql, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting entity: " + this.getClassName() + " (native id)"));
            if (this.isVersioned()) {
                log.trace((Object)("Version: " + Versioning.getVersion(fields, this)));
            }
        }
        try {
            Serializable id;
            PreparedStatement statement = session.getBatcher().prepareStatement(sql[0]);
            try {
                this.dehydrate(null, fields, notNull, 0, statement, session);
                statement.executeUpdate();
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            finally {
                session.getBatcher().closeStatement(statement);
            }
            PreparedStatement idselect = session.getBatcher().prepareStatement(this.sqlIdentitySelect());
            try {
                ResultSet rs = idselect.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new HibernateException("The database returned no natively generated identity value");
                    }
                    id = IdentifierGeneratorFactory.get(rs, this.getIdentifierType(), session, object);
                }
                finally {
                    rs.close();
                }
                log.debug((Object)("Natively generated identity: " + id));
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
            finally {
                session.getBatcher().closeStatement(idselect);
            }
            for (int i = 1; i < this.naturalOrderTableNames.length; ++i) {
                statement = session.getBatcher().prepareStatement(sql[i]);
                try {
                    this.dehydrate(id, fields, notNull, i, statement, session);
                    statement.executeUpdate();
                    continue;
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
                finally {
                    session.getBatcher().closeStatement(statement);
                }
            }
            return id;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not insert: " + MessageHelper.infoString(this), sqle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Serializable id, Object version, Object object, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deleting entity: " + MessageHelper.infoString(this, id)));
        }
        try {
            int i3;
            PreparedStatement[] statements = new PreparedStatement[this.naturalOrderTableNames.length];
            try {
                try {
                    int i2;
                    for (i2 = 0; i2 < this.naturalOrderTableNames.length; ++i2) {
                        statements[i2] = session.getBatcher().prepareStatement(this.getSQLDeleteStrings()[i2]);
                    }
                    if (this.isVersioned()) {
                        this.getVersionType().nullSafeSet(statements[0], version, this.getIdentifierColumnNames().length + 1, session);
                    }
                    for (i2 = this.naturalOrderTableNames.length - 1; i2 >= 0; --i2) {
                        this.getIdentifierType().nullSafeSet(statements[i2], id, 1, session);
                        this.check(statements[i2].executeUpdate(), id);
                    }
                    Object var8_9 = null;
                    i3 = 0;
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                int i3 = 0;
                while (i3 < this.naturalOrderTableNames.length) {
                    if (statements[i3] != null) {
                        session.getBatcher().closeStatement(statements[i3]);
                    }
                    ++i3;
                }
                throw throwable;
            }
            while (i3 < this.naturalOrderTableNames.length) {
                if (statements[i3] != null) {
                    session.getBatcher().closeStatement(statements[i3]);
                }
                ++i3;
            }
            return;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not delete: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    private boolean[] getTableUpdateNeeded(int[] dirtyFields) {
        if (dirtyFields == null) {
            return this.propertyHasColumns;
        }
        boolean[] tableUpdateNeeded = new boolean[this.naturalOrderTableNames.length];
        for (int i = 0; i < dirtyFields.length; ++i) {
            int table = this.naturalOrderPropertyTables[dirtyFields[i]];
            tableUpdateNeeded[table] = tableUpdateNeeded[table] || this.propertyColumnSpans[dirtyFields[i]] > 0;
        }
        if (this.isVersioned()) {
            tableUpdateNeeded[0] = true;
        }
        return tableUpdateNeeded;
    }

    public void update(Serializable id, Object[] fields, int[] dirtyFields, Object[] oldFields, Object oldVersion, Object object, SessionImplementor session) throws HibernateException {
        String[] updateStrings;
        boolean[] propsToUpdate;
        boolean[] tableUpdateNeeded = this.getTableUpdateNeeded(dirtyFields);
        if (this.useDynamicUpdate() && dirtyFields != null) {
            propsToUpdate = this.getPropertiesToUpdate(dirtyFields);
            updateStrings = this.generateUpdateStrings(propsToUpdate);
        } else {
            propsToUpdate = this.getPropertyUpdateability();
            updateStrings = this.getSQLUpdateStrings();
        }
        this.update(id, fields, propsToUpdate, tableUpdateNeeded, oldVersion, object, updateStrings, session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(Serializable id, Object[] fields, boolean[] includeProperty, boolean[] includeTable, Object oldVersion, Object object, String[] sql, SessionImplementor session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating entity: " + MessageHelper.infoString(this, id)));
            if (this.isVersioned()) {
                log.trace((Object)("Existing version: " + oldVersion + " -> New version: " + fields[this.getVersionProperty()]));
            }
        }
        int tables = this.naturalOrderTableNames.length;
        try {
            int i4;
            PreparedStatement[] statements = new PreparedStatement[tables];
            try {
                try {
                    for (int i2 = 0; i2 < tables; ++i2) {
                        if (!includeTable[i2]) continue;
                        statements[i2] = session.getBatcher().prepareStatement(sql[i2]);
                    }
                    int versionParam = this.dehydrate(id, fields, includeProperty, statements, session);
                    if (this.isVersioned()) {
                        this.getVersionType().nullSafeSet(statements[0], oldVersion, versionParam, session);
                    }
                    for (int i3 = 0; i3 < tables; ++i3) {
                        if (!includeTable[i3]) continue;
                        this.check(statements[i3].executeUpdate(), id);
                    }
                    Object var14_15 = null;
                    i4 = 0;
                }
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                int i4 = 0;
                while (i4 < tables) {
                    if (statements[i4] != null) {
                        session.getBatcher().closeStatement(statements[i4]);
                    }
                    ++i4;
                }
                throw throwable;
            }
            while (i4 < tables) {
                if (statements[i4] != null) {
                    session.getBatcher().closeStatement(statements[i4]);
                }
                ++i4;
            }
            return;
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not delete: " + MessageHelper.infoString(this, id), sqle);
        }
    }

    public NormalizedEntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws HibernateException {
        super(model, factory);
        Integer discriminatorValue;
        this.factory = factory;
        Table table = model.getRootTable();
        this.qualifiedTableName = table.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
        if (model.isPolymorphic()) {
            this.discriminatorColumnName = "clazz_";
            try {
                this.discriminatorType = (DiscriminatorType)((Object)Hibernate.INTEGER);
                discriminatorValue = new Integer(0);
                this.discriminatorSQLString = "0";
            }
            catch (Exception e) {
                throw new MappingException("Could not format discriminator value to SQL string", e);
            }
        } else {
            this.discriminatorColumnName = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockMode() != 0) {
            throw new MappingException("optimistic-lock attribute not supported for joined-subclass mappings: " + this.getClassName());
        }
        ArrayList<String> tables = new ArrayList<String>();
        ArrayList<String[]> keyColumns = new ArrayList<String[]>();
        tables.add(this.qualifiedTableName);
        keyColumns.add(super.getIdentifierColumnNames());
        int idColumnSpan = super.getIdentifierColumnNames().length;
        Iterator titer = model.getTableClosureIterator();
        while (titer.hasNext()) {
            Table tab = (Table)titer.next();
            String tabname = tab.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
            if (tabname.equals(this.qualifiedTableName)) continue;
            tables.add(tabname);
            String[] key = new String[idColumnSpan];
            Iterator kiter = tab.getPrimaryKey().getColumnIterator();
            for (int k = 0; k < idColumnSpan; ++k) {
                key[k] = ((Column)kiter.next()).getQuotedName(this.getDialect());
            }
            keyColumns.add(key);
        }
        this.naturalOrderTableNames = tables.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.naturalOrderTableKeyColumns = (String[][])keyColumns.toArray((T[])new String[0][]);
        ArrayList<String> subtables = new ArrayList<String>();
        keyColumns = new ArrayList();
        subtables.add(this.qualifiedTableName);
        keyColumns.add(super.getIdentifierColumnNames());
        titer = model.getSubclassTableClosureIterator();
        while (titer.hasNext()) {
            Table tab = (Table)titer.next();
            String tabname = tab.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
            if (tabname.equals(this.qualifiedTableName)) continue;
            subtables.add(tabname);
            String[] key = new String[idColumnSpan];
            Iterator kiter = tab.getPrimaryKey().getColumnIterator();
            for (int k = 0; k < idColumnSpan; ++k) {
                key[k] = ((Column)kiter.next()).getQuotedName(this.getDialect());
            }
            keyColumns.add(key);
        }
        this.subclassTableNameClosure = subtables.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassTableKeyColumns = (String[][])keyColumns.toArray((T[])new String[0][]);
        this.isClassOrSuperclassTable = new boolean[this.subclassTableNameClosure.length];
        for (int j = 0; j < this.subclassTableNameClosure.length; ++j) {
            this.isClassOrSuperclassTable[j] = tables.contains(this.subclassTableNameClosure[j]);
        }
        int len = this.naturalOrderTableNames.length;
        this.tableNames = NormalizedEntityPersister.reverse(this.naturalOrderTableNames);
        this.tableKeyColumns = NormalizedEntityPersister.reverse(this.naturalOrderTableKeyColumns);
        NormalizedEntityPersister.reverse(this.subclassTableNameClosure, len);
        NormalizedEntityPersister.reverse((Object[])this.subclassTableKeyColumns, len);
        int hydrateSpan = this.getHydrateSpan();
        this.propertyTables = new int[hydrateSpan];
        this.naturalOrderPropertyTables = new int[hydrateSpan];
        this.propertyColumnNames = new String[hydrateSpan][];
        this.propertyColumnAliases = new String[hydrateSpan][];
        this.propertyColumnSpans = new int[hydrateSpan];
        this.propertyFormulaTemplates = new String[hydrateSpan];
        HashSet<Property> thisClassProperties = new HashSet<Property>();
        Iterator iter = model.getPropertyClosureIterator();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            thisClassProperties.add(prop);
            Table tab = prop.getValue().getTable();
            String tabname = tab.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
            this.propertyTables[i] = NormalizedEntityPersister.getTableId(tabname, this.tableNames);
            this.naturalOrderPropertyTables[i] = NormalizedEntityPersister.getTableId(tabname, this.naturalOrderTableNames);
            if (prop.isFormula()) {
                this.propertyColumnAliases[i] = new String[]{prop.getFormula().getAlias()};
                this.propertyColumnSpans[i] = 1;
                this.propertyFormulaTemplates[i] = prop.getFormula().getTemplate(this.getDialect());
            } else {
                this.propertyColumnSpans[i] = prop.getColumnSpan();
                String[] propCols = new String[this.propertyColumnSpans[i]];
                String[] propAliases = new String[this.propertyColumnSpans[i]];
                Iterator colIter = prop.getColumnIterator();
                int j = 0;
                while (colIter.hasNext()) {
                    String colname;
                    Column col = (Column)colIter.next();
                    propCols[j] = colname = col.getQuotedName(this.getDialect());
                    propAliases[j] = col.getAlias() + tab.getUniqueInteger() + '_';
                    ++j;
                }
                this.propertyColumnNames[i] = propCols;
                this.propertyColumnAliases[i] = propAliases;
            }
            ++i;
        }
        HashSet distinctColumns = new HashSet();
        this.checkColumnDuplication(distinctColumns, model.getKey().getColumnIterator());
        iter = model.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.isUpdateable() && !prop.isInsertable()) continue;
            this.checkColumnDuplication(distinctColumns, prop.getColumnIterator());
        }
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<String> formulaAliases = new ArrayList<String>();
        ArrayList<String> formulaTemplates = new ArrayList<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String[]> propColumns = new ArrayList<String[]>();
        ArrayList<Integer> coltables = new ArrayList<Integer>();
        ArrayList<Integer> formtables = new ArrayList<Integer>();
        ArrayList<Integer> joinedFetchesList = new ArrayList<Integer>();
        ArrayList<Integer> propTables = new ArrayList<Integer>();
        ArrayList<Boolean> definedBySubclass = new ArrayList<Boolean>();
        iter = model.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            names.add(prop.getName());
            definedBySubclass.add(new Boolean(!thisClassProperties.contains(prop)));
            Table tab = prop.getValue().getTable();
            String tabname = tab.getQualifiedName(this.getDialect(), factory.getDefaultSchema());
            Integer tabnum = new Integer(NormalizedEntityPersister.getTableId(tabname, this.subclassTableNameClosure));
            propTables.add(tabnum);
            types.add(prop.getType());
            if (prop.isFormula()) {
                formulaTemplates.add(prop.getFormula().getTemplate(this.getDialect()));
                propColumns.add(ArrayHelper.EMPTY_STRING_ARRAY);
                formulaAliases.add(prop.getFormula().getAlias());
                formtables.add(tabnum);
            } else {
                Iterator colIter = prop.getColumnIterator();
                String[] cols = new String[prop.getColumnSpan()];
                int l = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    columns.add(col.getQuotedName(this.getDialect()));
                    coltables.add(tabnum);
                    cols[l++] = col.getQuotedName(this.getDialect());
                    aliases.add(col.getAlias() + tab.getUniqueInteger() + '_');
                }
                propColumns.add(cols);
            }
            joinedFetchesList.add(new Integer(prop.getValue().getOuterJoinFetchSetting()));
        }
        this.subclassColumnClosure = columns.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassColumnClosureAliases = aliases.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(coltables);
        this.subclassPropertyTypeClosure = types.toArray(ArrayHelper.EMPTY_TYPE_ARRAY);
        this.subclassPropertyNameClosure = names.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propTables);
        this.subclassFormulaAliasClosure = formulaAliases.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassFormulaTemplateClosure = formulaTemplates.toArray(ArrayHelper.EMPTY_STRING_ARRAY);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(formtables);
        this.subclassPropertyColumnNameClosure = (String[][])propColumns.toArray((T[])new String[propColumns.size()][]);
        this.subclassPropertyEnableJoinedFetch = new int[joinedFetchesList.size()];
        iter = joinedFetchesList.iterator();
        int j = 0;
        while (iter.hasNext()) {
            this.subclassPropertyEnableJoinedFetch[j++] = (Integer)iter.next();
        }
        this.propertyDefinedOnSubclass = new boolean[definedBySubclass.size()];
        iter = definedBySubclass.iterator();
        j = 0;
        while (iter.hasNext()) {
            this.propertyDefinedOnSubclass[j++] = (Boolean)iter.next();
        }
        this.sqlDeleteStrings = this.generateDeleteStrings();
        this.sqlInsertStrings = this.generateInsertStrings(false, this.getPropertyInsertability());
        this.sqlIdentityInsertStrings = this.isIdentifierAssignedByInsert() ? this.generateInsertStrings(true, this.getPropertyInsertability()) : null;
        this.sqlUpdateStrings = this.generateUpdateStrings(this.getPropertyUpdateability());
        String lockString = this.generateLockString();
        this.lockers.put(LockMode.READ, lockString);
        String lockExclusiveString = this.getDialect().supportsForUpdate() ? lockString + " for update" : lockString;
        this.lockers.put(LockMode.UPGRADE, lockExclusiveString);
        String lockExclusiveNowaitString = this.getDialect().supportsForUpdateNowait() ? lockString + " for update nowait" : lockExclusiveString;
        this.lockers.put(LockMode.UPGRADE_NOWAIT, lockExclusiveNowaitString);
        this.sqlVersionSelectString = this.generateSelectVersionString();
        this.sqlConcreteSelectString = this.generateConcreteSelectString();
        Class mappedClass = model.getMappedClass();
        int subclassSpan = model.getSubclassSpan() + 1;
        this.subclassClosure = new Class[subclassSpan];
        this.subclassClosure[subclassSpan - 1] = mappedClass;
        if (model.isPolymorphic()) {
            int id;
            this.subclassesByDiscriminatorValue.put(discriminatorValue, mappedClass);
            this.discriminatorValues = new String[subclassSpan];
            this.discriminatorValues[subclassSpan - 1] = this.discriminatorSQLString;
            this.tableNumbers = new int[subclassSpan];
            this.tableNumbers[subclassSpan - 1] = id = NormalizedEntityPersister.getTableId(model.getTable().getQualifiedName(this.getDialect(), factory.getDefaultSchema()), this.subclassTableNameClosure);
            this.notNullColumns = new String[subclassSpan];
            this.notNullColumns[subclassSpan - 1] = this.subclassTableKeyColumns[id][0];
        } else {
            this.discriminatorValues = null;
            this.tableNumbers = null;
            this.notNullColumns = null;
        }
        iter = model.getSubclassIterator();
        int k = 0;
        while (iter.hasNext()) {
            Subclass sc = (Subclass)iter.next();
            this.subclassClosure[k] = sc.getMappedClass();
            try {
                if (model.isPolymorphic()) {
                    int id;
                    Integer disc = new Integer(k + 1);
                    this.subclassesByDiscriminatorValue.put(disc, sc.getMappedClass());
                    this.discriminatorValues[k] = ((Object)disc).toString();
                    this.tableNumbers[k] = id = NormalizedEntityPersister.getTableId(sc.getTable().getQualifiedName(this.getDialect(), factory.getDefaultSchema()), this.subclassTableNameClosure);
                    this.notNullColumns[k] = this.subclassTableKeyColumns[id][0];
                }
            }
            catch (Exception e) {
                throw new MappingException("Error parsing discriminator value", e);
            }
            ++k;
        }
        this.propertyHasColumns = new boolean[this.sqlUpdateStrings.length];
        for (int m = 0; m < this.sqlUpdateStrings.length; ++m) {
            this.propertyHasColumns[m] = this.sqlUpdateStrings[m] != null;
        }
        this.initSubclassPropertyAliasesMap(model);
    }

    private static final void reverse(Object[] objects, int len) {
        int i;
        Object[] temp = new Object[len];
        for (i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        for (i = 0; i < len; ++i) {
            objects[i] = temp[i];
        }
    }

    private static final String[] reverse(String[] objects) {
        int len = objects.length;
        String[] temp = new String[len];
        for (int i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        return temp;
    }

    private static final String[][] reverse(String[][] objects) {
        int len = objects.length;
        String[][] temp = new String[len][];
        for (int i = 0; i < len; ++i) {
            temp[i] = objects[len - i - 1];
        }
        return temp;
    }

    protected int getPropertyTableNumber(String propertyName) {
        String[] propertyNames = this.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyName.equals(propertyNames[i])) continue;
            return this.propertyTables[i];
        }
        return 0;
    }

    protected void handlePath(String path, Type type) {
        if (type.isAssociationType() && ((AssociationType)type).usePrimaryKeyAsForeignKey()) {
            this.tableNumberByPropertyPath.put(path, new Integer(0));
        } else {
            String propertyName = StringHelper.root(path);
            this.tableNumberByPropertyPath.put(path, new Integer(this.getPropertyTableNumber(propertyName)));
        }
    }

    public String fromTableFragment(String alias) {
        return this.subclassTableNameClosure[0] + ' ' + alias;
    }

    public String getTableName() {
        return this.subclassTableNameClosure[0];
    }

    private JoinFragment outerjoin(String name, boolean innerJoin, boolean includeSubclasses) {
        JoinFragment outerjoin = this.factory.getDialect().createOuterJoinFragment();
        for (int i = 1; i < this.subclassTableNameClosure.length; ++i) {
            if (!includeSubclasses && !this.isClassOrSuperclassTable[i]) continue;
            outerjoin.addJoin(this.subclassTableNameClosure[i], NormalizedEntityPersister.alias(name, i), StringHelper.qualify(name, this.getIdentifierColumnNames()), this.subclassTableKeyColumns[i], innerJoin && this.isClassOrSuperclassTable[i] ? 0 : 1);
        }
        return outerjoin;
    }

    private static int getTableId(String tableName, String[] tables) {
        for (int tab = 0; tab < tables.length; ++tab) {
            if (!tableName.equals(tables[tab])) continue;
            return tab;
        }
        throw new AssertionFailure("table not found");
    }

    public String[] toColumns(String alias, String property) throws QueryException {
        if ("class".equals(property)) {
            return new String[]{this.discriminatorFragment(alias).toFragmentString()};
        }
        int tab = (Integer)this.tableNumberByPropertyPath.get(property);
        return super.toColumns(NormalizedEntityPersister.alias(alias, tab), property);
    }

    public String[] toColumns(String alias, int i) {
        int tab = this.subclassPropertyTableNumberClosure[i];
        return StringHelper.qualify(NormalizedEntityPersister.alias(alias, tab), this.subclassPropertyColumnNameClosure[i]);
    }

    private String concretePropertySelectFragment(String alias, boolean[] includeProperty) {
        int propertyCount = this.getPropertyNames().length;
        SelectFragment frag = new SelectFragment();
        for (int i = 0; i < propertyCount; ++i) {
            if (!includeProperty[i]) continue;
            frag.addColumns(NormalizedEntityPersister.alias(alias, this.propertyTables[i]), this.propertyColumnNames[i], this.propertyColumnAliases[i]);
        }
        return frag.toFragmentString();
    }

    public String propertySelectFragment(String alias, String suffix) {
        String subalias;
        int i;
        SelectFragment frag = new SelectFragment().setSuffix(suffix);
        for (i = 0; i < this.subclassColumnClosure.length; ++i) {
            subalias = NormalizedEntityPersister.alias(alias, this.subclassColumnTableNumberClosure[i]);
            frag.addColumn(subalias, this.subclassColumnClosure[i], this.subclassColumnClosureAliases[i]);
        }
        for (i = 0; i < this.subclassFormulaTemplateClosure.length; ++i) {
            subalias = NormalizedEntityPersister.alias(alias, this.subclassFormulaTableNumberClosure[i]);
            frag.addFormula(subalias, this.subclassFormulaTemplateClosure[i], this.subclassFormulaAliasClosure[i]);
        }
        if (this.hasSubclasses()) {
            return ", " + this.discriminatorFragment(alias).setReturnColumnName(this.getDiscriminatorAlias(), suffix).toFragmentString() + frag.toFragmentString();
        }
        return frag.toFragmentString();
    }

    private CaseFragment discriminatorFragment(String alias) {
        CaseFragment cases = this.getDialect().createCaseFragment();
        for (int i = 0; i < this.discriminatorValues.length; ++i) {
            cases.addWhenColumnNotNull(NormalizedEntityPersister.alias(alias, this.tableNumbers[i]), this.notNullColumns[i], this.discriminatorValues[i]);
        }
        return cases;
    }

    private static String alias(String name, int tableNumber) {
        if (tableNumber == 0) {
            return name;
        }
        return name + '_' + tableNumber + '_';
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return this.outerjoin(alias, innerJoin, includeSubclasses).toFromFragmentString();
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return this.outerjoin(alias, innerJoin, includeSubclasses).toWhereFragmentString();
    }

    public String queryWhereFragment(String alias, boolean innerJoin, boolean includeSubclasses) throws MappingException {
        String result = this.whereJoinFragment(alias, innerJoin, includeSubclasses);
        String rootAlias = NormalizedEntityPersister.alias(alias, this.naturalOrderTableNames.length - 1);
        if (this.hasWhere()) {
            result = result + " and " + this.getSQLWhereString(rootAlias);
        }
        return result;
    }

    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    protected String[] getActualPropertyColumnNames(int i) {
        return this.propertyColumnNames[i];
    }

    protected String getFormulaTemplate(int i) {
        return this.propertyFormulaTemplates[i];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

