/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ArrayHelper;

public class DynamicComponentType
extends AbstractType
implements AbstractComponentType {
    private String[] propertyNames;
    private Type[] propertyTypes;
    private int propertySpan;
    private final Cascades.CascadeStyle[] cascade;
    private final int[] joinedFetch;
    static /* synthetic */ Class class$java$util$Map;

    public DynamicComponentType(String[] propertyNames, Type[] propertyTypes, int[] joinedFetch, Cascades.CascadeStyle[] cascade) {
        this.propertyNames = propertyNames;
        this.propertyTypes = propertyTypes;
        this.joinedFetch = joinedFetch;
        this.cascade = cascade;
        this.propertySpan = propertyTypes.length;
    }

    public Cascades.CascadeStyle cascade(int i) {
        return this.cascade[i];
    }

    public int enableJoinedFetch(int i) {
        return this.joinedFetch[i];
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component);
    }

    public Object getPropertyValue(Object component, int i) throws HibernateException {
        return ((Map)component).get(this.propertyNames[i]);
    }

    public Object[] getPropertyValues(Object component) throws HibernateException {
        Map bean = (Map)component;
        Object[] result = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            result[i] = bean.get(this.propertyNames[i]);
        }
        return result;
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public Object instantiate() throws HibernateException {
        return new HashMap();
    }

    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        Map map = (Map)component;
        for (int i = 0; i < this.propertySpan; ++i) {
            map.put(this.propertyNames[i], values[i]);
        }
    }

    public Object deepCopy(Object component) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component);
        for (int i = 0; i < this.propertySpan; ++i) {
            values[i] = this.propertyTypes[i].deepCopy(values[i]);
        }
        Object result = this.instantiate();
        this.setPropertyValues(result, values);
        return result;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        for (int i = 0; i < this.propertySpan; ++i) {
            if (this.propertyTypes[i].equals(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        Map xbean = (Map)x;
        Map ybean = (Map)y;
        for (int i = 0; i < this.propertySpan; ++i) {
            if (!this.propertyTypes[i].isDirty(xbean.get(this.propertyNames[i]), ybean.get(this.propertyNames[i]), session)) continue;
            return true;
        }
        return false;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            span += this.propertyTypes[i].getColumnSpan(mapping);
        }
        return span;
    }

    public String getName() {
        return (class$java$util$Map == null ? (class$java$util$Map = DynamicComponentType.class$("java.util.Map")) : class$java$util$Map).getName();
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public boolean isMutable() {
        return true;
    }

    private Object[] nullSafeGetValues(Object value) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            int length = this.propertyTypes[i].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i].nullSafeGet(rs, range, session, owner);
            if (val != null) {
                notNull = true;
            }
            values[i] = val;
            begin += length;
        }
        if (notNull) {
            Map result = (Map)this.instantiate();
            for (int i = 0; i < this.propertySpan; ++i) {
                result.put(this.propertyNames[i], values[i]);
            }
            return result;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value);
        for (int i = 0; i < this.propertySpan; ++i) {
            this.propertyTypes[i].nullSafeSet(st, subvalues[i], begin, session);
            begin += this.propertyTypes[i].getColumnSpan(session.getFactory());
        }
    }

    public Class getReturnedClass() {
        return class$java$util$Map == null ? (class$java$util$Map = DynamicComponentType.class$("java.util.Map")) : class$java$util$Map;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n = 0;
        for (int i = 0; i < this.propertySpan; ++i) {
            int[] subtypes = this.propertyTypes[i].sqlTypes(mapping);
            for (int j = 0; j < subtypes.length; ++j) {
                sqlTypes[n++] = subtypes[j];
            }
        }
        return sqlTypes;
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Object fromString(String xml, SessionFactoryImplementor factory) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

