/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.persister.UniqueKeyLoadable;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final Class associatedClass;
    private final boolean niceEquals;
    protected final String uniqueKeyPropertyName;

    public final boolean isEntityType() {
        return true;
    }

    public final Class getAssociatedClass() {
        return this.associatedClass;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    protected EntityType(Class persistentClass, String uniqueKeyPropertyName) {
        this.associatedClass = persistentClass;
        this.niceEquals = !ReflectHelper.overridesEquals(persistentClass);
        this.uniqueKeyPropertyName = uniqueKeyPropertyName;
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public final Class getReturnedClass() {
        return this.associatedClass;
    }

    protected final Object getIdentifier(Object value, SessionImplementor session) throws HibernateException {
        if (this.uniqueKeyPropertyName == null) {
            return session.getEntityIdentifierIfNotUnsaved(value);
        }
        if (value == null) {
            return null;
        }
        return session.getFactory().getPersister(this.getAssociatedClass()).getPropertyValue(value, this.uniqueKeyPropertyName);
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        ClassPersister persister = factory.getPersister(this.associatedClass);
        if (value == null) {
            return "null";
        }
        StringBuffer result = new StringBuffer().append(StringHelper.unqualify(HibernateProxyHelper.getClass(value).getName()));
        if (persister.hasIdentifierProperty()) {
            result.append('#').append(persister.getIdentifierType().toString(HibernateProxyHelper.getIdentifier(value, persister), factory));
        }
        return result.toString();
    }

    public Object fromString(String xml, SessionFactoryImplementor factory) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.associatedClass.getName();
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public abstract boolean isOneToOne();

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getEntityIdentifierIfNotUnsaved(value);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.associatedClass.getName());
        }
        return this.getIdentifierType(session).disassemble(id, session);
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdentifierType(session).assemble(oid, session, owner);
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }

    public Object copy(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        if (original == target) {
            return target;
        }
        Object id = this.getIdentifier(original, session);
        if (id == null) {
            throw new AssertionFailure("cannot copy a reference to an object with a null id");
        }
        id = this.getIdentifierOrUniqueKeyType(session).copy(id, null, session, owner);
        return this.resolveIdentifier(id, session, owner);
    }

    public boolean hasNiceEquals() {
        return this.niceEquals;
    }

    public boolean isAssociationType() {
        return true;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, names, session, owner), session, owner);
    }

    public abstract Object hydrate(ResultSet var1, String[] var2, SessionImplementor var3, Object var4) throws HibernateException, SQLException;

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (this.equals(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return !session.getFactory().getIdentifierType(this.associatedClass).equals(oldid, newid);
    }

    public Joinable getJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getPersister(this.associatedClass));
    }

    public String[] getReferencedColumns(SessionFactoryImplementor factory) throws MappingException {
        if (this.uniqueKeyPropertyName == null) {
            return this.getJoinable(factory).getJoinKeyColumnNames();
        }
        return ((UniqueKeyLoadable)((Object)this.getJoinable(factory))).getUniqueKeyColumnNames(this.uniqueKeyPropertyName);
    }

    private Type getIdentifierType(SessionImplementor session) throws MappingException {
        return session.getFactory().getIdentifierType(this.associatedClass);
    }

    protected final Type getIdentifierOrUniqueKeyType(SessionImplementor session) throws MappingException {
        if (this.uniqueKeyPropertyName == null) {
            return this.getIdentifierType(session);
        }
        return session.getFactory().getPersister(this.getAssociatedClass()).getPropertyType(this.uniqueKeyPropertyName);
    }

    protected abstract Object resolveIdentifier(Serializable var1, SessionImplementor var2) throws HibernateException;

    public Object resolveIdentifier(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = (Serializable)value;
        if (this.uniqueKeyPropertyName == null) {
            return this.resolveIdentifier(id, session);
        }
        return session.loadByUniqueKey(this.getAssociatedClass(), this.uniqueKeyPropertyName, id);
    }

    public Class getAssociatedClass(SessionFactoryImplementor factory) {
        return this.getAssociatedClass();
    }

    public Class getPersistentClass() {
        return this.associatedClass;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return ((EntityType)object).getAssociatedClass() == this.associatedClass;
    }

    public int hashCode() {
        return this.associatedClass.hashCode();
    }
}

