/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.LogFactory;

public abstract class NullableType
extends AbstractType {
    private static final boolean IS_TRACE_ENABLED = LogFactory.getLog((String)StringHelper.qualifier((class$net$sf$hibernate$type$Type == null ? (class$net$sf$hibernate$type$Type = NullableType.class$("net.sf.hibernate.type.Type")) : class$net$sf$hibernate$type$Type).getName())).isTraceEnabled();
    static /* synthetic */ Class class$net$sf$hibernate$type$Type;

    public abstract Object get(ResultSet var1, String var2) throws HibernateException, SQLException;

    public abstract void set(PreparedStatement var1, Object var2, int var3) throws HibernateException, SQLException;

    public abstract int sqlType();

    public abstract String toString(Object var1) throws HibernateException;

    public abstract Object fromString(String var1) throws HibernateException;

    public final void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index);
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            if (IS_TRACE_ENABLED) {
                LogFactory.getLog(this.getClass()).trace((Object)("binding null to parameter: " + index));
            }
            st.setNull(index, this.sqlType());
        } else {
            if (IS_TRACE_ENABLED) {
                LogFactory.getLog(this.getClass()).trace((Object)("binding '" + this.toString(value) + "' to parameter: " + index));
            }
            this.set(st, value, index);
        }
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0]);
    }

    public final Object nullSafeGet(ResultSet rs, String[] names) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0]);
    }

    public final Object nullSafeGet(ResultSet rs, String name) throws HibernateException, SQLException {
        Object value = this.get(rs, name);
        if (value == null || rs.wasNull()) {
            if (IS_TRACE_ENABLED) {
                LogFactory.getLog(this.getClass()).trace((Object)("returning null as column: " + name));
            }
            return null;
        }
        if (IS_TRACE_ENABLED) {
            LogFactory.getLog(this.getClass()).trace((Object)("returning '" + this.toString(value) + "' as column: " + name));
        }
        return value;
    }

    public final Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, name);
    }

    public final String toString(Object value, SessionFactoryImplementor pc) throws HibernateException {
        return value == null ? "null" : this.toString(value);
    }

    public final Object fromString(String xml, SessionFactoryImplementor pc) throws HibernateException {
        return xml == null || xml.length() == 0 ? null : this.fromString(xml);
    }

    public final int getColumnSpan(Mapping session) {
        return 1;
    }

    public final int[] sqlTypes(Mapping session) {
        return new int[]{this.sqlType()};
    }

    public abstract Object deepCopyNotNull(Object var1) throws HibernateException;

    public final Object deepCopy(Object value) throws HibernateException {
        return value == null ? null : this.deepCopyNotNull(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

