/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.ForeignKeyDirection;
import net.sf.hibernate.type.Type;

public abstract class PersistentCollectionType
extends AbstractType
implements AssociationType {
    private final String role;
    private static final int[] NO_INTS = new int[0];

    public PersistentCollectionType(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPersistentCollectionType() {
        return true;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    public abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2) throws HibernateException;

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        throw new AssertionFailure("bug in PersistentCollectionType");
    }

    public Object nullSafeGet(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, name, session, owner), session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        return NO_INTS;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    public String toString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        Type elemType = this.getElementType(factory);
        if (Hibernate.isInitialized(value)) {
            ArrayList<String> list = new ArrayList<String>();
            Iterator iter = this.getElementsIterator(value);
            while (iter.hasNext()) {
                list.add(elemType.toString(iter.next(), factory));
            }
            return ((Object)list).toString();
        }
        return "uninitialized";
    }

    public Object fromString(String xml, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public String getName() {
        return this.getReturnedClass().getName();
    }

    public Iterator getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return null;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = session.getEntityIdentifier(owner);
        if (id == null) {
            throw new AssertionFailure("bug re-assembling collection reference");
        }
        return this.resolveIdentifier(id, session, owner);
    }

    private boolean isOwnerVersioned(SessionImplementor session) throws MappingException {
        Class ownerClass = session.getFactory().getCollectionPersister(this.role).getOwnerClass();
        return session.getFactory().getPersister(ownerClass).isVersioned();
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        return this.isOwnerVersioned(session) && super.isDirty(old, current, session);
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_TO_PARENT;
    }

    public Object hydrate(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return session.getEntityIdentifier(owner);
    }

    public Object resolveIdentifier(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        return session.getCollection(this.role, (Serializable)value, owner);
    }

    public boolean isArrayType() {
        return false;
    }

    public abstract PersistentCollection assembleCachedCollection(SessionImplementor var1, CollectionPersister var2, Serializable var3, Object var4) throws HibernateException;

    public boolean usePrimaryKeyAsForeignKey() {
        return true;
    }

    public Joinable getJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getCollectionPersister(this.role));
    }

    public String[] getReferencedColumns(SessionFactoryImplementor factory) throws MappingException {
        return this.getJoinable(factory).getJoinKeyColumnNames();
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) throws HibernateException {
        return false;
    }

    public Class getAssociatedClass(SessionFactoryImplementor factory) throws MappingException {
        try {
            QueryableCollection collectionPersister = (QueryableCollection)factory.getCollectionPersister(this.role);
            return collectionPersister.getElementPersister().getMappedClass();
        }
        catch (ClassCastException cce) {
            throw new MappingException("collection role is not queryable " + this.role);
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return ((PersistentCollectionType)object).getRole().equals(this.role);
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public Object copy(Object original, Object target, SessionImplementor session, Object owner) throws HibernateException {
        if (original == null) {
            return null;
        }
        Type elemType = this.getElementType(session.getFactory());
        Collection result = (Collection)target;
        result.clear();
        Iterator iter = ((Collection)original).iterator();
        while (iter.hasNext()) {
            result.add(elemType.copy(iter.next(), null, session, owner));
        }
        return result;
    }

    protected final Type getElementType(SessionFactoryImplementor factory) throws MappingException {
        return factory.getCollectionPersister(this.getRole()).getElementType();
    }
}

