/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.MutableType;
import net.sf.hibernate.type.SerializationException;
import net.sf.hibernate.util.SerializationHelper;

public class SerializableType
extends MutableType {
    private final Class serializableClass;
    static /* synthetic */ Class class$java$io$Serializable;

    public SerializableType(Class serializableClass) {
        this.serializableClass = serializableClass;
    }

    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        Hibernate.BINARY.set(st, SerializableType.toBytes(value), index);
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        byte[] bytes = (byte[])Hibernate.BINARY.get(rs, name);
        if (bytes == null) {
            return null;
        }
        return SerializableType.fromBytes(bytes);
    }

    public Class getReturnedClass() {
        return this.serializableClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return Hibernate.BINARY.equals(SerializableType.toBytes(x), SerializableType.toBytes(y));
    }

    public String toString(Object value) throws HibernateException {
        return Hibernate.BINARY.toString(SerializableType.toBytes(value));
    }

    public Object fromString(String xml) throws HibernateException {
        return SerializableType.fromBytes((byte[])Hibernate.BINARY.fromString(xml));
    }

    public String getName() {
        return this.serializableClass == (class$java$io$Serializable == null ? (class$java$io$Serializable = SerializableType.class$("java.io.Serializable")) : class$java$io$Serializable) ? "serializable" : this.serializableClass.getName();
    }

    public Object deepCopyNotNull(Object value) throws HibernateException {
        return SerializableType.fromBytes(SerializableType.toBytes(value));
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private static Object fromBytes(byte[] bytes) throws SerializationException {
        return SerializationHelper.deserialize(bytes);
    }

    public int sqlType() {
        return Hibernate.BINARY.sqlType();
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return cached == null ? null : SerializableType.fromBytes((byte[])cached);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : SerializableType.toBytes(value);
    }

    public boolean equals(Object object) {
        return super.equals(object) ? ((SerializableType)object).serializableClass == this.serializableClass : false;
    }

    public int hashCode() {
        return this.serializableClass.hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

