/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import net.sf.cglib.reflect.FastClass;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.property.BasicPropertyAccessor;
import net.sf.hibernate.property.Getter;
import net.sf.hibernate.property.PropertyAccessor;
import net.sf.hibernate.type.PrimitiveType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReflectHelper {
    private static final Log log;
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    public static final String PROPERTY_ACCESS_EXCEPTION = "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)";
    static /* synthetic */ Class class$net$sf$hibernate$util$ReflectHelper;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static Type reflectedPropertyType(Class theClass, String name) throws MappingException {
        return TypeFactory.heuristicType(BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name).getReturnType().getName());
    }

    public static Class reflectedPropertyClass(Class theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name).getReturnType();
    }

    public static Getter getter(Class theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name);
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static BulkBean getBulkBean(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        try {
            BulkBean optimizer = BulkBean.create((Class)clazz, (String[])getterNames, (String[])setterNames, (Class[])types);
            if (!clazz.isInterface()) {
                Object instance = FastClass.create((Class)clazz).newInstance();
                optimizer.setPropertyValues(instance, optimizer.getPropertyValues(instance));
            }
            return optimizer;
        }
        catch (Throwable t) {
            int index;
            String message = "reflection optimizer disabled for: " + clazz.getName() + ", " + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkBeanException && (index = ((BulkBeanException)t).getIndex()) >= 0) {
                message = message + " (property " + setterNames[index] + ")";
            }
            log.info((Object)message);
            return null;
        }
    }

    public static Constructor getConstructor(Class clazz, Type[] types) throws PropertyNotFoundException {
        Constructor<?>[] candidates = clazz.getConstructors();
        for (int i = 0; i < candidates.length; ++i) {
            Class<?>[] params = candidates[i].getParameterTypes();
            if (params.length != types.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                boolean ok;
                boolean bl = ok = params[j] == types[j].getReturnedClass() || types[j] instanceof PrimitiveType && params[j] == ((PrimitiveType)types[j]).getPrimitiveClass();
                if (ok) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return candidates[i];
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static String getPropertyName(Throwable t, BulkBean optimizer) {
        if (t instanceof BulkBeanException) {
            return optimizer.getSetters()[((BulkBeanException)t).getIndex()];
        }
        return "?";
    }

    private ReflectHelper() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method eq;
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$util$ReflectHelper == null ? (class$net$sf$hibernate$util$ReflectHelper = ReflectHelper.class$("net.sf.hibernate.util.ReflectHelper")) : class$net$sf$hibernate$util$ReflectHelper));
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        NO_CLASSES = new Class[0];
        OBJECT = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object};
        try {
            eq = (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", OBJECT);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals()", e);
        }
        OBJECT_EQUALS = eq;
    }
}

