/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CheckStyleTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private Path mClasspath;
    private String mFileName;
    private boolean mFailOnViolation = true;
    private String mFailureProperty = null;
    private final List mFileSets = new ArrayList();
    private final List mFormatters = new ArrayList();
    private final List mOverrideProps = new ArrayList();
    private File mPropertiesFile;

    public void setFailureProperty(String aPropertyName) {
        this.mFailureProperty = aPropertyName;
    }

    public void setFailOnViolation(boolean aFail) {
        this.mFailOnViolation = aFail;
    }

    public void addFileset(FileSet aFS) {
        this.mFileSets.add(aFS);
    }

    public void addFormatter(Formatter aFormatter) {
        this.mFormatters.add(aFormatter);
    }

    public void addProperty(Property aProperty) {
        this.mOverrideProps.add(aProperty);
    }

    public void setClasspath(Path aClasspath) {
        this.mClasspath = aClasspath;
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(this.getProject());
        }
        return this.mClasspath.createPath();
    }

    public void setFile(File aFile) {
        this.mFileName = aFile.getAbsolutePath();
    }

    public void setProperties(File aProps) {
        this.mPropertiesFile = aProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.mFileName == null && this.mFileSets.size() == 0) {
            throw new BuildException("Must specify atleast one of 'file' or nested 'fileset'.", this.getLocation());
        }
        Configuration config = this.createConfiguration();
        Checker c = null;
        try {
            try {
                c = new Checker(config);
                AuditListener[] listeners = this.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    c.addListener(listeners[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BuildException("Unable to create a Checker", (Throwable)e);
            }
            String[] files = this.scanFileSets();
            int numErrs = c.process(files);
            if (numErrs > 0 && this.mFailureProperty != null) {
                this.getProject().setProperty(this.mFailureProperty, "true");
            }
            if (numErrs > 0 && this.mFailOnViolation) {
                throw new BuildException("Got " + numErrs + " errors.", this.getLocation());
            }
            Object var6_6 = null;
            if (c != null) {
                c.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (c != null) {
                c.destroy();
            }
            throw throwable;
        }
    }

    private Configuration createConfiguration() {
        Configuration retVal;
        Properties props = new Properties();
        if (this.mPropertiesFile != null) {
            try {
                props.load(new FileInputStream(this.mPropertiesFile));
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Could not find Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
            }
            catch (IOException e) {
                throw new BuildException("Error loading Properties file '" + this.mPropertiesFile + "'", (Throwable)e, this.getLocation());
            }
        }
        Iterator it = this.mOverrideProps.iterator();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            props.setProperty(p.getKey(), p.getValue());
        }
        try {
            retVal = new Configuration(props, System.out);
        }
        catch (RESyntaxException e) {
            throw new BuildException("An regular expression error exists.", (Throwable)e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("An error loading the file '" + e.getMessage() + "'", (Throwable)e, this.getLocation());
        }
        if (this.mClasspath != null) {
            retVal.setClassLoader((ClassLoader)new AntClassLoader(this.getProject(), this.mClasspath));
        }
        return retVal;
    }

    protected AuditListener[] getListeners() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        int listenerCount = Math.max(1, this.mFormatters.size());
        AuditListener[] listeners = new AuditListener[listenerCount];
        if (this.mFormatters.size() == 0) {
            LogOutputStream debug = new LogOutputStream((Task)this, 4);
            LogOutputStream err = new LogOutputStream((Task)this, 0);
            listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
            return listeners;
        }
        int i = 0;
        while (i < listeners.length) {
            Formatter f = (Formatter)this.mFormatters.get(i);
            listeners[i] = f.createListener(this);
            ++i;
        }
        return listeners;
    }

    protected String[] scanFileSets() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.mFileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(this.mFileName);
        }
        int i = 0;
        while (i < this.mFileSets.size()) {
            FileSet fs = (FileSet)this.mFileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] names = ds.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + ds.getBasedir(), 3);
            int j = 0;
            while (j < names.length) {
                String pathname = ds.getBasedir() + File.separator + names[j];
                list.add(pathname);
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    static {
        E_XML = E_XML;
        E_PLAIN = E_PLAIN;
    }

    public static class Property {
        private String mKey;
        private String mValue;

        public String getKey() {
            return this.mKey;
        }

        public void setKey(String aKey) {
            this.mKey = aKey;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String aValue) {
            this.mValue = aValue;
        }

        public void setFile(File aValue) {
            this.setValue(aValue.getAbsolutePath());
        }
    }

    public static class Formatter {
        private FormatterType mFormatterType = null;
        private File mToFile = null;

        public void setType(FormatterType aType) {
            String val = aType.getValue();
            if (!CheckStyleTask.E_XML.equals(val) && !CheckStyleTask.E_PLAIN.equals(val)) {
                throw new BuildException("Invalid formatter type: " + val);
            }
            this.mFormatterType = aType;
        }

        public void setTofile(File aTo) {
            this.mToFile = aTo;
        }

        public AuditListener createListener(Task aTask) throws IOException {
            if (CheckStyleTask.E_XML.equals(this.mFormatterType.getValue())) {
                return this.createXMLLogger(aTask);
            }
            return this.createDefaultLogger(aTask);
        }

        private AuditListener createDefaultLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new DefaultLogger((OutputStream)new LogOutputStream(aTask, 4), true, (OutputStream)new LogOutputStream(aTask, 0), true);
            }
            return new DefaultLogger(new FileOutputStream(this.mToFile), true);
        }

        private AuditListener createXMLLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new XMLLogger((OutputStream)new LogOutputStream(aTask, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.mToFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

