/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.BlockOption;
import com.puppycrawl.tools.checkstyle.Defn;
import com.puppycrawl.tools.checkstyle.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.PadOption;
import com.puppycrawl.tools.checkstyle.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.Scope;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.WrapOpOption;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Configuration
implements Serializable {
    private static final String ILLEGAL_IMPORTS = "sun";
    private static final String ILLEGAL_INSTANTIATIONS = "";
    private static final Map PATTERN_DEFAULTS;
    private Scope mJavadocScope = Scope.PRIVATE;
    private transient String[] mHeaderLines = new String[0];
    private transient ClassLoader mLoader = Thread.currentThread().getContextClassLoader();
    private TreeSet mHeaderIgnoreLineNo = new TreeSet();
    private RightCurlyOption mRCurly = RightCurlyOption.SAME;
    private PadOption mParenPadOption = PadOption.NOSPACE;
    private WrapOpOption mWrapOpOption = WrapOpOption.NL;
    private final Set mBooleanProps = new HashSet();
    private final Map mStringSetProps = new HashMap();
    private final Map mIntProps;
    private final Map mPatterns;
    private transient Map mRegexps;
    private final Map mBlockProps;
    private final Map mLCurliesProps;
    private final Map mStringProps;

    public Configuration(Properties aProps, PrintStream aLog) throws RESyntaxException, FileNotFoundException, IOException {
        this.setStringSetProperty("checkstyle.illegal.imports", ILLEGAL_IMPORTS);
        this.setStringSetProperty("checkstyle.illegal.instantiations", ILLEGAL_INSTANTIATIONS);
        this.mIntProps = new HashMap();
        this.mIntProps.put("checkstyle.maxlinelen", new Integer(80));
        this.mIntProps.put("checkstyle.maxmethodlen", new Integer(150));
        this.mIntProps.put("checkstyle.maxconstructorlen", new Integer(150));
        this.mIntProps.put("checkstyle.maxfilelen", new Integer(2000));
        this.mIntProps.put("checkstyle.maxparameters", new Integer(7));
        this.mIntProps.put("checkstyle.tab.width", new Integer(8));
        this.mPatterns = new HashMap();
        this.mRegexps = new HashMap();
        this.mBlockProps = new HashMap();
        this.mBlockProps.put("checkstyle.block.try", BlockOption.STMT);
        this.mBlockProps.put("checkstyle.block.catch", BlockOption.TEXT);
        this.mBlockProps.put("checkstyle.block.finally", BlockOption.STMT);
        this.mLCurliesProps = new HashMap();
        this.mLCurliesProps.put("checkstyle.lcurly.method", LeftCurlyOption.EOL);
        this.mLCurliesProps.put("checkstyle.lcurly.type", LeftCurlyOption.EOL);
        this.mLCurliesProps.put("checkstyle.lcurly.other", LeftCurlyOption.EOL);
        this.mStringProps = new HashMap();
        this.mStringProps.put("checkstyle.locale.language", Locale.getDefault().getLanguage());
        this.mStringProps.put("checkstyle.locale.country", Locale.getDefault().getCountry());
        this.setHeaderIgnoreLines(aProps.getProperty("checkstyle.header.ignoreline"));
        this.setRCurly(Configuration.getRightCurlyOptionProperty(aProps, "checkstyle.rcurly", RightCurlyOption.SAME, aLog));
        this.setJavadocScope(Scope.getInstance(aProps.getProperty("checkstyle.javadoc.scope", Scope.PRIVATE.getName())));
        this.setParenPadOption(Configuration.getPadOptionProperty(aProps, "checkstyle.paren.pad", PadOption.NOSPACE, aLog));
        this.setWrapOpOption(Configuration.getWrapOpOptionProperty(aProps, "checkstyle.wrap.operator", WrapOpOption.NL, aLog));
        int i = 0;
        while (i < Defn.ALL_BOOLEAN_PROPS.length) {
            this.setBooleanProperty(aProps, Defn.ALL_BOOLEAN_PROPS[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < Defn.ALL_PATTERN_PROPS.length) {
            this.setPatternProperty(aProps, Defn.ALL_PATTERN_PROPS[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < Defn.ALL_INT_PROPS.length) {
            this.setIntProperty(aProps, aLog, Defn.ALL_INT_PROPS[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < Defn.ALL_BLOCK_PROPS.length) {
            this.setBlockOptionProperty(aProps, Defn.ALL_BLOCK_PROPS[i4], aLog);
            ++i4;
        }
        int i5 = 0;
        while (i5 < Defn.ALL_STRING_PROPS.length) {
            this.setStringProperty(aProps, Defn.ALL_STRING_PROPS[i5]);
            ++i5;
        }
        int i6 = 0;
        while (i6 < Defn.ALL_LCURLY_PROPS.length) {
            this.setLeftCurlyOptionProperty(aProps, Defn.ALL_LCURLY_PROPS[i6], aLog);
            ++i6;
        }
        int i7 = 0;
        while (i7 < Defn.ALL_STRING_SET_PROPS.length) {
            this.setStringSetProperty(aProps, Defn.ALL_STRING_SET_PROPS[i7]);
            ++i7;
        }
    }

    public Configuration() {
        this.setStringSetProperty("checkstyle.illegal.imports", ILLEGAL_IMPORTS);
        this.setStringSetProperty("checkstyle.illegal.instantiations", ILLEGAL_INSTANTIATIONS);
        this.mIntProps = new HashMap();
        this.mIntProps.put("checkstyle.maxlinelen", new Integer(80));
        this.mIntProps.put("checkstyle.maxmethodlen", new Integer(150));
        this.mIntProps.put("checkstyle.maxconstructorlen", new Integer(150));
        this.mIntProps.put("checkstyle.maxfilelen", new Integer(2000));
        this.mIntProps.put("checkstyle.maxparameters", new Integer(7));
        this.mIntProps.put("checkstyle.tab.width", new Integer(8));
        this.mPatterns = new HashMap();
        this.mRegexps = new HashMap();
        this.mBlockProps = new HashMap();
        this.mBlockProps.put("checkstyle.block.try", BlockOption.STMT);
        this.mBlockProps.put("checkstyle.block.catch", BlockOption.TEXT);
        this.mBlockProps.put("checkstyle.block.finally", BlockOption.STMT);
        this.mLCurliesProps = new HashMap();
        this.mLCurliesProps.put("checkstyle.lcurly.method", LeftCurlyOption.EOL);
        this.mLCurliesProps.put("checkstyle.lcurly.type", LeftCurlyOption.EOL);
        this.mLCurliesProps.put("checkstyle.lcurly.other", LeftCurlyOption.EOL);
        this.mStringProps = new HashMap();
        this.mStringProps.put("checkstyle.locale.language", Locale.getDefault().getLanguage());
        this.mStringProps.put("checkstyle.locale.country", Locale.getDefault().getCountry());
        try {
            int i = 0;
            while (i < Defn.ALL_PATTERN_PROPS.length) {
                this.setPatternProperty(Defn.ALL_PATTERN_PROPS[i], (String)PATTERN_DEFAULTS.get(Defn.ALL_PATTERN_PROPS[i]));
                ++i;
            }
        }
        catch (RESyntaxException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.mLoader = Thread.currentThread().getContextClassLoader();
        this.mRegexps = new HashMap();
        this.loadFiles();
        try {
            Iterator keys = this.mPatterns.keySet().iterator();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                this.mRegexps.put(k, new RE((String)this.mPatterns.get(k)));
            }
        }
        catch (RESyntaxException ex) {
            throw new InvalidObjectException("invalid regular expression syntax");
        }
    }

    void loadFiles() throws IOException {
        this.loadHeaderFile();
    }

    public void setClassLoader(ClassLoader aLoader) {
        this.mLoader = aLoader;
    }

    public Properties getProperties() {
        Properties retVal = new Properties();
        Utils.addSetString(retVal, "checkstyle.header.ignoreline", this.mHeaderIgnoreLineNo);
        Utils.addObjectString(retVal, "checkstyle.rcurly", this.mRCurly.toString());
        Utils.addObjectString(retVal, "checkstyle.javadoc.scope", this.mJavadocScope.getName());
        Utils.addObjectString(retVal, "checkstyle.paren.pad", this.mParenPadOption.toString());
        Utils.addObjectString(retVal, "checkstyle.wrap.operator", this.mWrapOpOption.toString());
        int i = 0;
        while (i < Defn.ALL_BOOLEAN_PROPS.length) {
            String key = Defn.ALL_BOOLEAN_PROPS[i];
            retVal.put(key, String.valueOf(this.getBooleanProperty(key)));
            ++i;
        }
        int i2 = 0;
        while (i2 < Defn.ALL_PATTERN_PROPS.length) {
            String key = Defn.ALL_PATTERN_PROPS[i2];
            Utils.addObjectString(retVal, key, this.getPatternProperty(key));
            ++i2;
        }
        int i3 = 0;
        while (i3 < Defn.ALL_INT_PROPS.length) {
            String key = Defn.ALL_INT_PROPS[i3];
            Utils.addObjectString(retVal, key, Integer.toString(this.getIntProperty(key)));
            ++i3;
        }
        int i4 = 0;
        while (i4 < Defn.ALL_BLOCK_PROPS.length) {
            String key = Defn.ALL_BLOCK_PROPS[i4];
            Utils.addObjectString(retVal, key, this.getBlockOptionProperty(key));
            ++i4;
        }
        int i5 = 0;
        while (i5 < Defn.ALL_STRING_PROPS.length) {
            String key = Defn.ALL_STRING_PROPS[i5];
            Utils.addObjectString(retVal, key, this.getStringProperty(key));
            ++i5;
        }
        int i6 = 0;
        while (i6 < Defn.ALL_LCURLY_PROPS.length) {
            String key = Defn.ALL_LCURLY_PROPS[i6];
            Utils.addObjectString(retVal, key, this.getLeftCurlyOptionProperty(key));
            ++i6;
        }
        int i7 = 0;
        while (i7 < Defn.ALL_STRING_SET_PROPS.length) {
            String key = Defn.ALL_STRING_SET_PROPS[i7];
            Utils.addSetString(retVal, key, this.getStringSetProperty(key));
            ++i7;
        }
        return retVal;
    }

    ClassLoader getClassLoader() {
        return this.mLoader;
    }

    String getLocaleLanguage() {
        return this.getStringProperty("checkstyle.locale.language");
    }

    String getLocaleCountry() {
        return this.getStringProperty("checkstyle.locale.country");
    }

    String getTodoPat() {
        return this.getPatternProperty("checkstyle.pattern.todo");
    }

    RE getTodoRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.todo");
    }

    String getParamPat() {
        return this.getPatternProperty("checkstyle.pattern.parameter");
    }

    RE getParamRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.parameter");
    }

    public String getPackagePat() {
        return this.getPatternProperty("checkstyle.pattern.package");
    }

    public RE getPackageRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.package");
    }

    String getStaticPat() {
        return this.getPatternProperty("checkstyle.pattern.static");
    }

    RE getStaticRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.static");
    }

    String getStaticFinalPat() {
        return this.getPatternProperty("checkstyle.pattern.const");
    }

    RE getStaticFinalRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.const");
    }

    String getMemberPat() {
        return this.getPatternProperty("checkstyle.pattern.member");
    }

    RE getMemberRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.member");
    }

    String getPublicMemberPat() {
        return this.getPatternProperty("checkstyle.pattern.publicmember");
    }

    RE getPublicMemberRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.publicmember");
    }

    String getTypePat() {
        return this.getPatternProperty("checkstyle.pattern.type");
    }

    RE getTypeRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.type");
    }

    String getLocalVarPat() {
        return this.getPatternProperty("checkstyle.pattern.localvar");
    }

    RE getLocalVarRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.localvar");
    }

    String getLocalFinalVarPat() {
        return this.getPatternProperty("checkstyle.pattern.localfinalvar");
    }

    RE getLocalFinalVarRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.localfinalvar");
    }

    String getMethodPat() {
        return this.getPatternProperty("checkstyle.pattern.method");
    }

    RE getMethodRegexp() {
        return this.getRegexpProperty("checkstyle.pattern.method");
    }

    int getMaxLineLength() {
        return this.getIntProperty("checkstyle.maxlinelen");
    }

    int getMaxMethodLength() {
        return this.getIntProperty("checkstyle.maxmethodlen");
    }

    int getMaxParameters() {
        return this.getIntProperty("checkstyle.maxparameters");
    }

    int getMaxConstructorLength() {
        return this.getIntProperty("checkstyle.maxconstructorlen");
    }

    int getMaxFileLength() {
        return this.getIntProperty("checkstyle.maxfilelen");
    }

    boolean isAllowTabs() {
        return this.getBooleanProperty("checkstyle.allow.tabs");
    }

    int getTabWidth() {
        return this.getIntProperty("checkstyle.tab.width");
    }

    boolean isAllowProtected() {
        return this.getBooleanProperty("checkstyle.allow.protected");
    }

    boolean isAllowPackage() {
        return this.getBooleanProperty("checkstyle.allow.package");
    }

    boolean isAllowNoAuthor() {
        return this.getBooleanProperty("checkstyle.allow.noauthor");
    }

    boolean isRequireVersion() {
        return this.getBooleanProperty("checkstyle.require.version");
    }

    Scope getJavadocScope() {
        return this.mJavadocScope;
    }

    boolean isRequirePackageHtml() {
        return this.getBooleanProperty("checkstyle.require.packagehtml");
    }

    boolean isIgnoreImports() {
        return this.getBooleanProperty("checkstyle.ignore.imports");
    }

    boolean isCheckUnusedThrows() {
        return this.getBooleanProperty("checkstyle.javadoc.checkUnusedThrows");
    }

    Set getIllegalImports() {
        return this.getStringSetProperty("checkstyle.illegal.imports");
    }

    Set getIllegalInstantiations() {
        return this.getStringSetProperty("checkstyle.illegal.instantiations");
    }

    String getIgnoreLineLengthPat() {
        return this.getPatternProperty("checkstyle.ignore.maxlinelen");
    }

    RE getIgnoreLineLengthRegexp() {
        return this.getRegexpProperty("checkstyle.ignore.maxlinelen");
    }

    boolean isIgnoreWhitespace() {
        return this.getBooleanProperty("checkstyle.ignore.whitespace");
    }

    boolean isIgnoreCastWhitespace() {
        return this.getBooleanProperty("checkstyle.ignore.whitespace.cast");
    }

    boolean isIgnoreBraces() {
        return this.getBooleanProperty("checkstyle.ignore.braces");
    }

    boolean isIgnoreLongEll() {
        return this.getBooleanProperty("checkstyle.ignore.longell");
    }

    boolean isIgnorePublicInInterface() {
        return this.getBooleanProperty("checkstyle.ignore.public.in.interface");
    }

    boolean isIgnoreImportLength() {
        return this.getBooleanProperty("checkstyle.ignore.importlength");
    }

    String[] getHeaderLines() {
        return this.mHeaderLines;
    }

    boolean getHeaderLinesRegexp() {
        return this.getBooleanProperty("checkstyle.header.regexp");
    }

    boolean isHeaderIgnoreLineNo(int aLineNo) {
        return this.mHeaderIgnoreLineNo.contains(new Integer(aLineNo));
    }

    String getCacheFile() {
        return this.getStringProperty("checkstyle.cache.file");
    }

    private void setStringSetProperty(String aName, String aFrom) {
        TreeSet<String> s = new TreeSet<String>();
        StringTokenizer tok = new StringTokenizer(aFrom, ",");
        while (tok.hasMoreTokens()) {
            s.add(tok.nextToken());
        }
        this.mStringSetProps.put(aName, s);
    }

    private void setJavadocScope(Scope aJavadocScope) {
        this.mJavadocScope = aJavadocScope;
    }

    private void setBooleanProperty(String aName, boolean aTo) {
        if (aTo) {
            this.mBooleanProps.add(aName);
        } else {
            this.mBooleanProps.remove(aName);
        }
    }

    private void setStringProperty(String aName, String aTo) {
        this.mStringProps.put(aName, aTo);
    }

    private void loadHeaderFile() throws FileNotFoundException, IOException {
        String l;
        String fname = this.getStringProperty("checkstyle.header.file");
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        LineNumberReader lnr = new LineNumberReader(new FileReader(fname));
        ArrayList<String> lines = new ArrayList<String>();
        while ((l = lnr.readLine()) != null) {
            lines.add(l);
        }
        this.mHeaderLines = lines.toArray(new String[0]);
    }

    private void setHeaderIgnoreLines(String aList) {
        this.mHeaderIgnoreLineNo.clear();
        if (aList == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(aList, ",");
        while (tokens.hasMoreTokens()) {
            String ignoreLine = tokens.nextToken();
            this.mHeaderIgnoreLineNo.add(new Integer(ignoreLine));
        }
    }

    LeftCurlyOption getLCurlyMethod() {
        return this.getLeftCurlyOptionProperty("checkstyle.lcurly.method");
    }

    LeftCurlyOption getLCurlyType() {
        return this.getLeftCurlyOptionProperty("checkstyle.lcurly.type");
    }

    LeftCurlyOption getLCurlyOther() {
        return this.getLeftCurlyOptionProperty("checkstyle.lcurly.other");
    }

    RightCurlyOption getRCurly() {
        return this.mRCurly;
    }

    private void setRCurly(RightCurlyOption aTo) {
        this.mRCurly = aTo;
    }

    BlockOption getTryBlock() {
        return this.getBlockOptionProperty("checkstyle.block.try");
    }

    BlockOption getCatchBlock() {
        return this.getBlockOptionProperty("checkstyle.block.catch");
    }

    BlockOption getFinallyBlock() {
        return this.getBlockOptionProperty("checkstyle.block.finally");
    }

    PadOption getParenPadOption() {
        return this.mParenPadOption;
    }

    private void setParenPadOption(PadOption aTo) {
        this.mParenPadOption = aTo;
    }

    WrapOpOption getWrapOpOption() {
        return this.mWrapOpOption;
    }

    private void setWrapOpOption(WrapOpOption aTo) {
        this.mWrapOpOption = aTo;
    }

    String getBasedir() {
        return this.getStringProperty("checkstyle.basedir");
    }

    private void setIntProperty(String aName, int aTo) {
        this.mIntProps.put(aName, new Integer(aTo));
    }

    private void setPatternProperty(String aName, String aPat) throws RESyntaxException {
        this.mRegexps.put(aName, new RE(aPat));
        this.mPatterns.put(aName, aPat);
    }

    private void setBlockOptionProperty(String aName, BlockOption aTo) {
        this.mBlockProps.put(aName, aTo);
    }

    private void setLeftCurlyOptionProperty(String aName, LeftCurlyOption aTo) {
        this.mLCurliesProps.put(aName, aTo);
    }

    private LeftCurlyOption getLeftCurlyOptionProperty(String aName) {
        return (LeftCurlyOption)this.mLCurliesProps.get(aName);
    }

    private BlockOption getBlockOptionProperty(String aName) {
        return (BlockOption)this.mBlockProps.get(aName);
    }

    private void setPatternProperty(Properties aProps, String aName) throws RESyntaxException {
        this.setPatternProperty(aName, aProps.getProperty(aName, (String)PATTERN_DEFAULTS.get(aName)));
    }

    private String getPatternProperty(String aName) {
        return (String)this.mPatterns.get(aName);
    }

    private RE getRegexpProperty(String aName) {
        return (RE)this.mRegexps.get(aName);
    }

    private int getIntProperty(String aName) {
        return (Integer)this.mIntProps.get(aName);
    }

    private String getStringProperty(String aName) {
        return (String)this.mStringProps.get(aName);
    }

    private void setIntProperty(Properties aProps, PrintStream aLog, String aName) {
        String strRep = aProps.getProperty(aName);
        if (strRep != null) {
            try {
                int val = Integer.parseInt(strRep);
                this.setIntProperty(aName, val);
            }
            catch (NumberFormatException nfe) {
                aLog.println("Unable to parse " + aName + " property with value " + strRep + ", defaulting to " + this.getIntProperty(aName) + ".");
            }
        }
    }

    private void setLeftCurlyOptionProperty(Properties aProps, String aName, PrintStream aLog) {
        String strRep = aProps.getProperty(aName);
        if (strRep != null) {
            LeftCurlyOption opt = LeftCurlyOption.decode(strRep);
            if (opt == null) {
                aLog.println("Unable to parse " + aName + " property with value " + strRep + ", leaving as " + this.getLeftCurlyOptionProperty(aName) + ".");
            } else {
                this.setLeftCurlyOptionProperty(aName, opt);
            }
        }
    }

    private static RightCurlyOption getRightCurlyOptionProperty(Properties aProps, String aName, RightCurlyOption aDefault, PrintStream aLog) {
        RightCurlyOption retVal = aDefault;
        String strRep = aProps.getProperty(aName);
        if (strRep != null && (retVal = RightCurlyOption.decode(strRep)) == null) {
            aLog.println("Unable to parse " + aName + " property with value " + strRep + ", defaulting to " + aDefault + ".");
        }
        return retVal;
    }

    private void setBlockOptionProperty(Properties aProps, String aName, PrintStream aLog) {
        String strRep = aProps.getProperty(aName);
        if (strRep != null) {
            BlockOption opt = BlockOption.decode(strRep);
            if (opt == null) {
                aLog.println("Unable to parse " + aName + " property with value " + strRep + ", leaving as " + this.getBlockOptionProperty(aName) + ".");
            } else {
                this.setBlockOptionProperty(aName, opt);
            }
        }
    }

    private static PadOption getPadOptionProperty(Properties aProps, String aName, PadOption aDefault, PrintStream aLog) {
        PadOption retVal = aDefault;
        String strRep = aProps.getProperty(aName);
        if (strRep != null && (retVal = PadOption.decode(strRep)) == null) {
            aLog.println("Unable to parse " + aName + " property with value " + strRep + ", defaulting to " + aDefault + ".");
        }
        return retVal;
    }

    private static WrapOpOption getWrapOpOptionProperty(Properties aProps, String aName, WrapOpOption aDefault, PrintStream aLog) {
        WrapOpOption retVal = aDefault;
        String strRep = aProps.getProperty(aName);
        if (strRep != null && (retVal = WrapOpOption.decode(strRep)) == null) {
            aLog.println("Unable to parse " + aName + " property with value " + strRep + ", defaulting to " + aDefault + ".");
        }
        return retVal;
    }

    private boolean getBooleanProperty(String aName) {
        return this.mBooleanProps.contains(aName);
    }

    private void setBooleanProperty(Properties aProps, String aName) {
        String strRep = aProps.getProperty(aName);
        if (strRep != null && ((strRep = strRep.toLowerCase().trim()).equals("true") || strRep.equals("yes") || strRep.equals("on"))) {
            this.setBooleanProperty(aName, true);
        }
    }

    private Set getStringSetProperty(String aName) {
        return (Set)this.mStringSetProps.get(aName);
    }

    private void setStringSetProperty(Properties aProps, String aName) {
        String strRep = aProps.getProperty(aName);
        if (strRep != null) {
            this.setStringSetProperty(aName, strRep);
        }
    }

    private void setStringProperty(Properties aProps, String aName) {
        String str = aProps.getProperty(aName);
        if (str != null) {
            this.setStringProperty(aName, aProps.getProperty(aName));
        }
    }

    static {
        ILLEGAL_IMPORTS = ILLEGAL_IMPORTS;
        ILLEGAL_INSTANTIATIONS = ILLEGAL_INSTANTIATIONS;
        PATTERN_DEFAULTS = new HashMap();
        PATTERN_DEFAULTS.put("checkstyle.pattern.todo", "TODO:");
        PATTERN_DEFAULTS.put("checkstyle.pattern.parameter", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.static", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.const", "^[A-Z](_?[A-Z0-9]+)*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.member", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.publicmember", "^f[A-Z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.type", "^[A-Z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.localvar", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.localfinalvar", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.method", "^[a-z][a-zA-Z0-9]*$");
        PATTERN_DEFAULTS.put("checkstyle.ignore.maxlinelen", "^$");
        PATTERN_DEFAULTS.put("checkstyle.pattern.package", "^[a-z]+(\\.[a-zA-Z_][a-zA-Z_0-9]*)*$");
    }
}

