/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditEvent;
import com.puppycrawl.tools.checkstyle.AuditListener;
import java.io.OutputStream;
import java.io.PrintWriter;

public class DefaultLogger
implements AuditListener {
    private final PrintWriter mInfoWriter;
    private final boolean mCloseInfo;
    private final PrintWriter mErrorWriter;
    private final boolean mCloseError;

    public DefaultLogger(OutputStream aOS, boolean aCloseStreamsAfterUse) {
        this(aOS, aCloseStreamsAfterUse, aOS, false);
    }

    public DefaultLogger(OutputStream aInfoStream, boolean aCloseInfoAfterUse, OutputStream aErrorStream, boolean aCloseErrorAfterUse) {
        this.mCloseInfo = aCloseInfoAfterUse;
        this.mCloseError = aCloseErrorAfterUse;
        this.mInfoWriter = new PrintWriter(aInfoStream);
        this.mErrorWriter = aInfoStream == aErrorStream ? this.mInfoWriter : new PrintWriter(aErrorStream);
    }

    public void addError(AuditEvent aEvt) {
        if (aEvt.getColumn() > 0) {
            this.mErrorWriter.println(aEvt.getFileName() + ":" + aEvt.getLine() + ":" + aEvt.getColumn() + ": " + aEvt.getMessage());
        } else {
            this.mErrorWriter.println(aEvt.getFileName() + ":" + aEvt.getLine() + ": " + aEvt.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addException(AuditEvent aEvt, Throwable aThrowable) {
        PrintWriter printWriter = this.mErrorWriter;
        synchronized (printWriter) {
            this.mErrorWriter.println("Error auditing " + aEvt.getFileName());
            aThrowable.printStackTrace(this.mErrorWriter);
        }
    }

    public void auditStarted(AuditEvent aEvt) {
        this.mInfoWriter.println("Starting audit...");
    }

    public void fileFinished(AuditEvent aEvt) {
    }

    public void fileStarted(AuditEvent aEvt) {
    }

    public void auditFinished(AuditEvent aEvt) {
        this.mInfoWriter.println("Audit done.");
        this.closeStreams();
    }

    protected void closeStreams() {
        this.mInfoWriter.flush();
        if (this.mCloseInfo) {
            this.mInfoWriter.close();
        }
        this.mErrorWriter.flush();
        if (this.mCloseError) {
            this.mErrorWriter.close();
        }
    }
}

