/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

class LineText
implements Comparable {
    private String mText;
    private final int mLineNo;
    private final int mColNo;

    LineText(int aLineNo, String aText) {
        this(aLineNo, 0, aText);
    }

    LineText(int aLineNo, int aColNo, String aText) {
        this.mLineNo = aLineNo;
        this.mColNo = aColNo;
        this.mText = aText;
    }

    LineText(LineText aOther) {
        this(aOther.getLineNo(), aOther.getColumnNo(), aOther.getText());
    }

    String getText() {
        return this.mText;
    }

    int getLineNo() {
        return this.mLineNo;
    }

    public int getColumnNo() {
        return this.mColNo;
    }

    void appendText(String aText) {
        this.mText = this.mText + aText;
    }

    public String toString() {
        return "{Text = '" + this.getText() + "', Line = " + this.getLineNo() + ", Column = " + this.getColumnNo() + "}";
    }

    public int compareTo(Object aOther) {
        LineText lt = (LineText)aOther;
        if (this.getLineNo() == lt.getLineNo()) {
            if (this.getColumnNo() == lt.getColumnNo()) {
                return 0;
            }
            return this.getColumnNo() < lt.getColumnNo() ? -1 : 1;
        }
        return this.getLineNo() < lt.getLineNo() ? -1 : 1;
    }
}

