/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalizedMessage
implements Comparable {
    private static final String MESSAGE_BUNDLE = "com.puppycrawl.tools.checkstyle.messages";
    private static Locale sLocale;
    private final int mLineNo;
    private final int mColNo;
    private final String mKey;
    private final Object[] mArgs;

    LocalizedMessage(int aLineNo, int aColNo, String aKey, Object[] aArgs) {
        this.mLineNo = aLineNo;
        this.mColNo = aColNo;
        this.mKey = aKey;
        this.mArgs = aArgs;
    }

    LocalizedMessage(int aLineNo, String aKey, Object[] aArgs) {
        this(aLineNo, 0, aKey, aArgs);
    }

    public String getMessage() {
        ResourceBundle bundle = ResourceBundle.getBundle(MESSAGE_BUNDLE, sLocale);
        String pattern = bundle.getString(this.mKey);
        return MessageFormat.format(pattern, this.mArgs);
    }

    public int getLineNo() {
        return this.mLineNo;
    }

    public int getColumnNo() {
        return this.mColNo;
    }

    static void setLocale(Locale aLocale) {
        sLocale = aLocale;
    }

    public int compareTo(Object aOther) {
        LocalizedMessage lt = (LocalizedMessage)aOther;
        if (this.getLineNo() == lt.getLineNo()) {
            if (this.getColumnNo() == lt.getColumnNo()) {
                return 0;
            }
            return this.getColumnNo() < lt.getColumnNo() ? -1 : 1;
        }
        return this.getLineNo() < lt.getLineNo() ? -1 : 1;
    }

    static {
        MESSAGE_BUNDLE = MESSAGE_BUNDLE;
        sLocale = Locale.getDefault();
    }
}

