/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.Utils;
import java.util.ArrayList;
import java.util.Collections;

class LocalizedMessages {
    private final ArrayList mMessages = new ArrayList();
    private final int mTabWidth;
    private String[] mLines;

    LocalizedMessages(int aTabWidth) {
        this.mTabWidth = aTabWidth;
    }

    void setLines(String[] aLines) {
        this.mLines = aLines;
    }

    LocalizedMessage[] getMessages() {
        Collections.sort(this.mMessages);
        return this.mMessages.toArray(new LocalizedMessage[this.mMessages.size()]);
    }

    void reset() {
        this.mMessages.clear();
        this.mLines = null;
    }

    void add(LocalizedMessage aMsg) {
        this.mMessages.add(aMsg);
    }

    void add(int aLineNo, String aKey, Object[] aArgs) {
        this.add(new LocalizedMessage(aLineNo, 0, aKey, aArgs));
    }

    void add(int aLineNo, String aKey) {
        this.add(aLineNo, aKey, new Object[0]);
    }

    void add(int aLineNo, String aKey, Object aArg0) {
        this.add(aLineNo, aKey, new Object[]{aArg0});
    }

    void add(int aLineNo, String aKey, Object aArg0, Object aArg1) {
        this.add(aLineNo, aKey, new Object[]{aArg0, aArg1});
    }

    void add(int aLineNo, String aKey, Object aArg0, Object aArg1, Object aArg2) {
        this.add(aLineNo, aKey, new Object[]{aArg0, aArg1, aArg2});
    }

    void add(int aLineNo, int aColNo, String aKey, Object[] aArgs) {
        int col = 1 + Utils.lengthExpandedTabs(this.mLines[aLineNo - 1], aColNo, this.mTabWidth);
        this.mMessages.add(new LocalizedMessage(aLineNo, col, aKey, aArgs));
    }

    void add(int aLineNo, int aColNo, String aKey) {
        this.add(aLineNo, aColNo, aKey, new Object[0]);
    }

    void add(int aLineNo, int aColNo, String aKey, Object aArg0) {
        this.add(aLineNo, aColNo, aKey, new Object[]{aArg0});
    }

    void add(int aLineNo, int aColNo, String aKey, Object aArg0, Object aArg1) {
        this.add(aLineNo, aColNo, aKey, new Object[]{aArg0, aArg1});
    }

    void add(int aLineNo, int aColNo, String aKey, Object aArg0, Object aArg1, Object aArg2) {
        this.add(aLineNo, aColNo, aKey, new Object[]{aArg0, aArg1, aArg2});
    }
}

