/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.Token;
import com.puppycrawl.tools.checkstyle.BlockOption;
import com.puppycrawl.tools.checkstyle.ClassResolver;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.JavadocTag;
import com.puppycrawl.tools.checkstyle.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.LineText;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.MethodSignature;
import com.puppycrawl.tools.checkstyle.MyCommonAST;
import com.puppycrawl.tools.checkstyle.MyModifierSet;
import com.puppycrawl.tools.checkstyle.MyToken;
import com.puppycrawl.tools.checkstyle.MyVariable;
import com.puppycrawl.tools.checkstyle.PadOption;
import com.puppycrawl.tools.checkstyle.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.Scope;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.WrapOpOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

class Verifier {
    private static final String MATCH_JAVADOC_ARG_PAT = "@(throws|exception|param)\\s+(\\S+)\\s+\\S";
    private static final RE MATCH_JAVADOC_ARG;
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final RE MATCH_SINGLELINE_COMMENT;
    private static final String MATCH_JAVADOC_MULTILINE_START_PAT = "@(throws|exception|param)\\s+(\\S+)\\s*$";
    private static final RE MATCH_JAVADOC_MULTILINE_START;
    private static final String MATCH_JAVADOC_MULTILINE_CONT_PAT = "(\\*/|@|[^\\s\\*])";
    private static final RE MATCH_JAVADOC_MULTILINE_CONT;
    private static final String END_JAVADOC = "*/";
    private static final String NEXT_TAG = "@";
    private static final String MATCH_JAVADOC_NOARG_PAT = "@(return|see|author)\\s+\\S";
    private static final RE MATCH_JAVADOC_NOARG;
    private static final String MATCH_JAVADOC_AUTHOR_PAT = "@author\\s+\\S";
    private static final RE MATCH_JAVADOC_AUTHOR;
    private static final String MATCH_JAVADOC_VERSION_PAT = "@version\\s+\\S";
    private static final RE MATCH_JAVADOC_VERSION;
    private final Stack mInInterface = new Stack();
    private final Stack mInScope = new Stack();
    private final Stack mTypeNames = new Stack();
    private String mCurrentTypeName;
    private final Map mTypeFieldsMap = new HashMap();
    private int mMethodBlockLevel = 0;
    private final LocalizedMessages mMessages;
    private String[] mLines;
    private String mPkgName;
    private final Map mComments = new HashMap();
    private final Set mImports = new HashSet();
    private final Set mReferenced = new HashSet();
    private final Configuration mConfig;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    Verifier(Configuration aConfig) {
        this.mConfig = aConfig;
        this.mMessages = new LocalizedMessages(this.mConfig.getTabWidth());
    }

    LocalizedMessage[] getMessages() {
        this.checkImports();
        return this.mMessages.getMessages();
    }

    void reset() {
        this.mLines = null;
        this.mPkgName = null;
        this.mInInterface.clear();
        this.mInScope.clear();
        this.mMessages.reset();
        this.mComments.clear();
        this.mImports.clear();
        this.mReferenced.clear();
        this.mTypeNames.clear();
        this.mTypeFieldsMap.clear();
        this.mMethodBlockLevel = 0;
    }

    void setLines(String[] aLines) {
        this.mLines = aLines;
        this.mMessages.setLines(this.mLines);
        this.checkHeader();
        int i = 0;
        while (i < this.mLines.length) {
            int tabPosition;
            String line = this.mLines[i];
            int realLength = Utils.lengthExpandedTabs(line, line.length(), this.mConfig.getTabWidth());
            if (!(realLength <= this.mConfig.getMaxLineLength() || this.mConfig.getIgnoreLineLengthRegexp().match(line) || this.mConfig.isIgnoreImportLength() && line.trim().startsWith("import"))) {
                this.mMessages.add(i + 1, "maxLineLen", new Integer(this.mConfig.getMaxLineLength()));
            }
            if (!this.mConfig.isAllowTabs() && (tabPosition = this.mLines[i].indexOf(9)) != -1) {
                this.mMessages.add(i + 1, tabPosition, "containsTab");
            }
            ++i;
        }
        if (this.mLines.length > this.mConfig.getMaxFileLength()) {
            this.mMessages.add(1, "maxLen.file", new Integer(this.mLines.length), (Object)new Integer(this.mConfig.getMaxFileLength()));
        }
    }

    void verifyMethod(MethodSignature aSig) {
        Scope methodScope;
        if (!aSig.isConstructor() && !this.mConfig.getMethodRegexp().match(aSig.getName().getText())) {
            this.mMessages.add(aSig.getName().getLineNo(), aSig.getName().getColumnNo(), "name.invalidPattern", (Object)aSig.getName().getText(), (Object)this.mConfig.getMethodPat());
        }
        Iterator it = aSig.getParams().iterator();
        while (it.hasNext()) {
            this.checkParameter((LineText)it.next());
        }
        this.checkModOrder(aSig.getModSet());
        if (aSig.getParams().size() > this.mConfig.getMaxParameters()) {
            this.mMessages.add(aSig.getFirstLineNo(), aSig.getFirstColNo(), "maxParam", (Object)new Integer(this.mConfig.getMaxParameters()));
        }
        if (!this.mConfig.isIgnorePublicInInterface() && this.inInterfaceBlock() && aSig.getModSet().containsPublic()) {
            this.mMessages.add(aSig.getModSet().getFirstLineNo(), aSig.getModSet().getFirstColNo(), "redundantModifier", (Object)"public");
        }
        if (this.inInterfaceBlock() && aSig.getModSet().containsAbstract()) {
            this.mMessages.add(aSig.getModSet().getFirstLineNo(), aSig.getModSet().getFirstColNo(), "redundantModifier", (Object)"abstract");
        }
        Scope scope = methodScope = this.inInterfaceBlock() ? Scope.PUBLIC : aSig.getModSet().getVisibilityScope();
        if (!this.inCheckScope(methodScope)) {
            return;
        }
        String[] jd = this.getJavadocBefore(aSig.getFirstLineNo() - 1);
        if (jd == null) {
            this.mMessages.add(aSig.getFirstLineNo(), aSig.getFirstColNo(), "javadoc.missing");
        } else {
            List tags = this.getMethodTags(jd, aSig.getFirstLineNo() - 1);
            if (tags.size() != 1 || !((JavadocTag)tags.get(0)).isSeeTag()) {
                this.checkParamTags(tags, aSig.getParams());
                this.checkThrowsTags(tags, aSig.getThrows());
                if (aSig.isFunction()) {
                    this.checkReturnTag(tags, aSig.getFirstLineNo());
                }
                Iterator it2 = tags.iterator();
                while (it2.hasNext()) {
                    JavadocTag jt = (JavadocTag)it2.next();
                    if (jt.isSeeTag()) continue;
                    this.mMessages.add(jt.getLineNo(), "javadoc.unusedTagGeneral");
                }
            }
        }
    }

    void verifyType(MyModifierSet aMods, MyCommonAST aType) {
        Scope typeScope;
        if (!this.mConfig.getTypeRegexp().match(aType.getText())) {
            this.mMessages.add(aType.getLineNo(), aType.getColumnNo(), "name.invalidPattern", (Object)aType.getText(), (Object)this.mConfig.getTypePat());
        }
        this.checkModOrder(aMods);
        Scope scope = typeScope = this.inInterfaceBlock() ? Scope.PUBLIC : aMods.getVisibilityScope();
        if (!this.inCheckScope(typeScope)) {
            return;
        }
        int lineNo = aMods.size() > 0 ? aMods.getFirstLineNo() : aType.getLineNo();
        Object[] jd = this.getJavadocBefore(lineNo - 1);
        if (jd == null) {
            this.mMessages.add(lineNo, "javadoc.missing");
        } else if (this.mInScope.size() == 0) {
            if (!this.mConfig.isAllowNoAuthor() && MATCH_JAVADOC_AUTHOR.grep(jd).length == 0) {
                this.mMessages.add(lineNo, "type.missingTag", (Object)"@author");
            }
            if (this.mConfig.isRequireVersion() && MATCH_JAVADOC_VERSION.grep(jd).length == 0) {
                this.mMessages.add(lineNo, "type.missingTag", (Object)"@version");
            }
        }
    }

    void verifyVariable(MyVariable aVar) {
        if (this.inMethodBlock()) {
            if (aVar.getModifierSet().containsFinal()) {
                this.checkVariable(aVar, this.mConfig.getLocalFinalVarRegexp(), this.mConfig.getLocalFinalVarPat());
            } else {
                this.checkVariable(aVar, this.mConfig.getLocalVarRegexp(), this.mConfig.getLocalVarPat());
            }
            return;
        }
        MyModifierSet mods = aVar.getModifierSet();
        Scope declaredScope = mods.getVisibilityScope();
        Scope variableScope = this.inInterfaceBlock() ? Scope.PUBLIC : declaredScope;
        this.checkModOrder(mods);
        if (this.inCheckScope(variableScope) && this.getJavadocBefore(aVar.getStartLineNo() - 1) == null) {
            this.mMessages.add(aVar.getLineNo(), aVar.getColumnNo() - 1, "javadoc.missing");
        }
        if (this.inInterfaceBlock()) {
            this.checkVariable(aVar, this.mConfig.getStaticFinalRegexp(), this.mConfig.getStaticFinalPat());
        } else {
            HashMap<String, MyVariable> typeVars = (HashMap<String, MyVariable>)this.mTypeFieldsMap.get(this.mCurrentTypeName);
            if (typeVars == null) {
                typeVars = new HashMap<String, MyVariable>();
                this.mTypeFieldsMap.put(this.mCurrentTypeName, typeVars);
            }
            typeVars.put(aVar.getText(), aVar);
            boolean isPckg = Scope.PACKAGE.equals(variableScope);
            boolean isProt = Scope.PROTECTED.equals(variableScope);
            if (mods.containsStatic()) {
                if (mods.containsFinal()) {
                    if (!"serialVersionUID".equals(aVar.getText())) {
                        this.checkVariable(aVar, this.mConfig.getStaticFinalRegexp(), this.mConfig.getStaticFinalPat());
                    }
                } else if (Scope.PRIVATE.equals(variableScope) || this.mConfig.isAllowPackage() && isPckg || this.mConfig.isAllowProtected() && isProt) {
                    this.checkVariable(aVar, this.mConfig.getStaticRegexp(), this.mConfig.getStaticPat());
                } else {
                    this.mMessages.add(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable.notPrivate", (Object)aVar.getText());
                }
            } else if (Scope.PRIVATE.equals(variableScope) || this.mConfig.isAllowPackage() && isPckg || this.mConfig.isAllowProtected() && isProt) {
                this.checkVariable(aVar, this.mConfig.getMemberRegexp(), this.mConfig.getMemberPat());
            } else if (!mods.containsPublic() || !this.mConfig.getPublicMemberRegexp().match(aVar.getText())) {
                this.mMessages.add(aVar.getLineNo(), aVar.getColumnNo() - 1, "variable.notPrivate", (Object)aVar.getText());
            }
        }
    }

    void reportNeedBraces(Token aStmt) {
        if (!this.mConfig.isIgnoreBraces()) {
            this.mMessages.add(aStmt.getLine(), "needBraces", (Object)aStmt.getText());
        }
    }

    void verifyWSAroundEnd(int aLineNo, int aColNo, String aText) {
        this.verifyWSAroundBegin(aLineNo, aColNo - aText.length(), aText);
    }

    void verifyWSAroundBegin(int aLineNo, int aColNo, String aText) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        int before = aColNo - 2;
        int after = aColNo + aText.length() - 1;
        if (before >= 0 && !Character.isWhitespace(line.charAt(before))) {
            this.mMessages.add(aLineNo, before + 1, "ws.notPreceeded", (Object)aText);
        }
        if (after < line.length() && !Character.isWhitespace(line.charAt(after))) {
            this.mMessages.add(aLineNo, after, "ws.notFollowed", (Object)aText);
        }
    }

    void verifyNoWSAfter(MyCommonAST aAST) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int after = aAST.getColumnNo() + aAST.getText().length();
        if (after >= line.length() || Character.isWhitespace(line.charAt(after))) {
            this.mMessages.add(aAST.getLineNo(), after, "ws.followed", (Object)aAST.getText());
        }
    }

    void verifyNoWSBefore(MyCommonAST aAST) {
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before < 0 || Character.isWhitespace(line.charAt(before))) {
            this.mMessages.add(aAST.getLineNo(), before, "ws.preceeded", (Object)aAST.getText());
        }
    }

    void verifyDot(MyCommonAST aAST) {
        int after;
        if (this.mConfig.isIgnoreWhitespace()) {
            return;
        }
        String line = this.mLines[aAST.getLineNo() - 1];
        int before = aAST.getColumnNo() - 1;
        if (before >= 0 && Character.isWhitespace(line.charAt(before))) {
            int i = 0;
            while (i < before) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    this.mMessages.add(aAST.getLineNo(), aAST.getColumnNo() - 1, "ws.preceeded", (Object)".");
                    break;
                }
                ++i;
            }
        }
        if ((after = aAST.getColumnNo() + 1) < line.length() && Character.isWhitespace(line.charAt(after))) {
            int i = after + 1;
            while (i < line.length()) {
                if (!Character.isWhitespace(line.charAt(i))) {
                    this.mMessages.add(aAST.getLineNo(), after, "ws.followed", (Object)".");
                    break;
                }
                ++i;
            }
        }
    }

    void verifyWSAfter(int aLineNo, int aColNo, MyToken aConstruct) {
        this.verifyWSAfter(aLineNo, aColNo, aConstruct, "");
    }

    void verifyWSAfter(int aLineNo, int aColNo, MyToken aConstruct, String aAllow) {
        this.checkWSAfter(aLineNo, aColNo, aConstruct, aAllow);
    }

    void verifyMethodLength(int aLineNo, int aLength) {
        if (aLength > this.mConfig.getMaxMethodLength()) {
            this.mMessages.add(aLineNo, "maxLen.method", new Integer(aLength), (Object)new Integer(this.mConfig.getMaxMethodLength()));
        }
    }

    void verifyLCurlyMethod(int aMethodLine, MyCommonAST aBrace) {
        this.checkLCurly(aMethodLine, aBrace, this.mConfig.getLCurlyMethod());
    }

    void verifyLCurlyType(int aTypeLine, MyCommonAST aBrace) {
        this.checkLCurly(aTypeLine, aBrace, this.mConfig.getLCurlyType());
    }

    void verifyLCurlyOther(int aOtherLine, MyCommonAST aBrace) {
        this.checkLCurly(aOtherLine, aBrace, this.mConfig.getLCurlyOther());
    }

    void verifyRCurly(MyCommonAST aBrace, int aStartLine) {
        this.verifyWSAroundBegin(aBrace.getLineNo(), aBrace.getColumnNo() + 1, aBrace.getText());
        if (this.mConfig.getRCurly() == RightCurlyOption.SAME && aBrace.getLineNo() != aStartLine) {
            this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.same", (Object)"}");
        } else if (this.mConfig.getRCurly() == RightCurlyOption.ALONE && aBrace.getLineNo() == aStartLine) {
            this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.alone", (Object)"}");
        }
    }

    void verifyLParen(int aLineNo, int aColNo) {
        if (this.mConfig.isIgnoreWhitespace() || PadOption.IGNORE == this.mConfig.getParenPadOption()) {
            return;
        }
        int after = aColNo - 1;
        String line = this.mLines[aLineNo - 1];
        if (after < line.length()) {
            if (PadOption.NOSPACE == this.mConfig.getParenPadOption() && Character.isWhitespace(line.charAt(after))) {
                this.mMessages.add(aLineNo, after, "ws.followed", (Object)"(");
            } else if (PadOption.SPACE == this.mConfig.getParenPadOption() && !Character.isWhitespace(line.charAt(after)) && line.charAt(after) != ')') {
                this.mMessages.add(aLineNo, after, "ws.notFollowed", (Object)"(");
            }
        }
    }

    void verifyRParen(int aLineNo, int aColNo) {
        if (this.mConfig.isIgnoreWhitespace() || PadOption.IGNORE == this.mConfig.getParenPadOption()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        int before = aColNo - 3;
        if (before >= 0) {
            if (PadOption.NOSPACE == this.mConfig.getParenPadOption() && Character.isWhitespace(line.charAt(before)) && !Utils.whitespaceBefore(before, line)) {
                this.mMessages.add(aLineNo, before, "ws.preceeded", (Object)")");
            } else if (PadOption.SPACE == this.mConfig.getParenPadOption() && !Character.isWhitespace(line.charAt(before)) && line.charAt(before) != '(') {
                this.mMessages.add(aLineNo, before, "ws.notPreceeded", (Object)")");
            }
        }
    }

    void verifyConstructorLength(int aLineNo, int aLength) {
        if (aLength > this.mConfig.getMaxConstructorLength()) {
            this.mMessages.add(aLineNo, "maxLen.constructor", new Integer(aLength), (Object)new Integer(this.mConfig.getMaxConstructorLength()));
        }
    }

    void reportCPPComment(int aStartLineNo, int aStartColNo) {
        String cmt = this.mLines[aStartLineNo - 1].substring(aStartColNo);
        if (this.mConfig.getTodoRegexp().match(cmt)) {
            this.mMessages.add(aStartLineNo, "todo.match", (Object)this.mConfig.getTodoPat());
        }
    }

    void reportCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] cc = this.extractCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
        if (this.mLines[aStartLineNo - 1].indexOf("/**", aStartColNo) != -1) {
            this.mComments.put(new Integer(aEndLineNo - 1), cc);
        }
        int i = 0;
        while (i < cc.length) {
            if (this.mConfig.getTodoRegexp().match(cc[i])) {
                this.mMessages.add(aStartLineNo + i, "todo.match", (Object)this.mConfig.getTodoPat());
            }
            ++i;
        }
    }

    void reportReference(String aType) {
        this.mReferenced.add(aType);
        int lastDot = aType.lastIndexOf(46);
        while (lastDot != -1) {
            this.mReferenced.add(aType.substring(0, lastDot));
            lastDot = aType.lastIndexOf(46, lastDot - 1);
        }
    }

    void reportPackageName(LineText aName) {
        this.mPkgName = aName.getText();
        this.checkPackageName(aName);
    }

    void reportImport(int aLineNo, String aType) {
        if (!this.mConfig.isIgnoreImports()) {
            Iterator it = this.mImports.iterator();
            while (it.hasNext()) {
                LineText lt = (LineText)it.next();
                if (!aType.equals(lt.getText())) continue;
                this.mMessages.add(aLineNo, "import.duplicate", new Integer(lt.getLineNo()));
            }
        }
        this.mImports.add(new LineText(aLineNo, aType));
    }

    void reportStarImport(int aLineNo, String aPkg) {
        if (!this.mConfig.isIgnoreImports()) {
            this.mMessages.add(aLineNo, "import.avoidStar");
        }
        this.mImports.add(new LineText(aLineNo, aPkg));
    }

    void reportStartTypeBlock(Scope aScope, boolean aIsInterface, MyCommonAST aType) {
        this.mInScope.push(aScope);
        this.mInInterface.push(aIsInterface ? Boolean.TRUE : Boolean.FALSE);
        if (aType != null) {
            this.mTypeNames.push(aType.getText());
            this.calculateTypeName();
        }
    }

    void reportEndTypeBlock(boolean aNamed) {
        this.mInScope.pop();
        this.mInInterface.pop();
        if (aNamed) {
            this.mTypeNames.pop();
            this.calculateTypeName();
        }
    }

    void reportStartMethodBlock() {
        ++this.mMethodBlockLevel;
    }

    void reportEndMethodBlock() {
        --this.mMethodBlockLevel;
    }

    void reportTryBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("try", this.mConfig.getTryBlock(), aBraces, aNoStmt);
    }

    void reportCatchBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("catch", this.mConfig.getCatchBlock(), aBraces, aNoStmt);
    }

    void reportFinallyBlock(MyCommonAST[] aBraces, boolean aNoStmt) {
        this.checkBlock("finally", this.mConfig.getFinallyBlock(), aBraces, aNoStmt);
    }

    void reportInstantiation(MyCommonAST aNewAST, LineText aTypeName) {
        String typeName = aTypeName.getText();
        int lineNo = aNewAST.getLineNo();
        int colNo = aNewAST.getColumnNo();
        String fqClassName = this.getIllegalInstantiation(typeName);
        if (fqClassName != null) {
            this.mMessages.add(lineNo, colNo, "instantiation.avoid", (Object)fqClassName);
        }
    }

    void verifyOpEnd(int aLineNo, int aColNo, String aText) {
        this.verifyOpBegin(aLineNo, aColNo - aText.length(), aText);
    }

    void verifyOpBegin(int aLineNo, int aColNo, String aText) {
        this.verifyWSAroundBegin(aLineNo, aColNo, aText);
        WrapOpOption wOp = this.mConfig.getWrapOpOption();
        if (wOp != WrapOpOption.IGNORE) {
            if (wOp == WrapOpOption.NL && !aText.equals(this.mLines[aLineNo - 1].trim()) && this.mLines[aLineNo - 1].substring(aColNo + aText.length() - 1).trim().length() == 0) {
                this.mMessages.add(aLineNo, aColNo - 1, "line.new", (Object)aText);
            } else if (wOp == WrapOpOption.EOL && Utils.whitespaceBefore(aColNo - 1, this.mLines[aLineNo - 1])) {
                this.mMessages.add(aLineNo, aColNo - 1, "line.previous", (Object)aText);
            }
        }
    }

    void verifyLongEll(int aLineNo, int aColNo) {
        if (!this.mConfig.isIgnoreLongEll() && this.mLines[aLineNo - 1].charAt(aColNo) == 'l') {
            this.mMessages.add(aLineNo, aColNo, "upperEll");
        }
    }

    private boolean inCheckScope(Scope aScope) {
        Scope configScope = this.mConfig.getJavadocScope();
        boolean retVal = aScope.isIn(configScope);
        Iterator scopeIterator = this.mInScope.iterator();
        while (retVal && scopeIterator.hasNext()) {
            Scope stackScope = (Scope)scopeIterator.next();
            retVal = stackScope.isIn(configScope);
        }
        return retVal;
    }

    private static RE createRE(String aPattern) {
        RE retVal = null;
        try {
            retVal = Utils.getRE(aPattern);
        }
        catch (RESyntaxException e) {
            System.out.println("Failed to initialise regexp expression " + aPattern);
            e.printStackTrace(System.out);
            System.exit(1);
        }
        return retVal;
    }

    private void checkVariable(MyVariable aVar, RE aRegexp, String aPattern) {
        if (!aRegexp.match(aVar.getText())) {
            this.mMessages.add(aVar.getLineNo(), aVar.getColumnNo() - 1, "name.invalidPattern", (Object)aVar.getText(), (Object)aPattern);
        }
    }

    private void checkParameter(LineText aParam) {
        if (!this.mConfig.getParamRegexp().match(aParam.getText())) {
            this.mMessages.add(aParam.getLineNo(), aParam.getColumnNo(), "name.invalidPattern", (Object)aParam.getText(), (Object)this.mConfig.getParamPat());
        }
    }

    private void checkPackageName(LineText aName) {
        RE packageRegexp = this.mConfig.getPackageRegexp();
        if (!packageRegexp.match(aName.getText())) {
            this.mMessages.add(aName.getLineNo(), aName.getColumnNo(), "name.invalidPattern", (Object)aName.getText(), (Object)this.mConfig.getPackagePat());
        }
    }

    private String[] extractCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] retVal;
        if (aStartLineNo == aEndLineNo) {
            retVal = new String[]{this.mLines[aStartLineNo - 1].substring(aStartColNo, aEndColNo + 1)};
        } else {
            retVal = new String[aEndLineNo - aStartLineNo + 1];
            retVal[0] = this.mLines[aStartLineNo - 1].substring(aStartColNo);
            int i = aStartLineNo;
            while (i < aEndLineNo) {
                retVal[i - aStartLineNo + 1] = this.mLines[i];
                ++i;
            }
            retVal[retVal.length - 1] = this.mLines[aEndLineNo - 1].substring(0, aEndColNo + 1);
        }
        return retVal;
    }

    private String[] getJavadocBefore(int aLineNo) {
        int lineNo = aLineNo - 1;
        while (lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo))) {
            --lineNo;
        }
        return (String[])this.mComments.get(new Integer(lineNo));
    }

    private boolean lineIsBlank(int aLineNo) {
        return "".equals(this.mLines[aLineNo].trim());
    }

    private boolean lineIsComment(int aLineNo) {
        return MATCH_SINGLELINE_COMMENT.match(this.mLines[aLineNo]);
    }

    private List getMethodTags(String[] aLines, int aLastLineNo) {
        ArrayList<JavadocTag> tags = new ArrayList<JavadocTag>();
        int currentLine = aLastLineNo - aLines.length;
        int i = 0;
        while (i < aLines.length) {
            ++currentLine;
            if (MATCH_JAVADOC_ARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_ARG.getParen(1), MATCH_JAVADOC_ARG.getParen(2)));
            } else if (MATCH_JAVADOC_NOARG.match(aLines[i])) {
                tags.add(new JavadocTag(currentLine, MATCH_JAVADOC_NOARG.getParen(1)));
            } else if (MATCH_JAVADOC_MULTILINE_START.match(aLines[i])) {
                String p1 = MATCH_JAVADOC_MULTILINE_START.getParen(1);
                String p2 = MATCH_JAVADOC_MULTILINE_START.getParen(2);
                int remIndex = i + 1;
                while (remIndex < aLines.length) {
                    if (MATCH_JAVADOC_MULTILINE_CONT.match(aLines[remIndex])) {
                        remIndex = aLines.length;
                        String lFin = MATCH_JAVADOC_MULTILINE_CONT.getParen(1);
                        if (!lFin.equals(NEXT_TAG) && !lFin.equals(END_JAVADOC)) {
                            tags.add(new JavadocTag(currentLine, p1, p2));
                        }
                    }
                    ++remIndex;
                }
            }
            ++i;
        }
        return tags;
    }

    private void checkParamTags(List aTags, List aParams) {
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isParamTag()) continue;
            tagIt.remove();
            boolean found = false;
            ListIterator paramIt = aParams.listIterator();
            while (paramIt.hasNext()) {
                LineText param = (LineText)paramIt.next();
                if (!param.getText().equals(tag.getArg1())) continue;
                found = true;
                paramIt.remove();
                break;
            }
            if (found) continue;
            this.mMessages.add(tag.getLineNo(), "javadoc.unusedTag", (Object)"@param", (Object)tag.getArg1());
        }
        ListIterator paramIt = aParams.listIterator();
        while (paramIt.hasNext()) {
            LineText param = (LineText)paramIt.next();
            this.mMessages.add(param.getLineNo(), param.getColumnNo(), "javadoc.expectedTag", (Object)"@param", (Object)param.getText());
        }
    }

    private void checkReturnTag(List aTags, int aLineNo) {
        boolean found = false;
        ListIterator it = aTags.listIterator();
        while (it.hasNext()) {
            JavadocTag jt = (JavadocTag)it.next();
            if (!jt.isReturnTag()) continue;
            if (found) {
                this.mMessages.add(jt.getLineNo(), "javadoc.return.duplicate");
            }
            found = true;
            it.remove();
        }
        if (!found) {
            this.mMessages.add(aLineNo, "javadoc.return.expected");
        }
    }

    private void checkThrowsTags(List aTags, List aThrows) {
        HashSet<String> foundThrows = new HashSet<String>();
        ListIterator tagIt = aTags.listIterator();
        while (tagIt.hasNext()) {
            JavadocTag tag = (JavadocTag)tagIt.next();
            if (!tag.isThrowsTag()) continue;
            tagIt.remove();
            String documentedEx = tag.getArg1();
            boolean found = foundThrows.contains(documentedEx);
            ListIterator throwIt = aThrows.listIterator();
            while (!found && throwIt.hasNext()) {
                LineText t = (LineText)throwIt.next();
                if (!t.getText().equals(documentedEx)) continue;
                found = true;
                throwIt.remove();
                foundThrows.add(documentedEx);
            }
            if (found) continue;
            boolean reqd = true;
            if (this.mConfig.isCheckUnusedThrows()) {
                ClassResolver cr = new ClassResolver(this.mConfig.getClassLoader(), this.mPkgName, this.mImports);
                try {
                    Class clazz = cr.resolve(tag.getArg1());
                    reqd = !(class$java$lang$RuntimeException == null ? Verifier.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException).isAssignableFrom(clazz) && !(class$java$lang$Error == null ? Verifier.class$("java.lang.Error") : class$java$lang$Error).isAssignableFrom(clazz);
                }
                catch (ClassNotFoundException e) {
                    this.mMessages.add(tag.getLineNo(), "javadoc.classInfo", (Object)"@throws", (Object)tag.getArg1());
                }
            }
            if (!reqd) continue;
            this.mMessages.add(tag.getLineNo(), "javadoc.unusedTag", (Object)"@throws", (Object)tag.getArg1());
        }
        ListIterator throwIt = aThrows.listIterator();
        while (throwIt.hasNext()) {
            LineText t = (LineText)throwIt.next();
            this.mMessages.add(t.getLineNo(), t.getColumnNo() - 1, "javadoc.expectedTag", (Object)"@throws", (Object)t.getText());
        }
    }

    private void checkHeader() {
        if (this.mConfig.getHeaderLines().length > this.mLines.length) {
            this.mMessages.add(1, "header.missing");
        } else {
            int i = 0;
            while (i < this.mConfig.getHeaderLines().length) {
                if (!this.mConfig.isHeaderIgnoreLineNo(i + 1)) {
                    String headerLine = this.mConfig.getHeaderLines()[i];
                    try {
                        boolean match;
                        boolean bl = match = this.mConfig.getHeaderLinesRegexp() ? Utils.getRE(headerLine).match(this.mLines[i]) : headerLine.equals(this.mLines[i]);
                        if (!match) {
                            this.mMessages.add(i + 1, "header.mismatch", (Object)this.mConfig.getHeaderLines()[i]);
                            break;
                        }
                    }
                    catch (RESyntaxException e) {
                        this.mMessages.add(i + 1, "regexp.parseError", (Object)headerLine);
                    }
                }
                ++i;
            }
        }
    }

    private void checkModOrder(MyModifierSet aModSet) {
        MyCommonAST error = aModSet.checkOrderSuggestedByJLS();
        if (error != null) {
            this.mMessages.add(error.getLineNo(), error.getColumnNo(), "mod.order", (Object)error.getText());
        }
    }

    private String basename(String aType) {
        int i = aType.lastIndexOf(".");
        return i == -1 ? aType : aType.substring(i + 1);
    }

    private void checkImports() {
        if (this.mConfig.isIgnoreImports()) {
            return;
        }
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            LineText imp = (LineText)it.next();
            if (Verifier.fromPackage(imp.getText(), "java.lang")) {
                this.mMessages.add(imp.getLineNo(), "import.lang");
                continue;
            }
            if (Verifier.fromPackage(imp.getText(), this.mPkgName)) {
                this.mMessages.add(imp.getLineNo(), "import.same");
                continue;
            }
            if (!this.isReferencedImport(imp)) {
                this.mMessages.add(imp.getLineNo(), "import.unused", (Object)imp.getText());
                continue;
            }
            if (!this.isIllegalImport(imp.getText())) continue;
            this.mMessages.add(imp.getLineNo(), "import.illegal", (Object)imp.getText());
        }
    }

    private boolean isReferencedImport(LineText aImp) {
        if (aImp.getText().endsWith(".*")) {
            return true;
        }
        String impText = aImp.getText();
        return this.mReferenced.contains(this.basename(impText)) || this.mReferenced.contains(impText);
    }

    private boolean isIllegalImport(String aImportText) {
        Iterator it = this.mConfig.getIllegalImports().iterator();
        while (it.hasNext()) {
            String illegalPkgName = (String)it.next();
            if (!aImportText.startsWith(illegalPkgName + ".")) continue;
            return true;
        }
        return false;
    }

    private String getIllegalInstantiation(String aClassName) {
        Set illegalInsts = this.mConfig.getIllegalInstantiations();
        String javaLang = "java.lang.";
        if (illegalInsts.contains(aClassName)) {
            return aClassName;
        }
        int clsNameLen = aClassName.length();
        int pkgNameLen = this.mPkgName == null ? 0 : this.mPkgName.length();
        Iterator illIter = illegalInsts.iterator();
        while (illIter.hasNext()) {
            String illegal = (String)illIter.next();
            int illegalLen = illegal.length();
            if (illegalLen - "java.lang.".length() == clsNameLen && illegal.endsWith(aClassName) && illegal.startsWith("java.lang.")) {
                return illegal;
            }
            if (this.mPkgName != null && clsNameLen == illegalLen - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(aClassName) && illegal.startsWith(this.mPkgName)) {
                return illegal;
            }
            Iterator importIter = this.mImports.iterator();
            while (importIter.hasNext()) {
                LineText importLineText = (LineText)importIter.next();
                String importArg = importLineText.getText();
                if (importArg.endsWith(".*")) {
                    String fqClass = importArg.substring(0, importArg.length() - 1) + aClassName;
                    if (!illegalInsts.contains(fqClass)) continue;
                    return fqClass;
                }
                if (!this.basename(importArg).equals(aClassName) || !illegalInsts.contains(importArg)) continue;
                return importArg;
            }
        }
        return null;
    }

    private boolean inInterfaceBlock() {
        return !this.mInInterface.empty() && Boolean.TRUE.equals(this.mInInterface.peek());
    }

    private boolean inMethodBlock() {
        return this.mMethodBlockLevel > 0;
    }

    private static boolean fromPackage(String aImport, String aPkg) {
        boolean retVal = false;
        if (aPkg == null) {
            retVal = aImport.indexOf(46) == -1;
        } else {
            int index = aImport.lastIndexOf(46);
            if (index != -1) {
                String front = aImport.substring(0, index);
                retVal = front.equals(aPkg);
            }
        }
        return retVal;
    }

    private void checkLCurly(int aStartLine, MyCommonAST aBrace, LeftCurlyOption aOption) {
        int prevLineLen;
        this.verifyWSAroundBegin(aBrace.getLineNo(), aBrace.getColumnNo() + 1, aBrace.getText());
        String braceLine = this.mLines[aBrace.getLineNo() - 1];
        int n = prevLineLen = aBrace.getLineNo() == 1 ? this.mConfig.getMaxLineLength() : Utils.lengthMinusTrailingWhitespace(this.mLines[aBrace.getLineNo() - 2]);
        if (aOption != LeftCurlyOption.IGNORE && (braceLine.length() <= aBrace.getColumnNo() + 1 || braceLine.charAt(aBrace.getColumnNo() + 1) != '}')) {
            if (aOption == LeftCurlyOption.NL) {
                if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                }
            } else if (aOption == LeftCurlyOption.EOL) {
                if (Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine) && prevLineLen + 2 <= this.mConfig.getMaxLineLength()) {
                    this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", (Object)"{");
                }
            } else if (aOption == LeftCurlyOption.NLOW && aStartLine != aBrace.getLineNo()) {
                if (aStartLine + 1 == aBrace.getLineNo()) {
                    if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                        this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                    } else if (prevLineLen + 2 <= this.mConfig.getMaxLineLength()) {
                        this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.previous", (Object)"{");
                    }
                } else if (!Utils.whitespaceBefore(aBrace.getColumnNo(), braceLine)) {
                    this.mMessages.add(aBrace.getLineNo(), aBrace.getColumnNo(), "line.new", (Object)"{");
                }
            }
        }
    }

    void checkWSAfter(int aLineNo, int aColNo, MyToken aConstruct, String aAllow) {
        if (this.mConfig.isIgnoreWhitespace() || MyToken.CAST == aConstruct && this.mConfig.isIgnoreCastWhitespace()) {
            return;
        }
        String line = this.mLines[aLineNo - 1];
        if (aColNo < line.length() && !Character.isWhitespace(line.charAt(aColNo)) && aAllow.indexOf(line.charAt(aColNo)) == -1) {
            this.mMessages.add(aLineNo, aColNo, "ws.notFollowed", (Object)aConstruct.getText());
        }
    }

    void checkBlock(String aType, BlockOption aOption, MyCommonAST[] aBraces, boolean aNoStmt) {
        if (aNoStmt && aOption == BlockOption.STMT) {
            this.mMessages.add(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "block.noStmt");
        } else if (aOption == BlockOption.TEXT) {
            if (aBraces[0].getLineNo() == aBraces[1].getLineNo()) {
                String txt = this.mLines[aBraces[0].getLineNo() - 1].substring(aBraces[0].getColumnNo() + 1, aBraces[1].getColumnNo());
                if (txt.trim().length() == 0) {
                    this.mMessages.add(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "block.empty", (Object)aType);
                }
            } else if (this.mLines[aBraces[0].getLineNo() - 1].substring(aBraces[0].getColumnNo() + 1).trim().length() == 0 && this.mLines[aBraces[1].getLineNo() - 1].substring(0, aBraces[1].getColumnNo()).trim().length() == 0) {
                boolean isBlank = true;
                int i = aBraces[0].getLineNo();
                while (i < aBraces[1].getLineNo() - 1) {
                    if (this.mLines[i].trim().length() > 0) {
                        isBlank = false;
                        break;
                    }
                    ++i;
                }
                if (isBlank) {
                    this.mMessages.add(aBraces[0].getLineNo(), aBraces[0].getColumnNo(), "block.empty", (Object)aType);
                }
            }
        }
    }

    private void calculateTypeName() {
        this.mCurrentTypeName = "";
        Iterator it = this.mTypeNames.iterator();
        if (it.hasNext()) {
            this.mCurrentTypeName = (String)it.next();
        }
        while (it.hasNext()) {
            this.mCurrentTypeName = this.mCurrentTypeName + "." + (String)it.next();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MATCH_JAVADOC_ARG_PAT = MATCH_JAVADOC_ARG_PAT;
        MATCH_JAVADOC_ARG = Verifier.createRE(MATCH_JAVADOC_ARG_PAT);
        MATCH_SINGLELINE_COMMENT_PAT = MATCH_SINGLELINE_COMMENT_PAT;
        MATCH_SINGLELINE_COMMENT = Verifier.createRE(MATCH_SINGLELINE_COMMENT_PAT);
        MATCH_JAVADOC_MULTILINE_START_PAT = MATCH_JAVADOC_MULTILINE_START_PAT;
        MATCH_JAVADOC_MULTILINE_START = Verifier.createRE(MATCH_JAVADOC_MULTILINE_START_PAT);
        MATCH_JAVADOC_MULTILINE_CONT_PAT = MATCH_JAVADOC_MULTILINE_CONT_PAT;
        MATCH_JAVADOC_MULTILINE_CONT = Verifier.createRE(MATCH_JAVADOC_MULTILINE_CONT_PAT);
        END_JAVADOC = END_JAVADOC;
        NEXT_TAG = NEXT_TAG;
        MATCH_JAVADOC_NOARG_PAT = MATCH_JAVADOC_NOARG_PAT;
        MATCH_JAVADOC_NOARG = Verifier.createRE(MATCH_JAVADOC_NOARG_PAT);
        MATCH_JAVADOC_AUTHOR_PAT = MATCH_JAVADOC_AUTHOR_PAT;
        MATCH_JAVADOC_AUTHOR = Verifier.createRE(MATCH_JAVADOC_AUTHOR_PAT);
        MATCH_JAVADOC_VERSION_PAT = MATCH_JAVADOC_VERSION_PAT;
        MATCH_JAVADOC_VERSION = Verifier.createRE(MATCH_JAVADOC_VERSION_PAT);
    }
}

