/* Copyright (c) 2007-2008, by V0id
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <QtCore>
#include <QImageReader>
#include <QImage>
#include <QDir>
#include <iostream>
#include <QTextStream>
#include <string.h>
#include "xmlwriter.h"
QTextStream consoleOut(stdout);

void help(char *AppName)
{
		consoleOut<<QObject::tr("To convert smiles from Bombus or Bombus MOD to Psi.\n\nYou have to extract form jar archive 2 files:\nsmiles.png and smiles.txt wich are located in images direcrory\n\n");//<<std::endl<<std::endl;
		consoleOut<<(QObject::tr("\n\t %1 [smiles.png smiles.txt] [-up]\n").arg(AppName));
		consoleOut<<(QObject::tr("\n\t -up - turns off replasing of special symbols in xml (deprecated)\n\n"));
}
int main(int argc, char *argv[])
{
	QString InSmilesFilename("smiles.png");
	QString InSmilesTxtFilename("smiles.txt");
	qint32 oneImageSize;
	QString PackageName;

	QCoreApplication a(argc, argv);
	
	consoleOut<<endl<<(QObject::tr("Bombus to Psi smile convertor\nCopyright 2007-2008 by V0id\n"))<<endl;
	if(argc == 2 && !(strcmp(argv[1],"-h") ))
	{
		help(argv[0]);
		exit(0);
	}

	if(argc == 2)
		InSmilesFilename = argv[1];
	if(argc == 3)
		InSmilesTxtFilename = argv[2];

	QImage allSmiles(InSmilesFilename);
	if(allSmiles.isNull())
	{
		help(argv[0]);
		consoleOut<<(QObject::tr("Can\'t open file %1 for reading").arg(InSmilesFilename))<<endl;
		exit(1);
	}
	QFile smilesTxt(InSmilesTxtFilename);
	if( !smilesTxt.open(QIODevice::ReadOnly|QIODevice::Text))
	{
		help(argv[0]);
		consoleOut<<(QObject::tr("Can\'t open file %1 for reading").arg(InSmilesTxtFilename))<<endl;
		exit(4);
	}

	consoleOut<<QObject::tr("Enter name for smilepack: ");
	consoleOut.flush();
	QTextStream console(stdin);
	PackageName=console.readLine();
		
	QDir dir;
	dir.mkdir(PackageName);

	QFile iconDef(QDir::toNativeSeparators(QString ("%1/icondef.xml").arg(PackageName)));
	XmlWriter *outXml;
	try
	{
		outXml = new XmlWriter(&iconDef);
	}
	catch(QString &str)
	{
		consoleOut<<str<<endl;
		exit(3);
	}
	outXml->setAutoNewLine(true);
	outXml->writeOpenTag("icondef");
	outXml->writeOpenTag("meta");
	outXml->writeTaggedString("name", PackageName);
	outXml->writeCloseTag("meta");
	
	if( argc == 4 && !(strcmp(argv[3],"-up")) )
		outXml->setSymbolProtection(false);
	if( argc == 2 && !(strcmp(argv[1],"-up")) )
		outXml->setSymbolProtection(false);
	oneImageSize = (allSmiles.size()).width()/16;
	QTextStream smilesDef(&smilesTxt);
	
	int numSmile=1;
	for(int row=0; row<((allSmiles.size()).height()/oneImageSize); row++)
	{
		QRect smile(0,row*oneImageSize, oneImageSize, oneImageSize);
		for(int column=0; column<16; column++)
		{
			if(!smilesDef.atEnd())
			{
				outXml->writeOpenTag("icon");
				QString smlDef = smilesDef.readLine();
				QStringList spl = smlDef.split("\t");
				int cnt;
				for(cnt=0; cnt<spl.size(); cnt++)
				{
					if(spl[cnt].isEmpty())
						continue;
					outXml->writeTaggedString("text", spl[cnt]);
				}
				//Writing again firs mnemonix for compability with different Psi versions
				if(cnt>1)
					outXml->writeTaggedString("text", spl[0]);
				QImage img = allSmiles.copy(oneImageSize*column, row*oneImageSize, oneImageSize, oneImageSize);
				img.save(QDir::toNativeSeparators (QString ("%1/%2.png").arg(PackageName).arg(numSmile,3,10,QChar('0'))),"PNG");

				AttrMap attrs;
				attrs.insert("mime","image/png");
				outXml->writeTaggedString("object",QString ("%1.png").arg(numSmile,3,10,QChar('0')),attrs);
				outXml->writeCloseTag("icon");
				numSmile++;
			}
			else
				break;
		}
	}

	outXml->writeCloseTag("icondef");
	return 0;
}
