# Programmer: Daniel Pozmanter
# E-mail:   drpython@bluebottle.com
# Note:   You must reply to the verification e-mail to get through.
#
# Copyright 2003-2004 Daniel Pozmanter
#
# Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Plugin

#Python Debugger Support

#Version: 0.0.2, 08.04.2007.

import sys, os.path
import wx, wx.lib.dialogs
import drPrefsFile
from drPreferences import drPreferences
def MsgBox (window, string):
    wx.MessageBox(window, string, 'Debuging', wx.OK)

def OnAbout(DrFrame):
    NameAndVersion = "Python Checker Support:\n\nVersion: 0.0.2\n"
    AboutString = NameAndVersion + "By Nathan Jones\nBased on code by Daniel Pozmanter\n\nReleased under the GPL."
    d = wx.lib.dialogs.ScrolledMessageDialog(DrFrame, AboutString, "About")
    d.ShowModal()
    d.Destroy()

def OnHelp(DrFrame):
    HelpString = "To install set the location of checker.py in the preferences\n"
    HelpString = HelpString + "Then run using the menu option"
    d = wx.lib.dialogs.ScrolledMessageDialog(DrFrame, HelpString, "Help")
    d.ShowModal()
    d.Destroy()
    
def OnPreferences(DrFrame):
    dlg = wx.FileDialog(DrFrame, "Select Pychecker", "", "", "Python Source (*.py *.pyw)|*.py;*.pyw", wx.OPEN)
    if dlg.ShowModal() == wx.ID_OK:
        PycheckLocation = dlg.GetPath()
        f = file(DrFrame.pluginspreferencesdirectory + "/Pycheck.preferences.dat", 'w')
        f.write("<Pycheck.Location>" + PycheckLocation + "</Pycheck.Location>")
        f.close()
    dlg.Destroy()

def UnInstall(DrFrame):
    plugindir = DrFrame.pluginsdirectory
    if os.path.exists(plugindir + "/bitmaps/16/PyCheckerSupport.png"):
        os.remove(plugindir + "/bitmaps/16/PyCheckerSupport.png")
    if os.path.exists(plugindir + "/bitmaps/24/PyCheckerSupportpng"):
        os.remove(plugindir + "/bitmaps/24/PyCheckerSupport.png")
    DrFrame.RemovePluginIcon("PyCheckerSupport")

    return True

def Plugin(DrFrame):

    def OnRunPythonChecker(event):

        if DrFrame.txtDocument.GetModify():
            answer = wx.MessageBox("The file has been modified.\nIt would be wise to save before running.\nWould you like to save the file?", "DrPython", wx.YES_NO | wx.ICON_QUESTION)
            if answer == wx.YES:
                DrFrame.OnSave(event)
        if os.path.exists(DrFrame.pluginspreferencesdirectory + "/Pycheck.preferences.dat"):
            HomeDir = DrFrame.pluginspreferencesdirectory + "/Pycheck.preferences.dat"
            f = file(HomeDir, 'r')
            text = f.read()
            f.close()
            Location = drPrefsFile.ExtractPreferenceFromText(text, "Pycheck.Location")
            if os.path.exists(Location) != True:
                Location = ""
                wx.MessageBox("Location of Pychecker has not been set up.\nPlease set it up first.", "DrPython", wx.OK | wx.ICON_EXCLAMATION)

            if Location != "":
                print '"' + Location + '" "' + DrFrame.txtDocument.filename + '"'
                DrFrame.ExecuteWithPython('"' + Location + '" "' +
                DrFrame.txtDocument.filename + '"')
        else:
            wx.MessageBox("Location of Pychecker has not been set up.\nPlease set it up first.", "DrPython", wx.OK | wx.ICON_EXCLAMATION)

    ID_PYTHON_CHECKER = DrFrame.GetNewId()

    DrFrame.Bind(wx.EVT_MENU, OnRunPythonChecker, id=ID_PYTHON_CHECKER)

    DrFrame.AddPluginFunction("PyCheckerSupport", "Run Python Checker", OnRunPythonChecker)
    
    DrFrame.LoadPluginShortcuts('PyCheckerSupport')
    DrFrame.programmenu.AppendSeparator()
    DrFrame.programmenu.Append(ID_PYTHON_CHECKER, "Check program with python checker", " Check the current program with python checker")