import os,sys,string

from distutils.core import setup, Extension

from distutils.command.build_ext import build_ext
from distutils.command.clean import clean
from distutils.dep_util import newer_group

from distutils.command.config import config

libraries = []
z_incdir = []
z_libdir = []

# Allow setting the zlib dir and additional link flags from the
# command line.
LFLAGS = []
z_LIBS = []

print sys.argv
for arg in sys.argv[:]:
  if string.find(arg, '--zlib-prefix=') == 0:
    ZLIB_DIR = string.split(arg, '=')[1]
    z_incdir = [os.path.join (ZLIB_DIR, 'include')]
    z_libdir = [os.path.join (ZLIB_DIR, 'lib')]
    sys.argv.remove(arg)
  elif string.find(arg, '--zlib=') == 0:
    z_LIBS = string.split(string.split(arg, '=')[1])
    sys.argv.remove(arg)
  elif string.find(arg, '--lflags=') == 0:
    LFLAGS = string.split(string.split(arg, '=')[1])
    sys.argv.remove(arg)

lflags_arg = LFLAGS + z_LIBS

if not z_LIBS:
  libraries.append('z')


def exitstatus_str(st):
  if os.WIFSTOPPED(st):
    return 'stopped: sig %i'%os.WSTOPSIG(st)
  if os.WIFSIGNALED(st):
    return 'killed: sig %i'%os.WTERMSIG(st)
  if os.WIFEXITED(st):
    return 'exit status: %i'%os.WEXITSTATUS(st)
  return '(??: %i)'%st


class PyBuildExt(build_ext):
  def build_extensions(self):
    if newer_group(['configure.in'], 'configure'):
      self.dosystem('autoconf')
    if newer_group(['configure.in'], 'pfconfig.h.in'):
      self.dosystem('autoheader')
    
    if newer_group(['configure','pfconfig.h.in'], 'pfconfig.h'):
      self.dosystem('./configure')

    build_ext.build_extensions(self)

  def dosystem(self, cmd):
      if self.verbose:
        print "running '%s'" % cmd
      if not self.dry_run:
        r=os.system(cmd)
        if r:
          raise Exception, 'dosystem(%r): %s'%(cmd,exitstatus_str(r))
      

class PyTest(PyBuildExt):
  description = "run test suite (build module first if needed)"
  def build_extensions(self):
    PyBuildExt.build_extensions(self)

    # spawnve is only available in 2.x on unix
    #env = os.environ.copy()
    #env['PYTHONPATH'] = os.path.abspath(self.build_lib)
    #odir = os.getcwd()
    #os.chdir('test')
    #os.spawnve(os.P_WAIT, sys.executable, (sys.executable, 'test_fchksum.py', '-v'), env)
    #os.chdir(odir)

    os.environ['PYTHONPATH'] = os.path.abspath(self.build_lib)
    sys.path.insert(0, os.path.abspath(self.build_lib))

    odir = os.getcwd()
    os.chdir('test')
    import unittest
    try:
      unittest.main(module='test_fchksum', argv=['','-v'])
    except SystemExit, ex:
      if ex.code:
        raise Exception, 'unittest returned %s'%(ex)
    os.chdir(odir)
    

class PyClean(clean):
  def run(self):
    for f in ('pfconfig.h', 'config.cache', 'config.log', 'config.status'):
      if os.path.exists(f):
        self.announce("removing '%s'" % f)
        if self.dry_run:
          continue
        os.unlink(f)
    
    clean.run(self)

#config class not really useful in current distutils ver, so stick with autoconf for now
#class PyConfig(config):i
#  def run (self):
#
#    print 'config!'
#
#    config.run(self)


setup(
  name="python-fchksum",
  author="Matthew Mueller",
  author_email="donut@azstarnet.com",
  licence="GPL",
  version="1.6.1",
  url="http://www.azstarnet.com/~donut/programs/fchksum.html",
  description="Python C extension to (quickly) find the checksum of files.",
  cmdclass = {'build_ext':PyBuildExt, 'test':PyTest, 'clean':PyClean},#, 'config':PyConfig},
  ext_modules=[Extension("fchksum", 
                          ["fchksum.c", "md5.c", "cksum.c", "sum.c"],
                          include_dirs = z_incdir,
                          library_dirs = z_libdir,
                          libraries = libraries,
                          extra_link_args = lflags_arg,
                          )
              ],
)

