import unittest, commands, sys, string, os

import fchksum

knownValues = {
	'fmd5': {
		'test0.dat': ('\324\035\214\331\217\000\262\004\351\200\011\230\354\370B~', 0),
		'test1.dat': ('\3651\200\232qe\315=A\034~p`\015a\314', 23),
		'test2.dat': ('p\316^b\346\343\010b\350\321\307\206$\216\245\340', 25)},
	'fmd5t': {
		'test0.dat': ('d41d8cd98f00b204e9800998ecf8427e', 0),
		'test1.dat': ('f531809a7165cd3d411c7e70600d61cc', 23),
		'test2.dat': ('70ce5e62e6e30862e8d1c786248ea5e0', 25)},
#	'fcrc32l': {
#		'test0.dat': (0, 0),
#		'test1.dat': (254251011, 23),
#		'test2.dat': (3232491947L, 25)},
	'fcrc32': {
		'test0.dat': (0, 0),
		'test1.dat': (254251011, 23),
		'test2.dat': (0xC0ABE9AB, 25)},#must specify as hex since it could be negative or positive depending on if longs are >32 bits
	'fcrc32t': {
		'test0.dat': ('00000000', 0),
		'test1.dat': ('0F279003', 23),
		'test2.dat': ('C0ABE9AB', 25)},
#	'fcksuml': {
#		'test0.dat': (4294967295L, 0),
#		'test1.dat': (1456382583, 23),
#		'test2.dat': (584808443, 25)},
	'fcksum': {
		'test0.dat': (0xffffffff, 0),#must specify as hex since it could be negative or positive depending on if longs are >32 bits
		'test1.dat': (1456382583, 23),
		'test2.dat': (584808443, 25)},
	'fcksumt': {
		'test0.dat': ('4294967295', 0),
		'test1.dat': ('1456382583', 23),
		'test2.dat': ('584808443', 25)},
	'fbsdsum': {
		'test0.dat': (0, 0),
		'test1.dat': (59087, 23),
		'test2.dat': (10241, 25)},
	'fbsdsumt': {
		'test0.dat': ('00000', 0),
		'test1.dat': ('59087', 23),
		'test2.dat': ('10241', 25)},
	'fsysvsum': {
		'test0.dat': (0, 0),
		'test1.dat': (3379, 23),
		'test2.dat': (2106, 25)},
	'fsysvsumt': {
		'test0.dat': ('0', 0),
		'test1.dat': ('3379', 23),
		'test2.dat': ('2106', 25)},
}

class fchksumTestBase:
	def test_fmd5(self):
		self.dotest('fmd5')
	def test_fmd5t(self):
		self.dotest('fmd5t')
	def test_fcrc32(self):
		self.dotest('fcrc32')
	def test_fcrc32t(self):
		self.dotest('fcrc32t')
	def test_fcksum(self):
		self.dotest('fcksum')
	def test_fcksumt(self):
		self.dotest('fcksumt')
	def test_fbsdsum(self):
		self.dotest('fbsdsum')
	def test_fbsdsumt(self):
		self.dotest('fbsdsumt')
	def test_fsysvsum(self):
		self.dotest('fsysvsum')
	def test_fsysvsumt(self):
		self.dotest('fsysvsumt')


class functionTestCase(unittest.TestCase, fchksumTestBase):
	def dotest(self, funcname):
		func = getattr(fchksum, funcname)
		for filename, result in knownValues[funcname].items():
			self.assertEqual(func(filename), result)
		self.assertRaises(IOError, func, 'nonexistantfilename')
		self.assertRaises(TypeError, func, 12345)

class ReadErrorTestCase(unittest.TestCase, fchksumTestBase):
	def dotest(self, funcname):
		func = getattr(fchksum, funcname)
		trickdir=os.path.abspath('tricks')
		ppath = os.environ.get('PYTHONPATH', '')
		if string.find(ppath, trickdir)<0:
			if ppath:
				ppath = ppath + ':'
			os.environ['PYTHONPATH'] = ppath + trickdir
		for filename, result in knownValues[funcname].items():
			status,output = commands.getstatusoutput('sf --trick=ReadError '+sys.executable+' -c "import fchksum; print repr(fchksum.%s(\'%s\'))"'%(funcname, filename))
			noSF=''
			if status and string.find(output, 'sf')>=0:
				noSF='\n\nReadErrorTestCase requires SUBTERFUGUE be installed\n'
			self.failUnless(string.find(output, 'IOError')>=0, 'python did not generate IOError exception.  output was: %i: %s'%(status,output)+noSF)	

class stdinTestCase(unittest.TestCase, fchksumTestBase):
	def dotest(self, funcname):
		for filename, result in knownValues[funcname].items():
			status,output = commands.getstatusoutput(sys.executable+' -c "import fchksum; print repr(fchksum.%s(\'\'))" < %s'%(funcname, filename))
			self.assertEqual(status, 0, msg='subprocess exit status %i: %s'%(status,output))
			self.assertEqual(eval(output), result)


if __name__ == '__main__':
	unittest.main()

