import Memory
from Trick import Trick

import errno

import tricklib

class ReadError(Trick):
	def __init__(self, options):
		self.__do_fail = {}

	def callbefore(self, pid, call, args):
	
		if call == 'open':
			getarg = Memory.getMemory(pid).get_string
			if getarg(args[0])[-4:] == ".dat":
				return (0xdeadbeef, None, None, None)
													
		if call == 'read':
			fd = args[0]
			failcount = self.__do_fail.get(fd, 0)
			if failcount:
				if failcount > 5:
					print 'exiting on %ith failed read of %i'%(failcount, fd)
					import sys
					sys.exit(1)
					
				print 'failing read for', fd, '#%i'%failcount
				self.__do_fail[fd] = failcount + 1
				return (None, -errno.EIO, None, None)
#			else:
#				print 'allowing read for',args[0]
	
	def callafter(self, pid, call, result, state):
		if call == 'open' and result != -1:
			self.__do_fail[result] = state==0xdeadbeef
								

	def callmask(self):
		return { 'open' : 1, 'read' : 1, }

