#ifndef _FCHKSUM_H__
#define _FCHKSUM_H__

/*Python.h includes pyconfig.h, which defines everything we need to check..*/
#include "Python.h"

#if SIZEOF_LONG > 4
typedef unsigned long chksum_size_t;
#define chksum_size_reset(size) (size)=0
#define chksum_size_add(size,i) (size)+=i
#elif HAVE_LONG_LONG && SIZEOF_LONG_LONG > 4
typedef unsigned long long chksum_size_t;
#define chksum_size_reset(size) (size)=0
#define chksum_size_add(size,i) (size)+=i
#else
typedef struct {
	unsigned long size0, size1;
} chksum_size_t;
#define chksum_size_reset(size) {(size).size0=0;(size).size1=0;}
#define chksum_size_add(size,i) {(size).size0+=i; if ((size).size0<i) (size).size1++;}
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <time.h>

#ifdef HAVE_GETTIMEOFDAY
# ifdef GETTIMEOFDAY_NO_TZ
#  define CB_TIME_GET(result) gettimeofday(&result)
# else
#  define CB_TIME_GET(result) gettimeofday(&result,NULL)
# endif
# define CB_TIME_CMP(a,b,CMP)          \
	(((a).tv_sec == (b).tv_sec) ?   \
	((a).tv_usec CMP (b).tv_usec) : \
	((a).tv_sec CMP (b).tv_sec))
# define CB_TIME_ADD(a,b,result) \
	do {									      \
		(result).tv_sec = (a).tv_sec + (b).tv_sec;			      \
			(result).tv_usec = (a).tv_usec + (b).tv_usec;			      \
			if ((result).tv_usec >= 1000000)					      \
			{									      \
				++(result).tv_sec;						      \
					(result).tv_usec -= 1000000;					      \
			}									      \
	} while (0)

typedef struct timeval cb_time_t;
#else
# define CB_TIME_GET(result) time(&result)
# define CB_TIME_CMP(a,b,CMP) (a CMP b)
# define CB_TIME_ADD(a,b,result) result = a + b
typedef time_t cb_time_t;
#endif
	
/* buffer size used by all checksum funcs. */

/*#define FCHKSUMBLOCKSIZE (16*1024)*/
#define FCHKSUMBLOCKSIZE (32*1024)
/*#define FCHKSUMBLOCKSIZE (64*1024)*/
/*#define FCHKSUMBLOCKSIZE (128*1024)*/

#define CHKSUM_OK 0
#define CHKSUM_FERROR 1
#define CHKSUM_EXCEPT 2

typedef struct CallbackInfo {
	PyObject *callback;
	cb_time_t delay, next;
} CallbackInfo;

int do_callback(struct CallbackInfo *cbinfo, chksum_size_t size);

#endif
