import os,sys,string

from distutils.core import setup, Extension

from distutils.command.build_ext import build_ext

libraries = []
z_incdir = []
z_libdir = []

# Allow setting the zlib dir and additional link flags from the
# command line.
LFLAGS = []
z_LIBS = []

print sys.argv
for arg in sys.argv[:]:
  if string.find(arg, '--zlib-prefix=') == 0:
    ZLIB_DIR = string.split(arg, '=')[1]
    z_incdir = [os.path.join (ZLIB_DIR, 'include')]
    z_libdir = [os.path.join (ZLIB_DIR, 'lib')]
    sys.argv.remove(arg)
  elif string.find(arg, '--zlib=') == 0:
    z_LIBS = string.split(string.split(arg, '=')[1])
    sys.argv.remove(arg)
  elif string.find(arg, '--lflags=') == 0:
    LFLAGS = string.split(string.split(arg, '=')[1])
    sys.argv.remove(arg)

lflags_arg = LFLAGS + z_LIBS

if not z_LIBS:
  libraries.append('z')


class PyTest(build_ext):
  description = "run test suite (build module first if needed)"
  def build_extensions(self):
    build_ext.build_extensions(self)

    # spawnve is only available in 2.x on unix
    #env = os.environ.copy()
    #env['PYTHONPATH'] = os.path.abspath(self.build_lib)
    #odir = os.getcwd()
    #os.chdir('test')
    #os.spawnve(os.P_WAIT, sys.executable, (sys.executable, 'test_fchksum.py', '-v'), env)
    #os.chdir(odir)

    os.environ['PYTHONPATH'] = os.path.abspath(self.build_lib)
    sys.path.insert(0, os.path.abspath(self.build_lib))

    odir = os.getcwd()
    os.chdir('test')
    import unittest
    try:
      sys.path.insert(1, os.getcwd())
      unittest.main(module='test_fchksum', argv=['','-v'])
    except SystemExit, ex:
      if ex.code:
        raise Exception, 'unittest returned %s'%(ex)
    os.chdir(odir)
    

setup(
  name="python-fchksum",
  author="Matthew Mueller",
  author_email="donut@dakotacom.net",
  license="GPL",
  version="1.7.1",
  url="http://www.dakotacom.net/~donut/programs/fchksum.html",
  description="Python C extension to (quickly) find the checksum of files.",
  cmdclass = {'test':PyTest,},#, 'config':PyConfig},
  ext_modules=[Extension("fchksum", 
                          ["fchksum.c", "md5.c", "cksum.c", "sum.c"],
                          include_dirs = z_incdir,
                          library_dirs = z_libdir,
                          libraries = libraries,
                          extra_link_args = lflags_arg,
                          )
              ],
)

