
"""
__version__ = "$Revision: 1.15 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx
import sys
from PythonCardPrototype import binding, event, registry, widget
#import pprint


class ButtonSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Button'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.MouseClickEvent])
        self._attributes.update({
            'label':{'presence':'mandatory'},
            # KEA don't need style for Button unless we are going to support
            # Win32-specific attributes
            #'style':{'presence':'optional', 'default':'3d', 'values':['3d', 'none']},
            'default':{'presence':'optional', 'default':0}
       })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

"""
b = ButtonSpec()
pprint.pprint(b.name)
pprint.pprint(b.parent)
pprint.pprint(b.events)
pprint.pprint(b._attributes)
"""


class Button(widget.Widget, wx.wxButton):
    """
    A simple push-button with a label.
    """

    _spec = ButtonSpec()

    def __init__(self, aParent,  aResource):
        attributes = ['_default']
        self._createAttributes(attributes)
        widget.Widget.__init__(self, aParent, aResource)
        
        # previously _createDelegate would be called by Widget.__init__
        # so put wxButton.__init__ here
        wx.wxButton.__init__(self,
                    aParent,
                    self.getId(),
                    aResource.label,
                    wx.wxPoint(aResource.position[0], aResource.position[1]),
                    wx.wxSize(aResource.size[0], aResource.size[1]),
                    style = wx.wxCLIP_SIBLINGS,
                    name = aResource.name
                   )

        if not hasattr(self.__class__, '_getLabel'):
            self.__class__._getLabel = self.__class__.GetLabel
        if not hasattr(self.__class__, '_setLabel'):
            self.__class__._setLabel = self.__class__.SetLabel

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)
        
        self._setDefault(aResource.default)

    def _bindEvents(self):
        adapter = ButtonEventBinding(self)
        adapter.bindEvents()

    def _getDefault(self):
        #return self == self._parent.GetDefaultItem()
        # KEA 2002-03-26
        # for some reason wxDialog doesn't have a
        # GetDefaultItem and SetDefaultItem
        try:
            return (self == self._parent.GetDefaultItem()) and self._default
        except:
            return self._default

    def _setDefault(self, aBoolean):
        self._default = aBoolean
        if aBoolean:
            self.SetDefault()
        else:
            # KEA 2002-03-26
            # for some reason wxDialog doesn't have a
            # GetDefaultItem and SetDefaultItem
            try:
                if self == self._parent.GetDefaultItem():
                    self._parent.SetDefaultItem(wx.NULL)
            except:
                pass

    """
    def _getLabel(self):
        return self.GetLabel()
    
    def _setLabel(self, aString):
        self.SetLabel(aString)
    """


class ButtonEventBinding(binding.wxPython_EventBinding):
    """
    Bind the Events supported by event.Button to wxPython.
    """
    def __init__(self, aComponent):
        binding.wxPython_EventBinding.__init__(self, aComponent)

    def bindEvent(self, aEventClass):
        parent = self._component._parent
        if aEventClass is event.MouseClickEvent:
            wx.EVT_BUTTON(parent, self._component.getId(), self._dispatch)

    def _dispatch(self, aWxEvent):
        component = self._component 

        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch(self, aWxEvent):
            return

        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_BUTTON_CLICKED:
            if component._getCommand() is not None:
                evt = event.CommandEvent(component._getCommand(), component)
                evt.setNativeEvent(aWxEvent)
            else:
                evt = self._createEvent(event.MouseClickEvent, aWxEvent)

        if evt is not None:
            component._notifyEventListeners(evt)



# KEA 2001-12-09
# the registry could contain a dictionary of the class, its EventBinding, spec, etc.
# some of those references could be class attributes instead
# it seems like the spec for the class should be part of the class itself
# RDS 2001-16-01
# A new module, registry, contains the ComponentRegistry class.  A Component's
# class now contains it's spec, which contains meta data for it's events
# and attributes.  Components register with the ComponentRegistry.

registry.getRegistry().register(sys.modules[__name__].Button)
