
"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class CheckBoxSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'CheckBox'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend( [event.MouseClickEvent ] )
        self._attributes.update({
            'label' : { 'presence' : 'mandatory' },
            'checked' : { 'presence' : 'optional', 'default' : 0 }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

class CheckBox(widget.Widget, wx.wxCheckBox):
    """
    A check box.
    """

    _spec = CheckBoxSpec()

    def __init__( self, aParent,  aResource ) :
        widget.Widget.__init__( self, aParent, aResource)

        wx.wxCheckBox.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.label, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            style = wx.wxCLIP_SIBLINGS,
            name = aResource.name 
            )

        if not hasattr(self.__class__, '_getLabel'):
            self.__class__._getLabel = self.__class__.GetLabel
        if not hasattr(self.__class__, '_setLabel'):
            self.__class__._setLabel = self.__class__.SetLabel
        if not hasattr(self.__class__, '_getChecked'):
            self.__class__._getChecked = self.__class__.GetValue
        if not hasattr(self.__class__, '_setChecked'):
            self.__class__._setChecked = self.__class__.SetValue

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        #self.setChecked( aResource.checked == 'true' )
        self._setChecked( aResource.checked)
    
    def _bindEvents(self):
        adapter = CheckBoxEventBinding(self)
        adapter.bindEvents()

    """
    def _getLabel( self ) :
        return self.GetLabel()
    
    def _setLabel( self, aString ) :
        self.SetLabel( aString )

    def _setChecked( self, aBoolean ) :
        self.SetValue( aBoolean )

    def _getChecked( self ) :
        return self.GetValue()
    """


class CheckBoxEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.CheckBox to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.MouseClickEvent :
            wx.EVT_CHECKBOX( parent, self._component.getId(), self._dispatch )

    def _dispatch( self, aWxEvent ) :

        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return
        
        evt = None

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_CHECKBOX_CLICKED :
            evt = self._createEvent( event.MouseClickEvent, aWxEvent )

        if evt is not None :
            self._component._notifyEventListeners( evt )


registry.getRegistry().register( sys.modules[__name__].CheckBox )

