
"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2003/04/09 19:11:44 $"
"""

from wxPython import wx
from wxPython import grid

import sys
from PythonCardPrototype import binding, event, registry, widget

class GridSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Grid'
        self.parent = 'Widget'
        self.parentName = self.parent
        """
        self.events.extend([event.SelectEvent, 
                            event.ItemActivatedEvent,
                            event.ItemExpandedEvent,
                            event.ItemExpandingEvent,
                            event.SelectionChangedEvent,
                            event.SelectionChangingEvent,
                            event.KeyDownEvent
                           ])
        """
        self._attributes.update({ 
            #'items' : { 'presence' : 'optional', 'default' : [] },
            #'style' : { 'presence' : 'optional', 'default' : [], 'values' : [ 'horizontal', 'vertical' ] },
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Grid(widget.Widget, grid.wxGrid):
    """
    A Grid.
    """
    
    _spec = GridSpec()

    def __init__(self, aParent, aResource) :
        #attributes = []
        #self._createAttributes(attributes)
        widget.Widget.__init__(self, aParent, aResource)

        grid.wxGrid.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint(aResource.position[ 0 ], aResource.position[ 1 ]), 
            wx.wxSize(aResource.size[ 0 ], aResource.size[ 1 ]), 
            #aResource.items,
            #style = border | wx.wxLC_REPORT | wx.wxCLIP_SIBLINGS,
            name = aResource.name)

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

registry.getRegistry().register(sys.modules[__name__].Grid)

