
"""
__version__ = "$Revision: 1.10 $"
__date__ = "$Date: 2002/04/18 01:51:09 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, graphic, registry, widget

class ImageSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Image'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({
            'file' : { 'presence' : 'mandatory' },
            # KEA shouldn't there be a 'file' attribute here
            # could call it 'image' to match background above
            # but it is mandatory
            #'bitmap' : { 'presence' : 'optional', 'default' : None },
            # KEA kill border for now, until variations of what is possible are worked out
            # use ImageButton if you want images with transparent border
            #'border' : { 'presence' : 'optional', 'default' : '3d', 'values' : [ '3d', 'transparent', 'none' ] }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

class Image(widget.Widget, wx.wxStaticBitmap):
    """
    A static image.
    """

    _spec = ImageSpec()

    def __init__( self, aParent, aResource ) :
        attributes = ['_bitmap', '_file']
        self._createAttributes(attributes)
        self._bitmap = graphic.Bitmap(aResource.file, aResource.size)
        self._file = aResource.file
        widget.Widget.__init__( self, aParent, aResource )

        x = aResource.size[0]
        if x == -2:
            x = self._bitmap.getWidth()
        y = aResource.size[1]
        if y == -2:
            y = self._bitmap.getHeight()
        size = wx.wxSize( x, y )
        #size = wx.wxSize( self._bitmap.GetWidth(), self._bitmap.GetHeight() )

        ##if aResource.border == 'transparent':
        ##    mask = wx.wxMaskColour(self._bitmap, wxBLACK)
        ##    self._bitmap.SetMask(mask)

        wx.wxStaticBitmap.__init__(
            self,
            aParent, 
            self.getId(), # was -1
            self._bitmap.getBits(), 
            aResource.position, 
            size,
            style = wx.wxCLIP_SIBLINGS,
            name = aResource.name
            )

        wx.EVT_WINDOW_DESTROY(self, self._OnDestroy)
        
        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)


    def _OnDestroy(self, event):
        # memory leak cleanup
        self._bitmap = None

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    # KEA added getBitmap, setBitmap
    def _getBitmap( self ) :
        return self._bitmap

    def _setBitmap( self, aValue ) :
        self._bitmap = aValue
        self.SetBitmap( aValue.getBits() )
        # may actually need to refresh the panel as well
        # depending on the size of the new bitmap compared
        # to the old one
        # in addition, the size of the image or imagebutton needs
        # to be set appropriately after changing the bitmap so
        # there are still a few issues to work out
        self.Refresh()

    """
    # KEA do we query the Bitmap to find the actual dimensions
    # _size can contain -1, and -2
    # or provide a special getBitmapSize method?
    # this getSize is actually the same as its parent
    def _getSize( self ) :
        return self.GetSizeTuple()   # get the actual size, not (-1, -1)
    """

    # KEA special handling for -2 size option
    def _setSize( self, aSize ):
        x = aSize[0]
        if x == -2:
            x = self._bitmap.getWidth()
        y = aSize[1]
        if y == -2:
            y = self._bitmap.getHeight()
        self.SetSize( ( x, y ) )

    # KEA 2001-08-02
    # right now the image is loaded from a filename
    # during initialization
    # but later these might not make any sense
    # if setBitmap is used directly in user code
    def _getFile( self ) :
        return self._file

    # KEA 2001-08-14
    # if we're going to support setting the file
    # after initialization, then this will need to handle the bitmap loading
    # overhead
    def _setFile( self, aFile ) :
        self._file = aFile
        self._setBitmap(graphic.Bitmap(aFile))

    def _setBackgroundColor( self, aColor ) :
        aColor = self._getDefaultColor( aColor )
        if self._file == '':
            bmp = self._bitmap.getBits()
            dc = wx.wxMemoryDC()
            dc.SelectObject(bmp)
            dc.SetBackground(wx.wxBrush(aColor))
            dc.Clear()
            dc.SelectObject(wx.wxNullBitmap)
        self.SetBackgroundColour( aColor )
        self.Refresh()   # KEA wxPython bug?


registry.getRegistry().register( sys.modules[__name__].Image )
