
"""
__version__ = "$Revision: 1.11 $"
__date__ = "$Date: 2003/08/06 22:18:12 $"
"""

from wxPython import wx
import sys

from PythonCardPrototype import event, registry, widget
import textfield

class PasswordFieldSpec(textfield.TextFieldSpec):
    def __init__(self):
        textfield.TextFieldSpec.__init__(self)
        
        self.name = 'PasswordField'
        self.parent = 'TextField'
        self.parentName = self.parent
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class PasswordField(textfield.TextField):
    """
    A text field that displays '*' characters in place
    of the actual characters typed - suitable for entering
    passwords securely.
    """

    _spec = PasswordFieldSpec()

    def __init__( self, aParent,  aResource ) :
        ##textfield.TextField.__init__( self, aParent, aResource )

        attributes = ['_border', '_alignment']
        self._createAttributes(attributes)
        self._border = aResource.border
        widget.Widget.__init__( self, aParent, aResource )

        # previously _createDelegate would be called by Widget.__init__
        # so put wxTextCtrl.__init__ here
        if aResource.border == 'none':
            borderStyle = wx.wxNO_BORDER
        else:
            borderStyle = 0

        self._alignment = aResource.alignment

        wx.wxTextCtrl.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.text, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            #style = wx.wxTE_PASSWORD | wx.wxTE_PROCESS_ENTER | borderStyle | wx.wxCLIP_SIBLINGS,
            style = wx.wxTE_PASSWORD | borderStyle | \
                textfield.getAlignment(aResource.alignment) | \
                wx.wxCLIP_SIBLINGS,
            name = aResource.name )

        # we don't call TextField.__init__ so this duplicate code is required
        if not hasattr(self.__class__, '_getText'):
            self.__class__._getText = self.__class__.GetValue
        if not hasattr(self.__class__, '_setText'):
            self.__class__._setText = self.__class__.SetValue
        if not hasattr(self.__class__, '_getEditable'):
            self.__class__._getEditable = self.__class__.IsEditable
        if not hasattr(self.__class__, '_setEditable'):
            self.__class__._setEditable = self.__class__.SetEditable

        self._setEditable( aResource.editable )

        if aResource.border == 'none':
            self.SetBackgroundColour(self.GetParent().GetBackgroundColour())
        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = textfield.TextFieldEventBinding(self)
        adapter.bindEvents()


registry.getRegistry().register( sys.modules[__name__].PasswordField )

