
"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class SliderSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Slider'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.SelectEvent])
        self._attributes.update({ 
            'layout' : { 'presence' : 'optional', 'default' : 'horizontal', 'values' : [ 'horizontal', 'vertical' ]  },
            'min' : { 'presence' : 'optional', 'default' : 0 }, 
            'max' : { 'presence' : 'optional', 'default' : 100 }, 
            'value' : { 'presence' : 'optional', 'default' : 0 } 
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Slider(widget.Widget, wx.wxSlider):
    """
    A slider component.
    """

    _spec = SliderSpec()
    
    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxSlider.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.value, aResource.min, aResource.max,
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            style= self.__getLayout( aResource.layout ) | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        if not hasattr(self.__class__, '_getValue'):
            self.__class__._getValue = self.__class__.GetValue
        if not hasattr(self.__class__, '_setValue'):
            self.__class__._setValue = self.__class__.SetValue
        if not hasattr(self.__class__, '_getMin'):
            self.__class__._getMin = self.__class__.GetMin
        if not hasattr(self.__class__, '_getMax'):
            self.__class__._getMax = self.__class__.GetMax

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        attributes = ['_layout']
        self._createAttributes(attributes)
        self._layout = aResource.layout

    def _bindEvents(self):
        adapter = SliderEventBinding(self)
        adapter.bindEvents()

    def __getLayout( self, aString  ) :
        if aString == 'horizontal' :
            return wx.wxSL_HORIZONTAL
        elif aString == 'vertical' :
            return wx.wxSL_VERTICAL
        else :
            raise 'invalid Slider.layout value: ', aString
            
    def setRange( self, aMin, aMax ) :
        self.SetRange( aMin, aMax )

    """
    def _getValue( self ) :
        return self.GetValue()

    def _setValue( self, aValue ) :
        self.SetValue( aValue )

    def _getMin( self ) :
        return self.GetMin()
    """

    def _setMin( self, aMin ) :
        self.SetRange( aMin, self.GetMax() )

    """
    def _getMax( self ) :
        return self.GetMax()
    """

    def _setMax( self, aMax ) :
        self.SetRange( self.GetMin(), aMax )

    def _getLayout( self ) :
        return self._layout

    def _setLayout( self, aString ) :
        raise AttributeError, "layout attribute is read-only"


class SliderEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.Slider to wxPython.
    """
    def __init__( self, aComponent ) :
        binding.wxPython_EventBinding.__init__( self, aComponent )

                        
    def bindEvent( self, aEventClass ) :
        parent = self._component._parent

        if aEventClass is event.SelectEvent :
            wx.EVT_SLIDER( parent, self._component.getId(), self._dispatch )

    def _dispatch( self, aWxEvent ) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch( self, aWxEvent ) :
            return

        evt = None
        component = self._component

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_SLIDER_UPDATED:
            if component._getCommand() is not None:
                evt = event.CommandEvent(component._getCommand(), component)
                evt.setNativeEvent(aWxEvent)
            else:
                evt = self._createEvent(event.SelectEvent, aWxEvent)

        if evt is not None :
            self._component._notifyEventListeners( evt )


registry.getRegistry().register( sys.modules[__name__].Slider )
