
"""
__version__ = "$Revision: 1.3 $"
__date__ = "$Date: 2002/09/05 18:45:44 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget


class StaticBoxSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'StaticBox'
        self.parent = 'Widget'
        self.parentName = self.parent
        self._attributes.update({
            'label' : { 'presence' : 'optional', 'default' : '' }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class StaticBox(widget.Widget, wx.wxStaticBox):
    """
    A static box is just a box which may be used to group
    controls. The box may have a label.
    """

    _spec = StaticBoxSpec()

    def __init__( self, aParent, aResource ) :
        widget.Widget.__init__( self, aParent, aResource )

        wx.wxStaticBox.__init__(
            self,
            aParent, 
            self.getId(),
            aResource.label,
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ),
            style = wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        if not hasattr(self.__class__, '_getLabel'):
            self.__class__._getLabel = self.__class__.GetLabel
        if not hasattr(self.__class__, '_setLabel'):
            self.__class__._setLabel = self.__class__.SetLabel

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

        attributes = ['_label']
        self._createAttributes(attributes)
        # set attributes directly that can only be set at initialization
        self._label = aResource.label

    def _bindEvents(self):
        adapter = binding.wxPython_EventBinding(self)
        adapter.bindEvents()

    """
    # KEA 2002-03-25
    # this works, but is too much of a hack, wxWindows needs to be fixed
    def _setPosition(self, position):
        self.Move(position)
        size = self.GetSize()
        self.SetSize((size[0], size[1] - 1))
        self.SetSize(size)
    """


registry.getRegistry().register( sys.modules[__name__].StaticBox )
