
"""
__version__ = "$Revision: 1.15 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx
import sys

from PythonCardPrototype import binding, event, registry, widget

class TextFieldSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'TextField'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.KeyPressEvent, 
                event.KeyDownEvent, 
                event.KeyUpEvent, 
                #event.TextEnterEvent,
                event.TextUpdateEvent,
                event.CloseFieldEvent
        ])
        self._attributes.update({
            'text' : {'presence' : 'optional', 'default' : ''},
            'editable' : {'presence' : 'optional', 'default' : 1},
            'alignment' : {'presence' : 'optional', 'default' : 'left', 'values' :['left', 'right', 'center']},
            'border' : {'presence' : 'optional', 'default' : '3d', 'values' : ['3d', 'none']}
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


def getAlignment(aString):
    if aString == 'left':
        return wx.wxTE_LEFT
    elif aString == 'center':
        return wx.wxTE_CENTRE
    elif aString == 'right':
        return wx.wxTE_RIGHT
    else :
        raise 'invalid TextField.alignment value:', aString

class TextField(widget.Widget, wx.wxTextCtrl):
    """
    A text field.
    """

    _spec = TextFieldSpec()

    def __init__( self, aParent,  aResource ) :
        attributes = ['_border', '_alignment']
        self._createAttributes(attributes)
        self._border = aResource.border
        widget.Widget.__init__( self, aParent, aResource )

        # previously _createDelegate would be called by Widget.__init__
        # so put wxTextCtrl.__init__ here
        if aResource.border == 'none':
            borderStyle = wx.wxNO_BORDER
        else:
            borderStyle = 0

        self._alignment = aResource.alignment

        wx.wxTextCtrl.__init__(
            self,
            aParent, 
            self.getId(), 
            aResource.text, 
            wx.wxPoint( aResource.position[ 0 ], aResource.position[ 1 ] ), 
            wx.wxSize( aResource.size[ 0 ], aResource.size[ 1 ] ), 
            #style = wxTE_PROCESS_ENTER | borderStyle | wxCLIP_SIBLINGS,
            style = borderStyle | getAlignment(aResource.alignment) | wx.wxCLIP_SIBLINGS,
            name = aResource.name )

        if not hasattr(self.__class__, '_getText'):
            self.__class__._getText = self.__class__.GetValue
        if not hasattr(self.__class__, '_setText'):
            self.__class__._setText = self.__class__.SetValue
        if not hasattr(self.__class__, '_getEditable'):
            self.__class__._getEditable = self.__class__.IsEditable
        if not hasattr(self.__class__, '_setEditable'):
            self.__class__._setEditable = self.__class__.SetEditable
        # mimic wxSTC method
        if not hasattr(self.__class__, 'ClearAll'):
            self.__class__.ClearAll = self.__class__.Clear

        self._setEditable( aResource.editable )

        if aResource.border == 'none':
            # the erase background event doesn't appear to make the control
            # transparent, so further investigation is required
            #EVT_ERASE_BACKGROUND(delegate, lambda evt: None)
            self.SetBackgroundColour(self.GetParent().GetBackgroundColour())

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = TextFieldEventBinding(self)
        adapter.bindEvents()

    def _getAlignment(self):
        return self._alignment

    def _setAlignment(self, aString):
        raise AttributeError, "alignment attribute is read-only"

    def ClearSelection(self):
        if self.CanCut():
            # delete the current selection,
            # if we can't do a Cut we shouldn't be able to delete either
            # which is why i used the test above
            sel = self.replaceSelection('')
        else:
            ins = self.GetInsertionPoint()
            try:
                self.replace(ins, ins + 1, '')
            except:
                pass

    # KEA the methods for retrieving and manipulating the text
    # has to be greatly expanded to match wxPython
    # capabilities or more

##    def _setText( self, aString ) :
##        """Sets the text value and marks the widget as not-modified.
##        aString may contain newline characters if the text widget is multi-line."""
##        self.SetValue( aString )
##
##    def _getText( self ) :
##        """Gets the contents of the widget. Notice that for a multiline text
##        widget, the lines will be separated by (Unix-style) \\n characters,
##        even under Windows where they are separated by a \\r\\n sequence in
##        the native control."""
##        return self.GetValue()
##
##    def _getEditable( self ) :
##        """Returns whether the text widget is editable or read-only."""
##        # KEA the test below doesn't seem to be working, so...
##        #return not self._delegate.GetWindowStyleFlag() & wxTE_READONLY
##        return self.IsEditable()
##
##    def _setEditable( self, aBoolean ) :
##        """Makes the text widget editable or read-only."""
##        self.SetEditable( aBoolean )

    # KEA new methods to mirror wxPython wxTextCtrl capabilities
    def appendText( self, aString ) :
        """Appends the text to the end of the text widget.
        After the text is appended, the insertion point will be at the end
        of the text widget. If this behavior is not desired, the programmer
        should use getInsertionPoint and setInsertionPoint."""
        self.AppendText( aString )

    def canCopy( self ) :
        return self.CanCopy()

    def canCut( self ) :
        return self.CanCut()

    def canPaste( self ) :
        return self.CanPaste()

    def canRedo( self ) :
        return self.CanRedo()

    def canUndo( self ) :
        return self.CanUndo()

    def clear( self ) :
        self.Clear()

    def copy( self ) :
        self.Copy()

    def cut( self ) :
        self.Cut()

    def discardEdits( self ) :
        self.DiscardEdits()
    
    def getInsertionPoint( self ) :
        return self.GetInsertionPoint()

    def getLastPosition( self ) :
        return self.GetLastPosition()

    def getLineLength( self, aLineNumber ) :
        return self.GetLineLength( aLineNumber )

    def getLineText( self, aLineNumber ) :
        return self.GetLineText( aLineNumber )

    def getNumberOfLines( self ) :
        return self.GetNumberOfLines()

    def getSelection( self ) :
        return self.GetSelection()

    def getNumberOfLines( self ) :
        return self.GetNumberOfLines()

    # KEA rename to getModified?
    def isModified( self ) :
        """Returns 1 if the text has been modified, 0 otherwise."""
        return self.IsModified()

    # KEA support LoadFile? If so, it only makes sense for TextArea
    # many of the other methods only make sense for the multiline TextArea
    # not TextField and PasswordField

    # KEA OnChar ties into our user code handlers and our events,
    # need to think about this one some more

    # KEA OnDropFiles is windows-specific, if you try and call it under *nix
    # what happens? just an exception?

    def paste( self ) :
        self.Paste()

    def positionToXY(self, aPosition):
        result = self.PositionToXY(aPosition)
        if len(result) == 2:
            return result
        else:
            # workaround for wxPython 2.3.2.1
            return (result[1], result[2])

    def redo( self ) :
        self.Redo()

    def remove( self, aFrom, aTo ) :
        self.Remove( aFrom, aTo )

    def replace( self, aFrom, aTo, aString ) :
        # KEA workaround for Replace bug, has the side effect of
        # possibly changing the insertion point
        #self._delegate.Replace( aFrom, aTo, aString )
        i = self.GetInsertionPoint()
        self.Remove( aFrom, aTo )
        self.SetInsertionPoint( aFrom )
        self.WriteText( aString )
        self.SetInsertionPoint( i )

    def replaceSelection(self, aString, select=0):
        """
        if wxPlatform == "__WXMSW__":
            if select:
                sel = self._delegate.GetSelection()
                numNewlines = aString.count('\n')
                self._delegate.WriteText(aString)
                self._delegate.SetSelection( sel[0], sel[0] + len(aString) + numNewlines)
            else:
                self._delegate.WriteText(aString)
        else:
            # Linux
        """
        sel = self.GetSelection()
        self.Remove(sel[0], sel[1])
        self.WriteText(aString)
        if select:
            self.SetSelection(sel[0], sel[0] + len(aString))
        """
        ins = self._delegate.GetInsertionPoint()
        sel = self._delegate.GetSelection()
        self._delegate.Remove( sel[0], sel[1] )
        #self._delegate.SetInsertionPoint( aFrom )
        self._delegate.WriteText( aString )
        self._delegate.SetSelection( ins, ins + len(aString))
        #self._delegate.SetInsertionPoint( i )
        """

    # KEA support SaveFile?

    def setInsertionPoint( self, aPosition ) :
        self.SetInsertionPoint( aPosition )

    def setInsertionPointEnd( self ) :
        self.SetInsertionPointEnd()

    def setSelection( self, aFrom, aTo ) :
        self.SetSelection( aFrom, aTo )

    def showPosition( self, aPosition ) :
        self.ShowPosition( aPosition )

    def undo( self ) :
        self.Undo()

    def writeText( self, aString ) :
        self.WriteText( aString )

    def xyToPosition( self, aX, aY ) :
        return self.XYToPosition( aX, aY )

    def _getBorder( self ) :
        return self._border

    def _setBorder( self, aString ) :
        raise AttributeError, "border attribute is read-only"

    # KEA added 2001-11-13
    # this will be replaced once 2.3.2 has GetStringSelection
    def getStringSelection(self):
        sel = self.getSelection()
        txt = self._getText()
        """
        if wxPlatform == '__WXMSW__':
            numNewlines = txt.count('\n', 0, sel[0])
            start = sel[0] - numNewlines
            # have to special-case a selection to the end of the line
            # this is in a try block to avoid an exception when we index past the end
            # of the string
            try:
                if txt[start + 1] == "\n":
                    start = start + 1
            except:
                pass
            #print numNewlines, start
            numNewlines = txt.count('\n', 0, sel[1])
            end = sel[1] - numNewlines
            # have to special-case a selection to the end of the line
            # this is in a try block to avoid an exception when we index past the end
            # of the string
            try:
                if txt[end + 1] == "\n":
                    end = end + 1
            except:
                pass
            #print numNewlines, end
            selectedText = txt[start:end]
            #print selectedText
        else:
        """
        selectedText = txt[sel[0]:sel[1]]
        return selectedText

    def getString(self, aFrom, aTo):
        return self.GetValue()[aFrom:aTo]


class TextFieldEventBinding( binding.wxPython_EventBinding ) :
    """
    Bind the Events supported by event.TextField to wxPython.
    """
    def __init__( self, aComponent ) :

        binding.wxPython_EventBinding.__init__( self, aComponent )

    def bindEvent( self, aEventClass ) :

        parent = self._component._parent

        if aEventClass is event.CloseFieldEvent :
            event.EVT_CLOSE_FIELD(parent, self._component.getId(), self._dispatch)

        if aEventClass is event.TextUpdateEvent :
            wx.EVT_TEXT( parent, self._component.getId(), self._dispatch )

        # KEA 2001-10-05
        # I don't think this event is used in TextField ?!
        #if aEventClass is TextEnterEvent :
        #    EVT_TEXT_ENTER( parent, self._component.getId(), self._dispatch )

        if aEventClass is event.KeyDownEvent :
            wx.EVT_KEY_DOWN( self._component, self._dispatch )

        if aEventClass is event.KeyUpEvent :
            wx.EVT_KEY_UP( self._component, self._dispatch )

        if aEventClass is event.KeyPressEvent :
            wx.EVT_CHAR( self._component, self._dispatch )

    def _dispatch(self, aWxEvent):
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch(self, aWxEvent):
            if (aWxEvent.GetEventType() == wx.wxEVT_SET_FOCUS):
                try:
                    aWxEvent.GetEventObject().DiscardEdits()
                except:
                    pass

            if (aWxEvent.GetEventType() == wx.wxEVT_KILL_FOCUS):
                try:
                    obj = aWxEvent.GetEventObject()
                    # only wxTextCtrl and wxRightTextCtrl should have IsModified
                    # so an exception will be thrown and the event won't be posted
                    # for other components, but they shouldn't be binding to these
                    # handlers anyway, so I'm just be overly defensive
                    # same with DiscardEdits() above
                    #modified = obj.IsModified()
                    if obj.IsModified():
                        #closeFieldEvent = aWxEvent.Clone()
                        #closeFieldEvent.SetEventType(event.wxEVT_CLOSE_FIELD)
                        # should I be using wx.wxPyEvent() instead?
                        closeFieldEvent = wx.wxWindowCreateEvent()
                        closeFieldEvent.SetEventType(event.wxEVT_CLOSE_FIELD)
                        closeFieldEvent.SetEventObject(aWxEvent.GetEventObject())
                        closeFieldEvent.SetId(aWxEvent.GetId())
                        closeFieldEvent.SetTimestamp(aWxEvent.GetTimestamp())
                        # this is what Robin suggested instead, see:
                        # http://aspn.activestate.com/ASPN/Mail/Message/wxPython-users/1103427
                        #obj.GetParent().GetEventHandler().ProcessEvent(closeFieldEvent)
                        obj.GetEventHandler().ProcessEvent(closeFieldEvent)
                        #wx.wxPostEvent(obj.GetParent(), evt)
                        #print 'posted closeField'
                except:
                    pass
            return
        
        evt = None

        if aWxEvent.GetEventType() == event.wxEVT_CLOSE_FIELD:
            #print 'handling closeField'
            evt = self._createEvent(event.CloseFieldEvent, aWxEvent)

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TEXT_UPDATED :
            evt = self._createEvent( event.TextUpdateEvent, aWxEvent )

        #if aWxEvent.GetEventType() == wxEVT_COMMAND_TEXT_ENTER :
        #    event = self._createEvent( TextEnterEvent, aWxEvent )
            # this should be associated with losing focus, not textEnter
            #self._component._notifyEventListeners( CloseField( self._component ) )

        if aWxEvent.GetEventType() == wx.wxEVT_KEY_DOWN :
            #print '_dispatch wxEVT_KEY_DOWN'
            #evt = KeyDownEvent( self._component )
            evt = self._createEvent( event.KeyDownEvent, aWxEvent )

        if aWxEvent.GetEventType() == wx.wxEVT_KEY_UP :
            #print '_dispatch wxEVT_KEY_UP'
            #evt = KeyUpEvent( self._component )
            evt = self._createEvent( event.KeyUpEvent, aWxEvent )

        if aWxEvent.GetEventType() == wx.wxEVT_CHAR :
            #print '_dispatch wxEVT_CHAR'
            #evt = KeyPressEvent( self._component )
            evt = self._createEvent( event.KeyPressEvent, aWxEvent )

        if evt is not None :
            #print '_dispatch evt is not None'
            self._component._notifyEventListeners( evt )
            #print "after notify"
            
            # KEA 2001-10-05
            # there needs to be an Event.Skip() somewhere if the event was not handled
            # by user code
            # however, skip should normally only be called if the user code didn't process
            # the event, which will allow the user code to "eat" the event, suppressing
            # and/or changing the actions of certain keys
            # need to make a complete list of which events can be eaten and which can't
            if not evt.getUsed():
                aWxEvent.Skip()
                # KEA 2001-10-26
                # if textEnter wasn't handled then focus should move to the next
                # control in the panel, just like pressing tab



registry.getRegistry().register( sys.modules[__name__].TextField )
