"""
__version__ = "$Revision: 1.13 $"
__date__ = "$Date: 2003/07/16 23:06:19 $"
"""

import os
from wxPython import wx

try:
    import Image
    # necessary to avoid name collision with Image class
    from Image import fromstring
    PIL_FOUND = 1
except ImportError:
    PIL_FOUND = 0


def PILToImage(pilImage):
    if (pilImage.mode != 'RGB'):
        pilImage = pilImage.convert('RGB')
    imageData = pilImage.tostring('raw', 'RGB')
    img = wx.wxEmptyImage(pilImage.size[0], pilImage.size[1])
    img.SetData(imageData)
    return img

def PILToBitmap(image):
    return wx.wxBitmapFromImage(PILToImage(image))

def BitmapToPIL(bmp):
    imageData = wx.wxImageFromBitmap(bmp).GetData()
    imagePIL = fromstring('RGB', (bmp.GetWidth(), bmp.GetHeight()), imageData)
    imagePIL = imagePIL.convert('RGB')
    return imagePIL

def numericArrayToImage(array):
    height, width = array.shape[:2]
    img = wx.wxEmptyImage(width, height)
    img.SetData(array.tostring())
    return img


def bitmapType(filename):
    """
    Get the type of an image from the file's extension ( .jpg, etc. )
    """

    if filename == '':
        return None

    name, ext = os.path.splitext(filename)
    ext = ext[1:].upper()
    if ext == 'BMP':
        return wx.wxBITMAP_TYPE_BMP
    elif ext == 'GIF':
        return wx.wxBITMAP_TYPE_GIF
    elif ext == 'JPG' or ext == 'JPEG':
        return wx.wxBITMAP_TYPE_JPEG
    elif ext == 'PCX':
        return wx.wxBITMAP_TYPE_PCX
    elif ext == 'PICT':
        return wx.wxBITMAP_TYPE_PICT
    elif ext == 'PNG':
        return wx.wxBITMAP_TYPE_PNG
    elif ext == 'PNM':
        return wx.wxBITMAP_TYPE_PNM
    elif ext == 'TIF' or ext == 'TIFF':
        return wx.wxBITMAP_TYPE_TIF
    elif ext == 'XBM':
        return wx.wxBITMAP_TYPE_XBM
    elif ext == 'XPM':
        return wx.wxBITMAP_TYPE_XPM
    else:
        # KEA 2001-10-10
        # rather than throw an exception, we could try and have wxPython figure out the image
        # type by returning wxBITMAP_TYPE_ANY
        raise 'invalid graphics format'    # should throw an exception here


class Bitmap :

    def __init__(self, fileName='', size=(0, 0)):
        self._fileName = fileName
        self._size = size
        self._type = None
        self.loadFile()

    def getBits( self ) :
        return self._bits

    def setBits( self, aWxBitmap ) :
        self._bits = aWxBitmap

    def setPILBits(self, image):
        self._bits = PILToBitmap(image)

    def getPILBits(self):
        return BitmapToPIL(self._bits)

    def setImageBits(self, image):
        self._bits = wx.wxBitmapFromImage(image)

    def getImageBits(self):
        return wx.wxImageFromBitmap(self._bits)

    def getHeight( self ) :
        return self._bits.GetHeight()

    def getWidth( self ) :
        return self._bits.GetWidth()

    def getSize( self ) :
        return (self._bits.GetWidth(), self._bits.GetHeight())

    # KEA special handling for -2 size option
    def setSize( self, aSize ):
        raise NotImplementedError

    def getType( self ) :
        return  self._type

    def _getBitmapType( self, filename ) :
        """
        Get the type of an image from the file's extension ( .jpg, etc. )
        """
        # KEA 2001-07-27
        # was
        #name, ext = filename.split( '.' )
        #ext = ext.upper()
        if filename == '':
            return None

        name, ext = os.path.splitext(filename)
        ext = ext[1:].upper()
        if ext == 'BMP':
            return wx.wxBITMAP_TYPE_BMP
        elif ext == 'GIF':
            return wx.wxBITMAP_TYPE_GIF
        elif ext == 'JPG' or ext == 'JPEG':
            return wx.wxBITMAP_TYPE_JPEG
        elif ext == 'PCX':
            return wx.wxBITMAP_TYPE_PCX
        #elif ext == 'PICT':
        #    return wx.wxBITMAP_TYPE_PICT
        elif ext == 'PNG':
            return wx.wxBITMAP_TYPE_PNG
        elif ext == 'PNM':
            return wx.wxBITMAP_TYPE_PNM
        elif ext == 'TIF' or ext == 'TIFF':
            return wx.wxBITMAP_TYPE_TIF
        elif ext == 'XBM':
            return wx.wxBITMAP_TYPE_XBM
        elif ext == 'XPM':
            return wx.wxBITMAP_TYPE_XPM
        else:
            # KEA 2001-10-10
            # rather than throw an exception, we could try and have wxPython figure out the image
            # type by returning wxBITMAP_TYPE_ANY
            raise 'invalid graphics format'    # should throw an exception here

    # xbm format doesn't seem to work on Windows
    def loadFile(self, filename=None, size=None):
        if filename is not None:
            self._fileName = fileName
        if size is not None:
            self._size = size
        self._type = self._getBitmapType(self._fileName)
        if self._type is None:
            self._bits = wx.wxEmptyBitmap(self._size[0], self._size[1])
        else:
            self._bits = wx.wxBitmap( self._fileName, self._type )

    # attempting to save a GIF image will result in a zero length file
    def saveFile(self, filename=None):
        if filename is None:
            filename = self._fileName
        try:
            self._bits.SaveFile(filename, self._getBitmapType(filename))
        except:
            pass

    def rotate90(self, clockwise=1):
        image = wx.wxImageFromBitmap(self._bits)
        self._bits = wx.wxBitmapFromImage(image.Rotate90(clockwise))
