#!/usr/bin/python

"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2003/01/15 18:45:36 $"

"""

from PythonCardPrototype import config, flatfileDatabase, model
import os, sys
import webbrowser

# don't use a .ini
DATA_FILE = 'companies.pickle'
#DATA_FILE = 'companies-recs.xml'

class FlatfileDatabase(flatfileDatabase.FlatfileDatabase):
    def on_openBackground(self, event):
        # override the data filename
        # so a .ini isn't needed
        self.configPath = os.path.join(config.homedir, 'companies')
        if not os.path.exists(self.configPath):
            os.mkdir(self.configPath)
        self.dataFile = os.path.join(self.configPath, DATA_FILE)
        flatfileDatabase.FlatfileDatabase.on_openBackground(self, event)

    def on_mouseUp(self, event):
        #print event.target.name
        name = event.target.name
        if name in ['Profile', 'Symbol', 'Web']:
            url = event.target.text
            if name == 'Symbol':
                if url != '':
                    url = 'http://finance.yahoo.com/q?s=' + url + '&d=t'
            if url.startswith('http://'):
                webbrowser.open(url)


if __name__ == '__main__':
    # dumb check and exit for the pickle file
    # there is almost certainly a better way to deal
    # with a missing data file
    configPath = os.path.join(config.homedir, 'companies')
    if not os.path.exists(configPath):
        os.mkdir(configPath)
    path = os.path.join(configPath, DATA_FILE)
    if not os.path.exists(path):
        print "Please run parse_companies.py first"
        sys.exit()
    
    app = model.PythonCardApp(FlatfileDatabase)
    app.MainLoop()
