#!/usr/bin/python

"""
__version__ = "$Revision: 1.10 $"
__date__ = "$Date: 2002/05/20 00:55:05 $"
"""

from PythonCardPrototype import model

class Conversion:
    def __init__(self, components):
        pass

    def toDown(self, value):
        pass

    def toUp(self, value):
        pass
    
class TemperatureConversion(Conversion):
    def __init__(self, components):
        components.labelUp.text = 'Fahrenheit'
        components.btnConvertUp.label = 'Celsius to Fahrenheit'
        components.btnConvertDown.label = 'Fahrenheit to Celsius'
        components.labelDown.text = 'Celsius'

    def toDown(self, degrees):
        return str(self.FahrenheitToCelsius(float(degrees)))

    def toUp(self, degrees):
        return str(self.CelsiusToFahrenheit(float(degrees)))

    def FahrenheitToCelsius(self, degrees):
        return (degrees - 32.0) / 9.0 * 5.0

    def CelsiusToFahrenheit(self, degrees):
        return degrees * 9.0 / 5.0 + 32.0

class MorseCodeConversion(Conversion):
    def __init__(self, components):
        """
        A B C D E F G
        H I J K L M N
        O P Q R S T U
        V W X Y Z
        """
        self.morseAlphabet = ['.-', '-...', '-.-.', '-..', '.', '..-.', '--.',
                              '....', '..', '.---', '-.-', '.-..', '--', '-.',
                              '---', '.--.', '--.-', '.-.', '...', '-', '..-',
                              '...-', '.--', '-..-', '-.--', '--..']
        
        components.labelUp.text = 'English'
        components.btnConvertUp.label = 'Morse code to English'
        components.btnConvertDown.label = 'English to Morse code'
        components.labelDown.text = 'Morse code'

    def toDown(self, txt):
        return self.convertToMorse(txt)

    def toUp(self, txt):
        return self.convertFromMorse(txt)

    def convertToMorse(self, txt):
        a = ord('A')
        z = ord('Z')
        converted = ''
        for c in txt[:]:
            ordC = ord(c.upper())
            if c == ' ':
                # three spaces between words
                # when you include the space after each character
                converted = converted + '  '
            elif ordC < a or ordC > z:
                return converted + "\n\ncharacter out of bounds, unable to complete conversion"
            else:
                converted += self.morseAlphabet[ordC - a] + ' '
        return converted[:-1]

    def convertFromMorse(self, txt):
        a = ord('A')
        converted = ''
        words = txt.split('  ')
        for w in words:
            letters = w.split(' ')
            for c in letters:
                if c == '':
                    continue
                try:
                    ordC = self.morseAlphabet.index(c)
                except:
                    return converted + "\n\nmorse out of bounds error, unable to complete conversion"
                converted += chr(ordC + a)
            converted += ' '
        return converted

class CurrencyConversion(Conversion):
    def __init__(self, components):
        components.labelUp.text = 'Aussie Dollars'
        components.btnConvertUp.label = 'US Dollars to Aussie Dollars'
        components.btnConvertDown.label = 'Aussie Dollars to US Dollars'
        components.labelDown.text = 'US Dollars'

    def toDown(self, txt):
        return self.convertToUS(txt)

    def toUp(self, txt):
        return self.convertToAus(txt)

    def convert(self, fromCur, toCur, txt):
        import SOAP
        server = SOAP.SOAPProxy('http://services.xmethods.net/soap', \
                        namespace='urn:xmethods-CurrencyExchange')
        try:
            dummy = float(txt)
        except:
            return "Cannot convert anything but numbers"
        try:
            rate = server.getRate(fromCur, toCur)
        except:
            return "Error getting exchange rate"
        return str(float(txt) * rate)

    def convertToUS(self, txt):
        return self.convert('Australia', 'US', txt)

    def convertToAus(self, txt):
        return self.convert('US', 'Australia', txt)

class Conversions(model.Background):

    def on_openBackground(self, event):
        self.conversion = TemperatureConversion(self.components)

    def on_btnConvertDown_mouseClick(self, event):
        self.components.field2.text = self.conversion.toDown(self.components.field1.text)

    def on_btnConvertUp_mouseClick(self, event):
        self.components.field1.text = self.conversion.toUp(self.components.field2.text)
        
    def on_menuConvertMorseCode_select(self, event):
        self.conversion = MorseCodeConversion(self.components)
        self.menuBar.setChecked('menuConvertMorseCode')
        self.menuBar.setChecked('menuConvertTemperature', 0)
        self.menuBar.setChecked('menuConvertCurrency', 0)

    def on_menuConvertTemperature_select(self, event):
        self.conversion = TemperatureConversion(self.components)
        self.menuBar.setChecked('menuConvertMorseCode', 0)
        self.menuBar.setChecked('menuConvertTemperature')
        self.menuBar.setChecked('menuConvertCurrency', 0)

    def on_menuConvertCurrency_select(self, event):
        "We only enable this option if the SOAP module is installed"
        try:
            import SOAP
        except ImportError:
            self.menuBar.setChecked('menuConvertCurrency', 0) 
            self.menuBar.setEnabled('menuConvertCurrency', 0)
            return
        self.conversion = CurrencyConversion(self.components)
        self.menuBar.setChecked('menuConvertMorseCode', 0)
        self.menuBar.setChecked('menuConvertTemperature', 0)
        self.menuBar.setChecked('menuConvertCurrency')

    def on_menuFileExit_select(self, event):
        self.Close()


if __name__ == '__main__':
    app = model.PythonCardApp(Conversions)
    app.MainLoop()
