#!/usr/bin/python

"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2003/08/31 17:23:35 $"
"""

from PythonCardPrototype import model

# events
# itemActivated, itemExpanding, itemExpanded, 
# selectionChanging, selectionChanged

class Minimal(model.Background):

    def on_openBackground(self, event):
        tree = self.components.tree
        root = tree.AddRoot("1")
        tree.SetItemHasChildren(root, 1)
        tree.SelectItem(root)

    def on_tree_itemExpanding(self, event):
        tree = self.components.tree
        item=event.GetItem()
        # This event can happen twice in the self.Expand call
        if tree.IsExpanded(item):
            return
        obj = int(tree.GetItemText(item))
        if tree.GetChildrenCount(item, 0) == 0:
            lst = [obj * 2, (obj *2) + 1]
            for o in lst:
                new_item = tree.AppendItem(item, str(o))
                tree.SetItemHasChildren(new_item, 1)

    def on_menuFileExit_select(self, event):
        self.Close()

if __name__ == '__main__':
    app = model.PythonCardApp(Minimal)
    app.MainLoop()
