#!/usr/bin/python

"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2003/04/09 19:10:21 $"
"""

from PythonCardPrototype import model
from wxPython import wx
from wxPython import grid
import sys

class Minimal(model.Background):

    def on_openBackground(self, event):
        self.log = sys.stdout
        self.moveTo = None

        wx.EVT_IDLE(self, self.OnIdle)
        
        mygrid = self.components.mygrid

        mygrid.CreateGrid(25, 25) #, wxGrid.wxGridSelectRows)
        ##mygrid.EnableEditing(False)

        # simple cell formatting
        mygrid.SetColSize(3, 200)
        mygrid.SetRowSize(4, 45)
        mygrid.SetCellValue(0, 0, "First cell")
        mygrid.SetCellValue(1, 1, "Another cell")
        mygrid.SetCellValue(2, 2, "Yet another cell")
        mygrid.SetCellValue(3, 3, "This cell is read-only")
        mygrid.SetCellFont(0, 0, wx.wxFont(12, wx.wxROMAN, wx.wxITALIC, wx.wxNORMAL))
        mygrid.SetCellTextColour(1, 1, wx.wxRED)
        mygrid.SetCellBackgroundColour(2, 2, wx.wxCYAN)
        mygrid.SetReadOnly(3, 3, True)

        mygrid.SetCellEditor(5, 0, grid.wxGridCellNumberEditor(1,1000))
        mygrid.SetCellValue(5, 0, "123")
        mygrid.SetCellEditor(6, 0, grid.wxGridCellFloatEditor())
        mygrid.SetCellValue(6, 0, "123.34")
        mygrid.SetCellEditor(7, 0, grid.wxGridCellNumberEditor())

        mygrid.SetCellValue(6, 3, "You can veto editing this cell")


        # attribute objects let you keep a set of formatting values
        # in one spot, and reuse them if needed
        attr = grid.wxGridCellAttr()
        attr.SetTextColour(wx.wxBLACK)
        attr.SetBackgroundColour(wx.wxRED)
        attr.SetFont(wx.wxFont(10, wx.wxSWISS, wx.wxNORMAL, wx.wxBOLD))

        # you can set cell attributes for the whole row (or column)
        mygrid.SetRowAttr(5, attr)

        mygrid.SetColLabelValue(0, "Custom")
        mygrid.SetColLabelValue(1, "column")
        mygrid.SetColLabelValue(2, "labels")

        mygrid.SetColLabelAlignment(wx.wxALIGN_LEFT, wx.wxALIGN_BOTTOM)

        #mygrid.SetDefaultCellOverflow(False)
        #r = wx.wxGridCellAutoWrapStringRenderer()
        #mygrid.SetCellRenderer(9, 1, r)

        # overflow cells
        mygrid.SetCellValue( 9, 1, "This default cell will overflow into neighboring cells, but not if you turn overflow off.");
        mygrid.SetCellSize(11, 1, 3, 3);
        mygrid.SetCellAlignment(11, 1, wx.wxALIGN_CENTRE, wx.wxALIGN_CENTRE);
        mygrid.SetCellValue(11, 1, "This cell is set to span 3 rows and 3 columns");



        # test all the events
        grid.EVT_GRID_CELL_LEFT_CLICK(self, self.OnCellLeftClick)
        grid.EVT_GRID_CELL_RIGHT_CLICK(self, self.OnCellRightClick)
        grid.EVT_GRID_CELL_LEFT_DCLICK(self, self.OnCellLeftDClick)
        grid.EVT_GRID_CELL_RIGHT_DCLICK(self, self.OnCellRightDClick)

        grid.EVT_GRID_LABEL_LEFT_CLICK(self, self.OnLabelLeftClick)
        grid.EVT_GRID_LABEL_RIGHT_CLICK(self, self.OnLabelRightClick)
        grid.EVT_GRID_LABEL_LEFT_DCLICK(self, self.OnLabelLeftDClick)
        grid.EVT_GRID_LABEL_RIGHT_DCLICK(self, self.OnLabelRightDClick)

        grid.EVT_GRID_ROW_SIZE(self, self.OnRowSize)
        grid.EVT_GRID_COL_SIZE(self, self.OnColSize)

        grid.EVT_GRID_RANGE_SELECT(self, self.OnRangeSelect)
        grid.EVT_GRID_CELL_CHANGE(self, self.OnCellChange)
        grid.EVT_GRID_SELECT_CELL(self, self.OnSelectCell)

        grid.EVT_GRID_EDITOR_SHOWN(self, self.OnEditorShown)
        grid.EVT_GRID_EDITOR_HIDDEN(self, self.OnEditorHidden)
        grid.EVT_GRID_EDITOR_CREATED(self, self.OnEditorCreated)


        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer1.Add(self.components.mygrid, 1, wx.wxEXPAND)
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()

    def OnCellLeftClick(self, evt):
        self.log.write("OnCellLeftClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnCellRightClick(self, evt):
        self.log.write("OnCellRightClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnCellLeftDClick(self, evt):
        self.log.write("OnCellLeftDClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnCellRightDClick(self, evt):
        self.log.write("OnCellRightDClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnLabelLeftClick(self, evt):
        self.log.write("OnLabelLeftClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnLabelRightClick(self, evt):
        self.log.write("OnLabelRightClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnLabelLeftDClick(self, evt):
        self.log.write("OnLabelLeftDClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()

    def OnLabelRightDClick(self, evt):
        self.log.write("OnLabelRightDClick: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()


    def OnRowSize(self, evt):
        self.log.write("OnRowSize: row %d, %s\n" %
                       (evt.GetRowOrCol(), evt.GetPosition()))
        evt.Skip()

    def OnColSize(self, evt):
        self.log.write("OnColSize: col %d, %s\n" %
                       (evt.GetRowOrCol(), evt.GetPosition()))
        evt.Skip()

    def OnRangeSelect(self, evt):
        if evt.Selecting():
            self.log.write("OnRangeSelect: top-left %s, bottom-right %s\n" %
                           (evt.GetTopLeftCoords(), evt.GetBottomRightCoords()))
        evt.Skip()


    def OnCellChange(self, evt):
        self.log.write("OnCellChange: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))

        # Show how to stay in a cell that has bad data.  We can't just
        # call SetGridCursor here since we are nested inside one so it
        # won't have any effect.  Instead, set coordinants to move to in
        # idle time.
        value = self.components.mygrid.GetCellValue(evt.GetRow(), evt.GetCol())
        if value == 'no good':
            self.moveTo = evt.GetRow(), evt.GetCol()


    def OnIdle(self, evt):
        if self.moveTo != None:
            self.components.mygrid.SetGridCursor(self.moveTo[0], self.moveTo[1])
            self.moveTo = None
        evt.Skip()


    def OnSelectCell(self, evt):
        self.log.write("OnSelectCell: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))

        # Another way to stay in a cell that has a bad value...
        mygrid = self.components.mygrid
        row = mygrid.GetGridCursorRow()
        col = mygrid.GetGridCursorCol()
        if mygrid.IsCellEditControlEnabled():
            mygrid.HideCellEditControl()
            mygrid.DisableCellEditControl()
        value = mygrid.GetCellValue(row, col)
        if value == 'no good 2':
            return  # cancels the cell selection
        evt.Skip()


    def OnEditorShown(self, evt):
        if evt.GetRow() == 6 and evt.GetCol() == 3 and \
           wx.wxMessageBox("Are you sure you wish to edit this cell?",
                        "Checking", wxYES_NO) == wxNO:
            evt.Veto()
            return

        self.log.write("OnEditorShown: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()


    def OnEditorHidden(self, evt):
        if evt.GetRow() == 6 and evt.GetCol() == 3 and \
           wx.wxMessageBox("Are you sure you wish to  finish editing this cell?",
                        "Checking", wx.wxYES_NO) == wx.wxNO:
            evt.Veto()
            return

        self.log.write("OnEditorHidden: (%d,%d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetPosition()))
        evt.Skip()


    def OnEditorCreated(self, evt):
        self.log.write("OnEditorCreated: (%d, %d) %s\n" %
                       (evt.GetRow(), evt.GetCol(), evt.GetControl()))

    def on_menuFileExit_select(self, event):
        self.Close()


if __name__ == '__main__':
    app = model.PythonCardApp(Minimal)
    app.MainLoop()
