
"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2004/01/20 20:40:45 $"
"""

from PythonCardPrototype import model, res
import os
from wxPython import wx

class RunOptionsDialog(model.CustomDialog):
    def __init__(self, aBg, cmdLineArgs):
        model.CustomDialog.__init__(self, aBg)
        
        self.parent = aBg
        
        # if some special setup is necessary, do it here
        self.cmdLineArgs = cmdLineArgs
        self.components.chkDebugMenu.checked = self.cmdLineArgs['debugmenu']
        self.components.chkLogging.checked = self.cmdLineArgs['logging']
        self.components.chkMessageWatcher.checked = self.cmdLineArgs['messagewatcher']
        self.components.chkNamespaceViewer.checked = self.cmdLineArgs['namespaceviewer']
        self.components.chkPropertyEditor.checked = self.cmdLineArgs['propertyeditor']
        self.components.chkShell.checked = self.cmdLineArgs['shell']

        self.initSizers()

    def initSizers(self):
        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer2 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer3 = wx.wxBoxSizer(wx.wxHORIZONTAL)
        comp = self.components
        
        btnFlags = wx.wxLEFT | wx.wxALIGN_BOTTOM
        vertFlags = wx.wxLEFT | wx.wxTOP | wx.wxALIGN_LEFT

        sizer3.Add(comp.btnOK, 1, btnFlags, 5)
        sizer3.Add(comp.btnCancel, 1, btnFlags, 5)

        sizer2.Add(comp.stcCmdLineArgs, 0, wx.wxLEFT | wx.wxBOTTOM | wx.wxALIGN_TOP, 5)
        sizer2.Add(comp.chkDebugMenu, 0, vertFlags, 5)
        sizer2.Add(comp.chkLogging, 0, vertFlags, 5)
        sizer2.Add(comp.chkMessageWatcher, 0, vertFlags, 5)
        sizer2.Add(comp.chkNamespaceViewer, 0, vertFlags, 5)
        sizer2.Add(comp.chkPropertyEditor, 0, vertFlags, 5)
        sizer2.Add(comp.chkShell, 0, vertFlags, 5)
        sizer2.Add((5, 5), 1)  # spacer
        sizer2.Add(sizer3, 1, wx.wxALIGN_BOTTOM | wx.wxEXPAND)

        sizer1.Add(sizer2, 0, vertFlags)
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()

