#ifndef SUN4M_H
#define SUN4M_H

#include "qemu-common.h"

/* Devices used by sparc32 system.  */

/* iommu.c */
void *iommu_init(target_phys_addr_t addr, uint32_t version, qemu_irq irq);
void sparc_iommu_memory_rw(void *opaque, target_phys_addr_t addr,
                                 uint8_t *buf, int len, int is_write);
static inline void sparc_iommu_memory_read(void *opaque,
                                           target_phys_addr_t addr,
                                           uint8_t *buf, int len)
{
    sparc_iommu_memory_rw(opaque, addr, buf, len, 0);
}

static inline void sparc_iommu_memory_write(void *opaque,
                                            target_phys_addr_t addr,
                                            uint8_t *buf, int len)
{
    sparc_iommu_memory_rw(opaque, addr, buf, len, 1);
}

/* tcx.c */
void tcx_init(target_phys_addr_t addr, int vram_size, int width, int height,
              int depth);

/* slavio_intctl.c */
DeviceState *slavio_intctl_init(target_phys_addr_t addr,
                                target_phys_addr_t addrg,
                                const uint32_t *intbit_to_level,
                                qemu_irq **parent_irq, unsigned int cputimer);
void slavio_pic_info(Monitor *mon, void *opaque);
void slavio_irq_info(Monitor *mon, void *opaque);

/* sbi.c */
void *sbi_init(target_phys_addr_t addr, qemu_irq **irq, qemu_irq **cpu_irq,
               qemu_irq **parent_irq);

/* sun4c_intctl.c */
void *sun4c_intctl_init(target_phys_addr_t addr, qemu_irq **irq,
                        qemu_irq *parent_irq);
void sun4c_pic_info(Monitor *mon, void *opaque);
void sun4c_irq_info(Monitor *mon, void *opaque);

/* slavio_timer.c */
void slavio_timer_init_all(target_phys_addr_t base, qemu_irq master_irq,
                           qemu_irq *cpu_irqs, unsigned int num_cpus);

/* slavio_misc.c */
void *slavio_misc_init(target_phys_addr_t base,
                       target_phys_addr_t aux1_base,
                       target_phys_addr_t aux2_base, qemu_irq irq,
                       qemu_irq fdc_tc);
void slavio_set_power_fail(void *opaque, int power_failing);
void apc_init(target_phys_addr_t power_base, qemu_irq cpu_halt);

/* sparc32_dma.c */
#include "sparc32_dma.h"

/* eccmemctl.c */
void ecc_init(target_phys_addr_t base, qemu_irq irq, uint32_t version);

#endif
