\
\ Fcode payload for QEMU VGA graphics card
\
\ This is the Forth source for an Fcode payload to initialise
\ the QEMU VGA graphics card.
\

fcode-version3

\
\ Instead of using fixed values for the framebuffer address and the width
\ and height, grab the ones passed in by QEMU/generated by OpenBIOS
\

: openbios-video-addr
  " openbios-video-addr" $find if
    cell+ @
  then
;

: openbios-video-width
  " openbios-video-width" $find if
    cell+ @
  then
;

: openbios-video-height
  " openbios-video-height" $find if
    cell+ @
  then
;

: qemu-vga-driver-install ( -- )
  openbios-video-addr to frame-buffer-adr
  default-font set-font
  openbios-video-width openbios-video-height over char-width / over char-height /
  fb8-install
;

: qemu-vga-driver-init
  ['] qemu-vga-driver-install is-install
  ;

qemu-vga-driver-init

end0
